/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class SqlBatchUtils {
    public static final Log log = LogFactory.getLog(SqlBatchUtils.class);
    public static final Long noFindId = 0L;
    public static final String noFind = "#";
    public static final int DEFAULT_PAGE_SIZE = 100000;
    private final String sql;
    public static final int BATCH_SIZE = 100;
    public static final int MAX_BATCH_SIZE = 1000;
    private List<Object[]> params = new ArrayList<Object[]>();

    public static SqlBatchUtils getInstance(String sql) {
        return new SqlBatchUtils(sql);
    }

    public static SqlBatchUtils getInstance() {
        return new SqlBatchUtils();
    }

    public static String getBatchParamsSql(int batchSize) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < batchSize; ++i) {
            str.append("?,");
        }
        if (str.length() > 0) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    public SqlBatchUtils() {
        this(null);
    }

    public SqlBatchUtils(String sql) {
        this.sql = sql;
    }

    public static void pagingSave(List<DynamicObject> reportList, String entryKey) {
        SqlBatchUtils.pagingSave(reportList, entryKey, -1);
    }

    public static void pagingSave(List<DynamicObject> reportList, String entryKey, int pageSize) {
        int orm_maxobjects;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entryKey);
        int n = orm_maxobjects = pageSize < 1 ? 100000 : pageSize;
        if (!reportList.isEmpty()) {
            int fetchSize = orm_maxobjects;
            for (int pos = 0; pos <= reportList.size() && fetchSize > 0; pos += fetchSize) {
                fetchSize = orm_maxobjects;
                if (fetchSize > reportList.size() - pos) {
                    fetchSize = reportList.size() - pos;
                }
                if (fetchSize <= 0) continue;
                OperateOption option = OperateOption.create();
                option.setVariableValue("orm_commitPkSnapshot", "true");
                option.setVariableValue("orm_removeDataCache", "true");
                option.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.save((IDataEntityType)dynamicObject.getDynamicObjectType(), (Object[])reportList.subList(pos, pos + fetchSize).toArray(new DynamicObject[0]), (OperateOption)option);
            }
        }
    }

    public void addBatch(Object[] param) {
        this.addBatch(param, true);
    }

    public int[] addBatch(Object[] param, boolean autoExecute) {
        int[] re = null;
        if (param != null) {
            this.params.add(param);
        }
        if (autoExecute && this.params.size() >= 100) {
            re = this.executeBatch();
        }
        return re;
    }

    public int[] executeBatch() {
        int[] re = null;
        if (!this.params.isEmpty()) {
            re = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)this.sql, this.params);
            this.params.clear();
        }
        return re;
    }

    public static void executeBatch(String sql, List<Object> sqlParams, int batchSize) {
        if (StringUtils.isEmpty(sql) || sqlParams == null || sqlParams.isEmpty()) {
            return;
        }
        int size = sqlParams.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        ArrayList _sqlParams = Lists.newArrayListWithCapacity((int)batchSize);
        for (int index = 0; index < count; ++index) {
            _sqlParams.clear();
            int batchIndex = 0;
            while (batchIndex < batchSize) {
                if (pos < size) {
                    _sqlParams.add(sqlParams.get(pos));
                } else {
                    _sqlParams.add(0L);
                }
                ++batchIndex;
                ++pos;
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])_sqlParams.toArray());
        }
    }

    public static Collection<Map<String, Object>> batchQuery(SqlBuilder sqlBuilder) {
        List<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (sqlBuilder == null) {
            return result;
        }
        try (DataSet ds = DB.queryDataSet((String)"batchQuery", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            result = CommonServiceHelper.transDataSet(ds);
        }
        return result;
    }

    public static List<Map<String, Object>> batchQuery(String sql, List<Object> sqlParams) {
        return SqlBatchUtils.batchQuery(sql, sqlParams, 0);
    }

    public static List<Map<String, Object>> batchQuery(String sql, List<Object> sqlParams, int batchSize) {
        if (sql == null || sqlParams == null || sqlParams.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList result = Lists.newLinkedList();
        SqlBatchUtils.batchQuery(sql, null, sqlParams, batchSize, (rowMeta, row) -> result.add(CommonServiceHelper.transDataSetRow(rowMeta, row)));
        return result;
    }

    public static void batchQuery(String sql, DBRoute route, List<Object> sqlParams, int batchSize, BiConsumer<RowMeta, Row> rowConsumer) {
        if (sql == null || sqlParams == null || sqlParams.isEmpty()) {
            return;
        }
        if (batchSize <= 0) {
            batchSize = 1000;
        }
        if (route == null) {
            route = BgBaseConstant.epm;
        }
        int size = sqlParams.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        ArrayList _sqlParams = Lists.newArrayListWithCapacity((int)batchSize);
        for (int index = 0; index < count; ++index) {
            _sqlParams.clear();
            int batchIndex = 0;
            while (batchIndex < batchSize) {
                if (pos < size) {
                    _sqlParams.add(sqlParams.get(pos));
                } else {
                    _sqlParams.add(0L);
                }
                ++batchIndex;
                ++pos;
            }
            try (DataSet ds = DB.queryDataSet((String)"batchQuery", (DBRoute)route, (String)sql, (Object[])_sqlParams.toArray());){
                RowMeta rowMeta = ds.getRowMeta();
                for (Row row : ds) {
                    rowConsumer.accept(rowMeta, row);
                }
                continue;
            }
        }
    }

    public static boolean hasTable(String tableName) {
        return SqlBatchUtils.hasTable(BgBaseConstant.epm, tableName);
    }

    public static boolean hasTable(DBRoute dbRoute, String tableName) {
        if (StringUtils.isEmpty(tableName)) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.notSupported();){
            boolean bl = (Boolean)DB.query((DBRoute)dbRoute, (String)("/*dialect*/select 1 from " + tableName + " where 1 = 2"), rs -> true);
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
    }

    public static boolean hasData(String tableName) {
        if (StringUtils.isEmpty(tableName) || "t_eb_cr0".equals(tableName)) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.notSupported();){
            boolean bl = (Boolean)DB.query((DBRoute)BgBaseConstant.epm, (String)("/*dialect*/select 1 from " + tableName), rs -> rs.next());
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
    }

    public static boolean hasEbData(String tableName, Long modelId) {
        if (StringUtils.isEmpty(tableName)) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.notSupported();){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/*dialect*/select top 1 fmodelid from ").append(tableName).append(" where fmodelid = ").append(modelId);
            boolean bl = (Boolean)DB.query((DBRoute)BgBaseConstant.epm, (String)stringBuilder.toString(), rs -> rs.next());
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
    }

    public static boolean hasColumn(String table, String column) {
        if (StringUtils.isEmpty(table) || StringUtils.isEmpty(column)) {
            return false;
        }
        Set<String> columns = SqlBatchUtils.getColumns(table);
        return columns != null && columns.contains(column);
    }

    public static Set<String> getColumns(String table) {
        if (StringUtils.isEmpty(table)) {
            return null;
        }
        LinkedHashSet columns = Sets.newLinkedHashSet();
        try {
            List _columns = DB.getColumnNames((DBRoute)BgBaseConstant.epm, (String)table);
            if (_columns != null) {
                _columns.forEach(f -> columns.add(f.toLowerCase()));
            }
        }
        catch (Throwable ex) {
            log.error(ex);
            throw ex;
        }
        return columns;
    }

    public static String buildInSql(String preSql, int paramSize) {
        return preSql + "(" + SqlBatchUtils.getBatchParamsSql(paramSize) + ")";
    }
}

