/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UploadUtil {
    private static final Log log = LogFactory.getLog(UploadUtil.class);

    public static List<InputStream> getFileInputStreams(String fileUrl) {
        if (StringUtils.isEmpty(fileUrl)) {
            return Collections.emptyList();
        }
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(urls.size());
        try {
            for (String url : urls) {
                String[] reqParams = new URL(url).getQuery().split("&");
                HashMap map = Maps.newHashMapWithExpectedSize((int)reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                inputStreams.add(content.getInputStream());
            }
        }
        catch (Exception e) {
            log.error("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"Excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%1\u3002", (String)"UploadUtil_0", (String)"epm-eb-common", (Object[])new Object[]{fileUrl}));
        }
        return inputStreams;
    }

    public static List<InputStream> getFileInputStreams(@NotNull IPageCache pageCache, String fileUrl) {
        return UploadUtil.getFileInputStreams(pageCache.get(fileUrl));
    }

    public static InputStream getFileInputStream(String fileUrl) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            String[] reqParams = new URL(fileUrl).getQuery().split("&");
            HashMap map = Maps.newHashMapWithExpectedSize((int)reqParams.length);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
            return content.getInputStream();
        }
        catch (Exception e) {
            log.error("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"Excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%1\u3002", (String)"UploadUtil_0", (String)"epm-eb-common", (Object[])new Object[]{fileUrl}));
        }
    }
}

