/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.log.DebugHelper;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;

public class UserSelectServiceHelperNew {
    public static final String MODEL = "model";
    public static final String defaultFileds = "id,model,application,entity,period,currency,modifier,onlymodel,formid,date,version,bizmodel,modeltype";

    public static void saveUserSelect(UserSelectModel userSelectModel) {
        if (userSelectModel == null || IDUtils.isNull(userSelectModel.getModifier())) {
            return;
        }
        EBThreadPoolExecutor.executeOnce(() -> {
            DynamicObject userSelect;
            try {
                QFilter qf = new QFilter("formid", "=", (Object)" ");
                if (StringUtils.isNotEmpty(userSelectModel.getFormid())) {
                    qf = new QFilter("formid", "=", (Object)userSelectModel.getFormid());
                }
                userSelect = BusinessDataServiceHelper.loadSingle((String)"epm_userselect", (String)defaultFileds, (QFilter[])new QFilter[]{qf, new QFilter("modifier", "=", (Object)userSelectModel.getModifier()), new QFilter("application", "=", (Object)userSelectModel.getApplication().getIndex())});
            }
            catch (Exception e) {
                DebugHelper.debugDataObjectType("epm_userselect", "epm_model");
                throw new RuntimeException(e);
            }
            DynamicObject userSelectObject = userSelect == null ? BusinessDataServiceHelper.newDynamicObject((String)"epm_userselect") : userSelect;
            userSelectObject.set(MODEL, (Object)userSelectModel.getModel());
            if (!userSelectModel.isOnlyModel()) {
                if (userSelectModel.getBizModelId() != null && userSelectModel.getBizModelId() != 0L) {
                    userSelectObject.set("bizmodel", (Object)userSelectModel.getBizModelId());
                }
                if (userSelectModel.getOrg() != null && userSelectModel.getOrg() != 0L) {
                    userSelectObject.set("entity", (Object)userSelectModel.getOrg());
                }
                if (userSelectModel.getPeriod() != null && userSelectModel.getPeriod() != 0L) {
                    userSelectObject.set("period", (Object)userSelectModel.getPeriod());
                }
                if (userSelectModel.getCurrency() != null && userSelectModel.getCurrency() != 0L) {
                    userSelectObject.set("currency", (Object)userSelectModel.getCurrency());
                }
                if (userSelectModel.getVersion() != null && userSelectModel.getVersion() != 0L) {
                    userSelectObject.set("version", (Object)userSelectModel.getVersion());
                }
            } else {
                userSelectObject.set("bizmodel", null);
                userSelectObject.set("entity", null);
                userSelectObject.set("period", null);
                userSelectObject.set("currency", null);
                userSelectObject.set("version", null);
            }
            userSelectObject.set("modifier", (Object)userSelectModel.getModifier());
            userSelectObject.set("application", (Object)userSelectModel.getApplication().getIndex());
            userSelectObject.set("onlymodel", (Object)(userSelectModel.isOnlyModel() ? "1" : "0"));
            userSelectObject.set("formid", (Object)userSelectModel.getFormid());
            userSelectObject.set("date", (Object)userSelectModel.getDate());
            userSelectObject.set("modeltype", (Object)userSelectModel.getModelType());
            SaveServiceHelper.save((IDataEntityType)userSelectObject.getDynamicObjectType(), (Object[])new Object[]{userSelectObject});
        }, "saveUserSelect");
    }

    public static UserSelectModel getUserSelect(Long userId, String selectFileds, ApplicationTypeEnum application, IFormView formView) {
        ArrayList indexList = null;
        if (ApplicationTypeEnum.BGMD == application || ApplicationTypeEnum.BGM == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex()});
        } else if (ApplicationTypeEnum.EB == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.EB.getIndex()});
        } else if (ApplicationTypeEnum.BGC == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BG.getIndex()});
        } else if (ApplicationTypeEnum.BG == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BG.getIndex()});
        } else if (ApplicationTypeEnum.BGBD == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex()});
        } else if (ApplicationTypeEnum.BGRP == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGRP.getIndex()});
        }
        if (indexList != null) {
            indexList.add(ApplicationTypeEnum.BGBD.getIndex());
            indexList.add(ApplicationTypeEnum.BGC.getIndex());
        }
        Set<Long> longs = UserSelectServiceHelperNew.selectPowerModel(application, formView);
        DynamicObjectCollection dynamicObjec = UserSelectServiceHelperNew.queryUserSelectBys(selectFileds, new QFilter[]{new QFilter("modifier", "=", (Object)userId), new QFilter("application", "in", (Object)indexList), new QFilter("date", "is not null", (Object)"")});
        if (!dynamicObjec.isEmpty()) {
            for (DynamicObject dynamicObject : dynamicObjec) {
                if (!longs.contains(dynamicObject.getLong(MODEL))) continue;
                return UserSelectServiceHelperNew.transformDynamicObjectToUserSelect(dynamicObject);
            }
        }
        return null;
    }

    public static DynamicObjectCollection queryUserSelectByTask(IFormView formView) {
        return UserSelectServiceHelperNew.queryUserSelectByForm(defaultFileds, new QFilter[]{new QFilter("modifier", "=", (Object)UserUtils.getUserId()), new QFilter("formid", "=", (Object)formView.getEntityId())});
    }

    public static DynamicObjectCollection queryUserSelectBys(String selectFileds, QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"epm_userselect", (String)selectFileds, (QFilter[])qFilters, (String)"date desc", (int)1);
    }

    public static DynamicObjectCollection queryUserSelectByForm(String selectFileds, QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"epm_userselect", (String)selectFileds, (QFilter[])qFilters);
    }

    public static UserSelectModel transformDynamicObjectToUserSelect(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        UserSelectModel userSelect = new UserSelectModel();
        userSelect.setId(dynamicObject.getLong("id"));
        userSelect.setModel(dynamicObject.getLong(MODEL));
        userSelect.setOrg(dynamicObject.getLong("entity"));
        userSelect.setCurrency(dynamicObject.getLong("currency"));
        userSelect.setModifier(dynamicObject.getLong("modifier"));
        userSelect.setPeriod(dynamicObject.getLong("period"));
        userSelect.setVersion(dynamicObject.getLong("version"));
        userSelect.setApplication(ApplicationTypeEnum.getEnumByIndex(dynamicObject.getString("application")));
        userSelect.setOnlyModel(dynamicObject.getBoolean("onlymodel"));
        userSelect.setFormid(dynamicObject.getString("formid"));
        userSelect.setBizModelId(dynamicObject.getLong("bizmodel"));
        return userSelect;
    }

    public static Long selectRight(IFormView view) {
        String source = UserSelectServiceHelperNew.getViewBillFormId(view);
        ApplicationTypeEnum app = CommonServiceHelper.queryEBApp(view);
        Set<Long> ids = ModelServiceHelper.getLimitedModelListByUser(app);
        Set<Long> haspermids = FunPermissionHelper.getEffectiveByPermModel(source, app);
        Set<Long> perRoleIds = FunPermissionHelper.getRoleModel(UserUtils.getUserId(), "epm_model", app, source, "47150e89000000ac");
        ids.addAll(perRoleIds);
        ids.addAll(haspermids);
        return UserSelectServiceHelperNew.strMoedlChcea(ids, app);
    }

    public static Long strMoedlChcea(Set<Long> ids) {
        return UserSelectServiceHelperNew.strMoedlChcea(ids, null);
    }

    public static Long strMoedlChcea(Set<Long> ids, ApplicationTypeEnum appType) {
        DynamicObjectCollection query;
        QFilter filter = new QFilter("id", "in", ids);
        if (appType != null && (ApplicationTypeEnum.EB == appType || ApplicationTypeEnum.BG == appType || ApplicationTypeEnum.BGMD == appType)) {
            filter.and("reporttype", "=", (Object)appType.getIndex());
        }
        if ((query = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])filter.toArray(), (String)"modifytime DESC", (int)1)).size() > 0) {
            return ((DynamicObject)query.get(0)).getLong("id");
        }
        return 0L;
    }

    public static Set<Long> selectPowerModel(ApplicationTypeEnum application, IFormView formView) {
        String source = UserSelectServiceHelperNew.getViewBillFormId(formView);
        Set<Long> permIdSet = ModelServiceHelper.getLimitedModelListByUser(application);
        ApplicationTypeEnum app = CommonServiceHelper.queryEBApp(formView);
        Set<Long> haspermids = FunPermissionHelper.getEffectiveByPermModel(source, app);
        Long userId = UserUtils.getUserId();
        Set<Long> perRoleIds = ApplicationTypeEnum.BGRP == app ? FunPermissionHelper.getRoleModel(userId, "epm_model", application, source, "47150e89000000ac") : FunPermissionHelper.getRoleModel(userId, "epm_model", app, source, "47150e89000000ac");
        permIdSet.addAll(perRoleIds);
        permIdSet.addAll(haspermids);
        return permIdSet;
    }

    private static String getViewBillFormId(IFormView formView) {
        String source = formView.getEntityId();
        if (formView instanceof ListView && "bos_list".equals(source)) {
            source = ((ListView)formView).getBillFormId();
        } else if (formView instanceof ListView && "bos_templatetreelist".equals(source)) {
            source = ((ListView)formView).getBillFormId();
        } else if (formView instanceof ListView && "bos_treelist".equals(source)) {
            source = ((ListView)formView).getBillFormId();
        }
        return source;
    }

    public static void saveUserSelectBizModel(long modelId, long bizModelId, String formId, String appIndex) {
        EBThreadPoolExecutor.executeOnce(() -> {
            QFilter qfs = new QFilter("modifier", "=", (Object)UserUtils.getUserId());
            qfs.and(new QFilter(MODEL, "=", (Object)modelId));
            qfs.and(new QFilter("bizmodel", "=", (Object)bizModelId));
            qfs.and(new QFilter("formid", "=", (Object)(StringUtils.isNotEmpty(formId) ? formId : " ")));
            qfs.and(new QFilter("application", "=", (Object)appIndex));
            DynamicObject userSelect = BusinessDataServiceHelper.loadSingle((String)"epm_userselect", (String)defaultFileds, (QFilter[])qfs.toArray());
            if (userSelect == null) {
                userSelect = BusinessDataServiceHelper.newDynamicObject((String)"epm_userselect");
                userSelect.set(MODEL, (Object)modelId);
                userSelect.set("bizModel", (Object)bizModelId);
                userSelect.set("modifier", (Object)UserUtils.getUserId());
                userSelect.set("application", (Object)appIndex);
                userSelect.set("formid", (Object)formId);
            }
            userSelect.set("onlymodel", (Object)"0");
            userSelect.set("date", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((IDataEntityType)userSelect.getDynamicObjectType(), (Object[])new Object[]{userSelect});
        }, "");
    }

    public static DynamicObject getUserSelect(IFormView formView, List<String> appTypes) {
        QFilter[] qFilters;
        DynamicObjectCollection userMemorys;
        ApplicationTypeEnum application = ApplicationTypeEnum.getEnumByNumber(formView.getFormShowParameter().getAppId(), formView);
        ArrayList indexList = null;
        if (ApplicationTypeEnum.BGMD == application || ApplicationTypeEnum.BGM == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.BGC.getIndex()});
        } else if (ApplicationTypeEnum.EB == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex()});
        } else if (ApplicationTypeEnum.BGC == application || ApplicationTypeEnum.BGBD == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex(), ApplicationTypeEnum.BGBD.getIndex()});
        } else if (ApplicationTypeEnum.BG == application) {
            indexList = Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BG.getIndex(), ApplicationTypeEnum.BGC.getIndex()});
        }
        if (appTypes != null && !appTypes.isEmpty()) {
            indexList = Lists.newArrayList(appTypes);
        }
        if ((userMemorys = QueryServiceHelper.query((String)"epm_userselect", (String)defaultFileds, (QFilter[])(qFilters = new QFilter[]{new QFilter("modifier", "=", (Object)UserUtils.getUserId()), new QFilter("application", "in", (Object)indexList), new QFilter("date", "is not null", (Object)"")}), (String)"date desc", (int)1)).size() > 0) {
            HashSet<Long> permIds = new HashSet<Long>();
            if (ApplicationTypeEnum.BGBD == application) {
                permIds.addAll(UserSelectServiceHelperNew.selectPowerModel(ApplicationTypeEnum.BGMD, formView));
                permIds.addAll(UserSelectServiceHelperNew.selectPowerModel(ApplicationTypeEnum.EB, formView));
            } else {
                permIds.addAll(UserSelectServiceHelperNew.selectPowerModel(application, formView));
            }
            for (DynamicObject dynamicObject : userMemorys) {
                if (!permIds.contains(dynamicObject.getLong(MODEL))) continue;
                return dynamicObject;
            }
        }
        return null;
    }
}

