/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.utils.QFBuilder;

public class UserUtils {
    public static Long getUserId() {
        return RequestContext.get().getCurrUserId();
    }

    public static String getUserName() {
        return RequestContext.get().getUserName();
    }

    public static Set<Long> getAllUserGroupIds(Set<Long> groupIds) {
        Map<Long, UserInfo> allUserGroupInfos = UserUtils.getAllUserGroupInfos(groupIds);
        groupIds.addAll(allUserGroupInfos.keySet());
        return groupIds;
    }

    public static List<UserInfo> getAllRefUserGropInfo(Long userOrGroupId) {
        ArrayList<UserInfo> reuslt = new ArrayList<UserInfo>(16);
        UserUtils.getAllRefUserGropInfo(userOrGroupId, reuslt, null);
        return reuslt;
    }

    private static void getAllRefUserGropInfo(Long userOrGroupId, List<UserInfo> groupInfo, List<Long> groupIds) {
        UserInfo userInfo = UserUtils.getUserInfo(userOrGroupId);
        HashSet refGroupIds = userInfo != null ? UserUtils.queryAllGroupByUserId(userOrGroupId) : Sets.newHashSet((Object[])new Long[]{userOrGroupId});
        Map<Long, UserInfo> allUserGroupInfos = UserUtils.getAllUserGroupInfos(refGroupIds);
        if (groupIds != null) {
            groupIds.addAll(allUserGroupInfos.keySet());
            if (userInfo != null) {
                groupIds.add(userOrGroupId);
            }
        } else if (groupInfo != null) {
            groupInfo.addAll(allUserGroupInfos.values());
            if (userInfo != null) {
                groupInfo.add(userInfo);
            }
        }
    }

    public static List<Long> getAllRefUserGroupIds(Long userOrGroupId) {
        ArrayList<Long> reuslt = new ArrayList<Long>(16);
        UserUtils.getAllRefUserGropInfo(userOrGroupId, null, reuslt);
        return reuslt;
    }

    public static Map<Long, UserInfo> getAllUserGroupInfos(Set<Long> groupIds) {
        Map groupObjs;
        HashMap<Long, UserInfo> result = new HashMap<Long, UserInfo>(16);
        Set<Long> allParentUserGroups = UserUtils.getAllParentUserGroups(groupIds);
        if (!allParentUserGroups.isEmpty() && (groupObjs = BusinessDataServiceHelper.loadFromCache((Object[])allParentUserGroups.toArray(), (String)"bos_usergroup")) != null) {
            groupObjs.values().forEach(group -> result.put(group.getLong("id"), new UserInfo(group.getLong("id"), group.getString("number"), group.getString("name"), true)));
        }
        return result;
    }

    public static UserInfo getUserOrGroupInfo(Long userId) {
        DynamicObject userGroup;
        UserInfo userInfo = UserUtils.getUserInfo(userId);
        if (userInfo == null && (userGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_usergroup", (String)"id,number,name")) != null) {
            return new UserInfo(userId, userGroup.getString("number"), userGroup.getString("name"), false);
        }
        return userInfo;
    }

    public static UserInfo getUserInfo(Long userId) {
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,number,name");
        if (userObj != null) {
            return new UserInfo(userId, userObj.getString("number"), userObj.getString("name"), false);
        }
        return null;
    }

    public static UserInfo getUserInfo(String userNumber) {
        QFBuilder builder = new QFBuilder();
        builder.add("number", "=", userNumber);
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])builder.toArray());
        if (userObj != null) {
            return new UserInfo(userObj.getLong("id"), userObj.getString("number"), userObj.getString("name"), false);
        }
        return null;
    }

    public static Set<Long> queryAllGroupByUserId(long userId) {
        Map<Long, Set<Long>> allDirectGroup = UserUtils.queryAllDirectGroup(Sets.newHashSet((Object[])new Long[]{userId}));
        return allDirectGroup.getOrDefault(userId, new HashSet(16));
    }

    public static Map<Long, Set<Long>> queryAllDirectGroup(Set<Long> userIds) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(userIds.size());
        if (userIds.size() > 0) {
            QFilter userFilter = new QFilter("user", "in", userIds);
            Map groupObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)"usergroup,user", (QFilter[])new QFilter[]{userFilter});
            if (groupObjs != null) {
                groupObjs.values().forEach(group -> {
                    Long userId = group.getLong("user.id");
                    Set groupIds = result.computeIfAbsent(userId, key -> new HashSet(16));
                    groupIds.add(group.getLong("usergroup.id"));
                });
            }
        }
        return result;
    }

    public static Set<Long> queryAllUserByGroupId(long groupId) {
        return UserUtils.queryAllUserByGroupId(Sets.newHashSet((Object[])new Long[]{groupId}));
    }

    public static Set<Long> queryAllUserByGroupId(Set<Long> groupIds) {
        Set<Long> allChildGroups = UserUtils.getAllChildUserGroups(groupIds);
        HashSet<Long> userIds = new HashSet<Long>();
        QFilter userFilter = new QFilter("usergroup", "in", allChildGroups);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllUserIdsByGroup", (String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{userFilter}, null);){
            for (Row row : ds) {
                Long userId = row.getLong("user");
                if (userId.equals(0L)) continue;
                userIds.add(userId);
            }
        }
        return userIds;
    }

    public static Map<Long, Set<Long>> queryAllUserGroupMap(Set<Long> groupIds) {
        Map<Long, Set<Long>> allChildGroupIds = UserUtils.getAllParentUserGroupSets(groupIds, true);
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(groupIds.size());
        HashSet<Long> allGroupIds = new HashSet<Long>(groupIds);
        allChildGroupIds.values().forEach(allGroupIds::addAll);
        QFilter userFilter = new QFilter("usergroup", "in", allGroupIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllUserIdsByGroup", (String)"bos_usergroupstaff", (String)"user,usergroup", (QFilter[])new QFilter[]{userFilter}, null);){
            for (Row row : ds) {
                Long userId = row.getLong("user");
                Long groupId = row.getLong("usergroup");
                if (userId.equals(0L)) continue;
                result.computeIfAbsent(groupId, key -> new HashSet(16)).add(userId);
            }
        }
        return result;
    }

    public static Set<Long> getAllChildUserGroups(Set<Long> groupIds) {
        HashSet<Long> resultGroups = new HashSet<Long>(groupIds);
        Map<Long, Set<Long>> allParentUserGroupSets = UserUtils.getAllParentUserGroupSets(groupIds, true);
        allParentUserGroupSets.values().forEach(gIds -> resultGroups.addAll((Collection<Long>)gIds));
        return resultGroups;
    }

    public static Set<Long> getAllParentUserGroups(Set<Long> groupIds) {
        HashSet<Long> resultGroups = new HashSet<Long>();
        Map groupObjs = BusinessDataServiceHelper.loadFromCache((Object[])groupIds.toArray(), (String)"bos_usergroup");
        groupObjs.values().forEach(obj -> resultGroups.add(obj.getLong("id")));
        Map<Long, Set<Long>> allParentUserGroupSets = UserUtils.getAllParentUserGroupSets(resultGroups, false);
        allParentUserGroupSets.values().forEach(gIds -> resultGroups.addAll((Collection<Long>)gIds));
        return resultGroups;
    }

    public static Map<Long, Set<Long>> getAllParentUserGroupSets(Set<Long> groupIds, boolean needChild) {
        String targetKey;
        String sourceKey;
        Map perm_usrgrp_inh = BusinessDataServiceHelper.loadFromCache((String)"perm_usrgrp_inh", (String)"parent,children", null);
        HashMap directParents = new HashMap(16);
        if (needChild) {
            sourceKey = "parent.id";
            targetKey = "children.id";
        } else {
            sourceKey = "children.id";
            targetKey = "parent.id";
        }
        perm_usrgrp_inh.values().forEach(obj -> {
            Long sId = obj.getLong(sourceKey);
            Long tId = obj.getLong(targetKey);
            Set tIds = directParents.computeIfAbsent(sId, key -> new HashSet(16));
            tIds.add(tId);
        });
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(groupIds.size());
        for (Long groupId : groupIds) {
            HashSet allTIds = Sets.newHashSet((Object[])new Long[]{groupId});
            HashSet nextSIds = Sets.newHashSet((Object[])new Long[]{groupId});
            HashSet<Long> tIds = new HashSet<Long>();
            while (nextSIds.size() > 0) {
                for (Long cId : nextSIds) {
                    Set pIds = (Set)directParents.get(cId);
                    if (pIds == null) continue;
                    for (Long pid : pIds) {
                        Set ids = (Set)result.get(pid);
                        if (ids != null) {
                            allTIds.addAll(ids);
                            continue;
                        }
                        if (!allTIds.add(pid)) continue;
                        tIds.add(pid);
                    }
                }
                nextSIds.clear();
                nextSIds.addAll(tIds);
                tIds.clear();
            }
            result.put(groupId, allTIds);
        }
        return result;
    }

    public static Map<Long, Set<Long>> getRefUserGroupInfo(List<UserInfo> userInfoList, boolean includeSel) {
        HashSet groupIds = new HashSet(16);
        HashMap userInfoMap = new HashMap(16);
        userInfoList.forEach(uInfo -> {
            if (uInfo.isUserGroup()) {
                groupIds.add(uInfo.getId());
            } else {
                userInfoMap.put(uInfo.getId(), uInfo);
            }
        });
        Map<Long, Set<Long>> allDirectGroups = UserUtils.queryAllDirectGroup(userInfoMap.keySet());
        HashSet<Long> allGroupIds = new HashSet<Long>(16);
        allDirectGroups.values().forEach(allGroupIds::addAll);
        allGroupIds.addAll(groupIds);
        Map<Long, Set<Long>> allParentUserGroupSets = UserUtils.getAllParentUserGroupSets(allGroupIds, false);
        HashMap<Long, Set<Long>> resultIds = new HashMap<Long, Set<Long>>(userInfoList.size());
        userInfoList.forEach(uInfo -> {
            Set allRefUIds = resultIds.computeIfAbsent(uInfo.getId(), key -> new HashSet(16));
            if (!uInfo.isUserGroup()) {
                Set directGroup = (Set)allDirectGroups.get(uInfo.getId());
                if (directGroup != null) {
                    for (Long gId : directGroup) {
                        Set refGids = (Set)allParentUserGroupSets.get(gId);
                        if (refGids == null) continue;
                        allRefUIds.addAll(refGids);
                    }
                }
            } else {
                Set refGids = (Set)allParentUserGroupSets.get(uInfo.getId());
                if (refGids != null) {
                    allRefUIds.addAll(refGids);
                }
            }
            if (includeSel) {
                allRefUIds.add(uInfo.getId());
            } else {
                allRefUIds.remove(uInfo.getId());
            }
        });
        return resultIds;
    }

    public static List<UserInfo> getUserInfo(Collection<Long> userIds, boolean onlyUser) {
        QFilter qId = new QFilter("id", "in", userIds);
        Map groupObjs = onlyUser ? new HashMap(1) : BusinessDataServiceHelper.loadFromCache((String)"bos_usergroup", (String)"id,number,name", (QFilter[])qId.toArray());
        Map userObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])qId.toArray());
        ArrayList<UserInfo> result = new ArrayList<UserInfo>(userIds.size());
        for (Long uid : userIds) {
            boolean isUserGroup;
            DynamicObject object = (DynamicObject)groupObjs.get(uid);
            if (object == null) {
                object = (DynamicObject)userObjs.get(uid);
                isUserGroup = false;
            } else {
                isUserGroup = true;
            }
            if (object == null) continue;
            result.add(new UserInfo(object.getLong("id"), object.getString("number"), object.getString("name"), isUserGroup));
        }
        return result;
    }

    public static Map<Long, Set<Long>> getAllRefUserInfo(Collection<Long> userIds, boolean includeSel) {
        return UserUtils.getRefUserGroupInfo(UserUtils.getUserInfo(userIds, false), includeSel);
    }
}

