/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.adjustdecompose;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeQueryVO;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.enums.AdjustDecomposeTypeEnum;
import kd.epm.eb.common.enums.ApplicationScenarioEnum;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.BasedataUtil;
import kd.epm.eb.common.utils.base.LanguageUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.jetbrains.annotations.NotNull;

public class AdjustServiceHelper {
    private static final String DECOMPOSE_ID = "eb_decompose_scheme";
    private static final String MODEL = "model";
    private static final String ALGORITHM = "MD5";
    private static final String FIELD_HASHCODE = "hashcode";
    private static Double MAX_LIMIT = 0.0;
    public static int DECIMAL_LEN = 6;
    private static final List<String> DECOMPOSE_SCHEME_LEAF_DIMS = new ArrayList<String>(10){
        {
            this.add(SysDimensionEnum.DataType.getNumber());
            this.add(SysDimensionEnum.Version.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };
    private static final List<String> DECOMPOSE_SCHEME_NOTLEAF_DIMS = new ArrayList<String>(10){
        {
            this.add(SysDimensionEnum.AuditTrail.getNumber());
            this.add(SysDimensionEnum.BudgetPeriod.getNumber());
        }
    };
    public static final Set<String> ALLOW_ADJUST_METRIC_TYPE = new HashSet<String>(16);
    private static final Set<String> NOT_ALLOW_ADJUST_DIM;
    public static final String fields = "id,model,bizmodel,dataset,dimensionjson ,hashcode,eb_decomposeadjustsub.viewjson as viewjson,eb_decomposeadjustsub.entityview as entityview, eb_decomposeadjustsub.id as entryid,eb_decomposeadjustsub.pendingtrial as pendingtrial,eb_decomposeadjustsub.adjusttrial as adjusttrial,eb_decomposeadjustsub.fixtrial as fixtrial,eb_decomposeadjustsub.status as status,eb_decomposeadjustsub.adjustexplain as adjustexplain,eb_decomposeadjustsub.attachmentfield as attachmentfield,eb_decomposeadjustsub.modifyoperator as modifyoperator,eb_decomposeadjustsub.modifytime as modifytime,eb_decomposeadjustsub.type as type";

    public static Map<String, String> mapSort(Map<String, String> map) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(16);
        if (map == null || map.size() == 0) {
            return resultMap;
        }
        List keys = map.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        keys.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String key : keys) {
            resultMap.put(key, map.get(key));
        }
        return resultMap;
    }

    public static String toJsonString(Map<String, String> map) {
        Map<String, String> resultMap = AdjustServiceHelper.mapSort(map);
        return JSON.toJSONString(resultMap);
    }

    public static QFilter getHashcodesFilter(List<Map<String, String>> mapList, IModelCacheHelper modelCacheHelper) {
        List hashcodes = mapList.stream().map(forMap -> AdjustServiceHelper.removeCustomDimNoneMember(forMap, modelCacheHelper).hashCode()).collect(Collectors.toList());
        return new QFilter(FIELD_HASHCODE, "in", hashcodes);
    }

    public static Map<String, String> parseMap(String jsonString) {
        return AdjustServiceHelper.mapSort((Map)JSON.parse((String)jsonString));
    }

    public static String md5(String str) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance(ALGORITHM);
            md5.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md5.digest();
            StringBuilder sbr = new StringBuilder();
            for (byte bytef : digest) {
                sbr.append(String.format("%02x", bytef));
            }
            return sbr.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDException(BosErrorCode.systemError, "AdjustUtil.md5", (Throwable)e);
        }
    }

    public static boolean isNumber(String str, String nowUnit, boolean needRecalc) {
        boolean isValid;
        boolean intFlag;
        String[] split;
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        String[] split1 = str.split(",");
        if (split1.length == 0) {
            return false;
        }
        for (String s : split1) {
            if (s != null && s.trim().length() != 0) continue;
            return false;
        }
        str = str.replace(",", "");
        int splitSize = 2;
        int intAccuracy = 23;
        int decimalAccuracy = 6;
        boolean valid = BigDecimalValidator.getInstance().isValid(str);
        if (!valid) {
            return false;
        }
        if (needRecalc) {
            str = new BigDecimal(str).multiply(BigDecimal.TEN.pow(Integer.parseInt(nowUnit))).stripTrailingZeros().toPlainString();
        }
        if ((split = str.split("\\.")).length == splitSize) {
            boolean bl = intFlag = split[0].length() > intAccuracy;
            if (intFlag) {
                return false;
            }
        } else {
            boolean bl = intFlag = str.length() > intAccuracy;
            if (intFlag) {
                return false;
            }
        }
        Pattern patternInter = Pattern.compile("^[-\\+]?[\\d]*$");
        Pattern patternDecimal = Pattern.compile("^[-\\+]?(\\d+\\.\\d+)");
        boolean bl = isValid = patternDecimal.matcher(str).matches() || patternInter.matcher(str).matches();
        if (!isValid) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(split[0]);
        if (MAX_LIMIT <= 0.0) {
            MAX_LIMIT = Math.pow(10.0, 13.0);
        }
        isValid = bigDecimal.doubleValue() < MAX_LIMIT;
        return isValid;
    }

    public static Map<String, String> loadUpperDimen(Long modelId, Map<String, String> dimenMap, Map<String, Long> dimViewMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        Iterator<Map.Entry<String, String>> iterator = dimenMap.entrySet().iterator();
        LinkedList<Member> queue = new LinkedList<Member>();
        while (iterator.hasNext()) {
            queue.clear();
            Map.Entry<String, String> next = iterator.next();
            String dimenNumber = next.getKey();
            String memberNumber = next.getValue();
            Long dimViewId = dimViewMap.get(dimenNumber);
            Member member = modelCacheHelper.getMember(dimenNumber, dimViewId, memberNumber);
            queue.offer(member);
            while (!queue.isEmpty()) {
                Member poll = (Member)queue.poll();
                if (poll != null && poll.getLevel() <= 2) {
                    memberNumber = poll.getNumber();
                    continue;
                }
                if (poll == null || poll.getLevel() <= 2) continue;
                Long parentId = poll.getParentId();
                Member helperMember = modelCacheHelper.getMember(dimenNumber, dimViewId, parentId);
                queue.offer(helperMember);
            }
            resultMap.put(dimenNumber, memberNumber);
        }
        return AdjustServiceHelper.mapSort(resultMap);
    }

    public static String loadUpperDimenMd5LockKey(Long modelId, Map<String, String> dimenMap, Map<String, String> viewMap) {
        Map<String, Long> dimViewMap = AdjustServiceHelper.getDimViewMap(viewMap);
        Map<String, String> stringStringMap = AdjustServiceHelper.loadUpperDimen(modelId, dimenMap, dimViewMap);
        String jsonString = AdjustServiceHelper.toJsonString(stringStringMap);
        return String.join((CharSequence)":", modelId.toString(), AdjustServiceHelper.md5(jsonString));
    }

    public static void checkPermission(Long modelId, Long datasetId, Map<String, String> dimenData, Map<String, String> dimViewMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
        for (Map.Entry<String, String> next : dimenData.entrySet()) {
            Long dimViewId;
            String dim = next.getKey();
            Member member = modelCacheHelper.getMember(dim, dimViewId = IDUtils.toLong(dimViewMap.get(dim)), next.getValue());
            if (member == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u6570\u636e\u533a\u57df", (String)"Fn_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            memberGroup.put(dim, new MemberItem(true, member.getId(), member.getNumber()));
        }
        DimMemberPermChecker writePermChecker = DimMembPermHelper.getWritePermChecker(modelId, datasetId);
        if (!writePermChecker.check(memberGroup)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u8c03\u6574\u64cd\u4f5c\u5f53\u524d\u7ef4\u5ea6\u9700\u8981\u5199\u5165\u6743\u9650\uff1a", (String)"Fn_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkMetric(IModelCacheHelper modelCacheHelper, Map<String, String> dimenData, AdjustParam adjustParam) {
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, dimenData.get(SysDimensionEnum.Metric.getNumber()));
        String datatype = member.getDatatype();
        if (!ALLOW_ADJUST_METRIC_TYPE.contains(datatype)) {
            if (adjustParam.isApproveeditnoleafcell()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u3001\u65e5\u671f\u3001\u679a\u4e3e\u5ea6\u91cf\u7c7b\u578b\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u7684\u8c03\u6574\u65b9\u5f0f\u9700\u9009\u62e9\u201c\u754c\u9762\u76f4\u63a5\u8c03\u6574/\u53f3\u952e\u5ba1\u6279\u8c03\u6574\u201d\u65b9\u5f0f\u5e76\u5728\u754c\u9762\u76f4\u63a5\u7f16\u8f91\uff0c\u4e14\u5bf9\u5e94\u5ea6\u91cf\u6210\u5458\u9700\u5f00\u542f\u201c\u975e\u660e\u7ec6\u5b58\u50a8\u201d\u9009\u9879\u3002", (String)"Fn_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u3001\u65e5\u671f\u3001\u679a\u4e3e\u5ea6\u91cf\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u53f3\u952e\u8fdb\u884c\u8c03\u6574\u3002", (String)"Fn_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkDecomposeStatus(Map<String, String> dimensionData, Long modelId, Long datasetId, Map<String, String> dimViewMap) {
        IModelCacheHelper iModelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Long bizModelId = iModelCacheHelper.getBusModelByDataSet(datasetId);
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and(new QFilter("bizmodel", "=", (Object)bizModelId));
        qFilter.and(new QFilter("status", "=", (Object)DecomposeSchemeStatus.START.getNumber()));
        for (String key2 : DECOMPOSE_SCHEME_LEAF_DIMS) {
            String memberNumber = dimensionData.get(key2);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)memberNumber)) continue;
            Long dimViewId = IDUtils.toLong(dimViewMap.get(key2));
            Member currentMember = iModelCacheHelper.getMember(key2, dimViewId, memberNumber);
            qFilter.and(new QFilter(key2.toLowerCase(Locale.ENGLISH), "=", (Object)currentMember.getId()));
        }
        List notLeafFields = DECOMPOSE_SCHEME_NOTLEAF_DIMS.stream().map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = EpmThreadLocalUtils.getAdjustDys(DECOMPOSE_ID, "number," + String.join((CharSequence)",", notLeafFields), qFilter);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            int count = 0;
            for (String key3 : DECOMPOSE_SCHEME_NOTLEAF_DIMS) {
                String[] split;
                String memberNumber = dimensionData.get(key3);
                Long dimViewId = IDUtils.toLong(dimViewMap.get(key3));
                Member pageMember = iModelCacheHelper.getMember(key3, dimViewId, memberNumber);
                if (pageMember == null) continue;
                ArrayList<Long> ids = new ArrayList<Long>();
                String multiMemberIds = dynamicObject.getString(key3.toLowerCase(Locale.ENGLISH));
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)multiMemberIds)) continue;
                for (String memberIdStr : split = multiMemberIds.split(",")) {
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)memberIdStr)) continue;
                    Long memberId = IDUtils.toLong(memberIdStr);
                    Member member = iModelCacheHelper.getMember(key3, dimViewId, memberId);
                    ids.addAll(AdjustServiceHelper.loadAllChildMemberIds(member));
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
                    return;
                }
                if (ids.contains(pageMember.getId())) {
                    ++count;
                    continue;
                }
                return;
            }
            if (count != DECOMPOSE_SCHEME_NOTLEAF_DIMS.size()) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u5173\u8054\u7684\u5206\u89e3\u65b9\u6848\u201c%1\u201d\u6b63\u5728\u5206\u89e3\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_12", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("number")}));
        }
    }

    private static List<Long> loadAllChildMemberIds(Member member) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        LinkedList<Member> queue = new LinkedList<Member>();
        queue.add(member);
        while (!queue.isEmpty()) {
            Member poll = (Member)queue.poll();
            if (poll == null) continue;
            set.add(poll.getId());
            queue.addAll(poll.getChildren());
        }
        return new ArrayList<Long>(set);
    }

    public static int checkDecimalLen(String decimalStr, String nowUnit, boolean needRecalc) {
        String[] split;
        if (decimalStr == null) {
            return 0;
        }
        boolean valid = BigDecimalValidator.getInstance().isValid(decimalStr.replace(",", ""));
        if (valid && needRecalc) {
            decimalStr = new BigDecimal(decimalStr.replace(",", "")).multiply(BigDecimal.TEN.pow(Integer.parseInt(nowUnit))).stripTrailingZeros().toPlainString();
        }
        if ((split = decimalStr.split("\\.")).length != 2) {
            return 0;
        }
        return split[1].length();
    }

    public static void refreshBtnUnitStyle(int dataUnit, IFormView formView, String btnKey) {
        if (formView == null || btnKey == null) {
            return;
        }
        String unitName = ResManager.loadKDString((String)"\u4e2a", (String)"AbstractReportPlugin_32", (String)"epm-eb-spread", (Object[])new Object[0]);
        switch (dataUnit) {
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"AbstractReportPlugin_0", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"AbstractReportPlugin_1", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 6: {
                unitName = ResManager.loadKDString((String)"\u767e\u4e07", (String)"AbstractReportPlugin_2", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 8: {
                unitName = ResManager.loadKDString((String)"\u4ebf", (String)"AbstractReportPlugin_3", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 10: {
                unitName = ResManager.loadKDString((String)"\u767e\u4ebf", (String)"AbstractReportPlugin_4", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
        }
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>();
        language.put(LanguageUtils.getLang(Lang.zh_CN).toString(), ResManager.loadResFormat((String)"\u5355\u4f4d\uff1a%1", (String)"AbstractReportPlugin_5", (String)"epm-eb-spread", (Object[])new Object[]{unitName}));
        parm.put("text", language);
        formView.updateControlMetadata(btnKey, parm);
    }

    public static DynamicObject getAdjustDecomposeRecord(@NotNull AdjustDecomposeRecord adjustDecomposeRecord) {
        Long pkId = adjustDecomposeRecord.getId();
        if (IDUtils.isNotNull(pkId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)pkId);
            return QueryServiceHelper.queryOne((String)"eb_decomposeadjust", (String)fields, (QFilter[])qFilter.toArray());
        }
        QFilter qFilter = new QFilter(MODEL, "=", (Object)adjustDecomposeRecord.getModelId());
        qFilter.and(new QFilter(FIELD_HASHCODE, "=", (Object)adjustDecomposeRecord.getHashCode()));
        qFilter.and(new QFilter("bizmodel", "=", (Object)adjustDecomposeRecord.getBusinessModelId()));
        qFilter.and(new QFilter("dataset", "=", (Object)adjustDecomposeRecord.getDataSetId()));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_decomposeadjust", (String)fields, (QFilter[])qFilter.toArray());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)query)) {
            String jsonString = AdjustServiceHelper.toJsonString(adjustDecomposeRecord.getMemberMap());
            for (DynamicObject object : query) {
                if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)jsonString, (CharSequence)object.getString("dimensionjson"))) continue;
                return object;
            }
        }
        return null;
    }

    public static DynamicObjectCollection queryAdjustDecomposeRecordList(@NotNull AdjustDecomposeQueryVO adjustDecomposeQueryVO) {
        return AdjustServiceHelper.queryAdjustDecomposeRecordList(adjustDecomposeQueryVO, null);
    }

    public static DynamicObjectCollection queryAdjustDecomposeRecordList(@NotNull AdjustDecomposeQueryVO adjustDecomposeQueryVO, List<Map<String, String>> memberMapList) {
        AdjustDecomposeDetail adjustDecomposeDetail;
        AdjustDecomposeRecord adjustDecomposeRecord = adjustDecomposeQueryVO.getAdjustDecomposeRecord();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)adjustDecomposeRecord.getModelId());
        if (adjustDecomposeRecord.getBusinessModelId() != null) {
            qFilter.and(new QFilter("bizmodel", "=", (Object)adjustDecomposeRecord.getBusinessModelId()));
        }
        if (adjustDecomposeRecord.getDataSetId() != null) {
            qFilter.and(new QFilter("dataset", "=", (Object)adjustDecomposeRecord.getDataSetId()));
        }
        if (adjustDecomposeRecord.getEntityId() != null) {
            qFilter.and(new QFilter("entity", "=", (Object)adjustDecomposeRecord.getEntityId()));
        }
        if (adjustDecomposeRecord.getAccountId() != null) {
            qFilter.and(new QFilter("account", "=", (Object)adjustDecomposeRecord.getAccountId()));
        }
        if (adjustDecomposeRecord.getBudgetPeriodId() != null) {
            qFilter.and(new QFilter("budgetperiod", "=", (Object)adjustDecomposeRecord.getBudgetPeriodId()));
        }
        if (adjustDecomposeRecord.getVersionId() != null) {
            qFilter.and(new QFilter("version", "=", (Object)adjustDecomposeRecord.getVersionId()));
        }
        if (adjustDecomposeRecord.getCurrencyId() != null) {
            qFilter.and(new QFilter("currency", "=", (Object)adjustDecomposeRecord.getCurrencyId()));
        }
        if (adjustDecomposeRecord.getDataTypeId() != null) {
            qFilter.and(new QFilter("datatype", "=", (Object)adjustDecomposeRecord.getDataTypeId()));
        }
        if ((adjustDecomposeDetail = adjustDecomposeQueryVO.getAdjustDecomposeDetail()) != null) {
            if (adjustDecomposeDetail.getDecomposeTaskId() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.decomposetask", "=", (Object)adjustDecomposeDetail.getDecomposeTaskId()));
            }
            if (adjustDecomposeDetail.getNode() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.node", "=", (Object)adjustDecomposeDetail.getNode()));
            }
            if (adjustDecomposeDetail.getStatus() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.status", "=", (Object)adjustDecomposeDetail.getStatus()));
            }
            if (adjustDecomposeDetail.getModifyOperator() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.modifyoperator", "=", (Object)adjustDecomposeDetail.getModifyOperator()));
            }
            if (adjustDecomposeDetail.getSourceAdjustId() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.fsourceadjust", "=", (Object)adjustDecomposeDetail.getSourceAdjustId()));
            }
            if (adjustDecomposeDetail.getEntityViewId() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.entityview", "=", (Object)adjustDecomposeDetail.getEntityViewId()));
            }
            if (adjustDecomposeDetail.getReportProcessId() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.reportprocess", "=", (Object)adjustDecomposeDetail.getReportProcessId()));
            }
            if (adjustDecomposeDetail.getType() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.type", "=", (Object)adjustDecomposeDetail.getType()));
            }
            if (adjustDecomposeDetail.getModifytime() != null) {
                qFilter.and(new QFilter("eb_decomposeadjustsub.modifytime", ">", (Object)adjustDecomposeDetail.getModifytime()));
            }
        } else {
            qFilter.and(new QFilter("eb_decomposeadjustsub.id", "is not null", (Object)""));
        }
        if (adjustDecomposeDetail == null || adjustDecomposeDetail.getType() == null) {
            qFilter.and(new QFilter("eb_decomposeadjustsub.type", "in", Arrays.asList(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber(), AdjustDecomposeTypeEnum.ADJUST.getNumber())));
        }
        if (memberMapList == null) {
            memberMapList = new ArrayList<Map<String, String>>(10);
            memberMapList.add(adjustDecomposeRecord.getMemberMap());
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(adjustDecomposeRecord.getModelId());
        HashMap<Integer, Set> codeToJson = new HashMap<Integer, Set>(16);
        for (Map<String, String> memberMap : memberMapList) {
            if (memberMap == null) continue;
            Map<String, String> newMemberMap = AdjustServiceHelper.removeCustomDimNoneMember(memberMap, modelCache);
            Set jsons = codeToJson.computeIfAbsent(newMemberMap.hashCode(), e -> new HashSet(5));
            jsons.add(AdjustServiceHelper.toJsonString(newMemberMap));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_decomposeadjust", (String)fields, (QFilter[])qFilter.toArray());
        if (codeToJson.size() > 0) {
            query.removeIf(e -> {
                Integer hashCode = e.getInt(FIELD_HASHCODE);
                String dimensionJson = e.getString("dimensionjson");
                Set jsons = (Set)codeToJson.get(hashCode);
                return jsons == null || !jsons.contains(dimensionJson);
            });
        }
        return query;
    }

    public static void removeCustomDimNoneMember(AdjustDecomposeRecord adjustDecomposeRecord) {
        Map<String, String> memberMap = adjustDecomposeRecord.getMemberMap();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(adjustDecomposeRecord.getModelId());
        Map<String, String> newMemberMap = AdjustServiceHelper.removeCustomDimNoneMember(memberMap, modelCache);
        adjustDecomposeRecord.setMemberMap(newMemberMap);
    }

    public static Map<String, String> removeCustomDimNoneMember(Map<String, String> memberMap, IModelCacheHelper modelCache) {
        HashMap<String, String> newMemberMap = new HashMap<String, String>(memberMap.size());
        for (Map.Entry<String, String> entry : memberMap.entrySet()) {
            Dimension dimension = modelCache.getDimension(entry.getKey());
            if ((!dimension.isPreset() || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) && dimension.getNoneNumber().equals(entry.getValue())) continue;
            newMemberMap.put(entry.getKey(), entry.getValue());
        }
        return AdjustServiceHelper.mapSort(newMemberMap);
    }

    public static void addCustomDimNoneMember(Map<String, String> memberMap, IModelCacheHelper modelCache, Long dataSetId) {
        List<Dimension> dimensionList = modelCache.getDimensionList(dataSetId);
        for (Dimension dimension : dimensionList) {
            String memberNumber;
            if (dimension.isPreset() && !SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) || (memberNumber = memberMap.get(dimension.getNumber())) != null) continue;
            memberMap.put(dimension.getNumber(), dimension.getNoneNumber());
        }
    }

    public static void saveAdjustDecomposeRecord(@NotNull List<AdjustDecomposeRecord> adjustDecomposeRecords) {
        String deleteAttachmentSQL;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(adjustDecomposeRecords)) {
            return;
        }
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(adjustDecomposeRecords.size());
        HashMap<String, List<Object[]>> sqlAndParamsMap = new HashMap<String, List<Object[]>>(16);
        for (AdjustDecomposeRecord adjustDecomposeRecord : adjustDecomposeRecords) {
            if (adjustDecomposeRecord == null) continue;
            AdjustServiceHelper.removeCustomDimNoneMember(adjustDecomposeRecord);
            DynamicObject record = AdjustServiceHelper.getAdjustDecomposeRecord(adjustDecomposeRecord);
            if (record == null) {
                record = BusinessDataServiceHelper.newDynamicObject((String)"eb_decomposeadjust");
                if (adjustDecomposeRecord.getId() == null) {
                    record.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                } else {
                    record.set("id", (Object)adjustDecomposeRecord.getId());
                }
                record.set(MODEL, (Object)adjustDecomposeRecord.getModelId());
                record.set(FIELD_HASHCODE, (Object)adjustDecomposeRecord.getHashCode());
                record.set("bizmodel", (Object)adjustDecomposeRecord.getBusinessModelId());
                record.set("dataset", (Object)adjustDecomposeRecord.getDataSetId());
                record.set("entity", (Object)adjustDecomposeRecord.getEntityId());
                record.set("account", (Object)adjustDecomposeRecord.getAccountId());
                record.set("budgetperiod", (Object)adjustDecomposeRecord.getBudgetPeriodId());
                record.set("version", (Object)adjustDecomposeRecord.getVersionId());
                record.set("audittrail", (Object)adjustDecomposeRecord.getAuditTrailId());
                record.set("currency", (Object)adjustDecomposeRecord.getCurrencyId());
                record.set("datatype", (Object)adjustDecomposeRecord.getDataTypeId());
                record.set("dimensionjson", (Object)AdjustServiceHelper.toJsonString(adjustDecomposeRecord.getMemberMap()));
                records.add(record);
            }
            adjustDecomposeRecord.setId(record.getLong("id"));
            List<AdjustDecomposeDetail> details = adjustDecomposeRecord.getDetails();
            ArrayList<AdjustDecomposeDetail> newDetails = new ArrayList<AdjustDecomposeDetail>(10);
            ArrayList<AdjustDecomposeDetail> updateDetails = new ArrayList<AdjustDecomposeDetail>(10);
            for (AdjustDecomposeDetail detail : details) {
                if (IDUtils.isNotNull(detail.getId())) {
                    updateDetails.add(detail);
                    continue;
                }
                newDetails.add(detail);
            }
            if (!newDetails.isEmpty()) {
                AdjustServiceHelper.addAdjustDecomposeDetails(adjustDecomposeRecord, newDetails, sqlAndParamsMap);
            }
            if (updateDetails.isEmpty()) continue;
            AdjustServiceHelper.updateAdjustDecomposeDetails(adjustDecomposeRecord, updateDetails, sqlAndParamsMap);
        }
        if (!records.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
        }
        if (sqlAndParamsMap.containsKey(deleteAttachmentSQL = "delete from t_eb_adjustsub_attach where fentryid = ? ") && sqlAndParamsMap.get(deleteAttachmentSQL) != null && !((List)sqlAndParamsMap.get(deleteAttachmentSQL)).isEmpty()) {
            AdjustServiceHelper.executeBatch(deleteAttachmentSQL, (List)sqlAndParamsMap.get(deleteAttachmentSQL));
        }
        for (Map.Entry entry : sqlAndParamsMap.entrySet()) {
            List params;
            String sql = (String)entry.getKey();
            if (sql.equals(deleteAttachmentSQL) || (params = (List)entry.getValue()).isEmpty()) continue;
            AdjustServiceHelper.executeBatch(sql, params);
        }
    }

    private static void executeBatch(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, params);
    }

    public static void addAdjustDecomposeDetails(AdjustDecomposeRecord adjustDecomposeRecord, List<AdjustDecomposeDetail> details, Map<String, List<Object[]>> sqlAndParamsMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(adjustDecomposeRecord.getModelId());
        Map<String, String> memberMap = adjustDecomposeRecord.getMemberMap();
        Member metric = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, memberMap.get(SysDimensionEnum.Metric.getNumber()));
        String datatype = metric.getDatatype();
        String addDeltalSql = "insert into t_eb_decomposeadjustsub (fid,fentryid,ftype, fpendingtrial, fadjusttrial,ffixtrial,fdecomposetask,fmodifyoperator,fmodifytime,fadjustexplain,fnode,fstatus,fentityview,fviewjson,freportprocess,fsourcemodel,fsourceadjust,fuploadstatus,fapprovebill) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String deleteAttachmentSQL = "delete from t_eb_adjustsub_attach where fentryid = ? ";
        String insertAttachmentSQL = "insert into t_eb_adjustsub_attach (fpkid,fentryid,fbasedataid) values (?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(details.size());
        for (AdjustDecomposeDetail detail : details) {
            Long entryId = GlobalIdUtil.genGlobalLongId();
            Object[] param = new Object[19];
            param[0] = adjustDecomposeRecord.getId();
            param[1] = entryId;
            param[2] = detail.getType();
            param[3] = AdjustServiceHelper.valueToString(detail.getPendingTrial(), datatype);
            param[4] = AdjustServiceHelper.valueToString(detail.getAdjustTrial(), datatype);
            param[5] = AdjustServiceHelper.valueToString(detail.getFixTrial(), datatype);
            param[6] = detail.getDecomposeTaskId() != null ? detail.getDecomposeTaskId() : 0L;
            param[7] = UserUtils.getUserId();
            param[8] = TimeServiceHelper.now();
            param[9] = detail.getAdjustExplain();
            param[10] = detail.getNode() != null ? detail.getNode() : "";
            param[12] = detail.getEntityViewId() != null ? detail.getEntityViewId() : 0L;
            param[14] = detail.getReportProcessId() != null ? detail.getReportProcessId() : 0L;
            param[15] = detail.getSourceModelId() != null ? detail.getSourceModelId() : 0L;
            param[16] = detail.getSourceAdjustId() != null ? detail.getSourceAdjustId() : 0L;
            param[17] = detail.getUploadStatus() != null ? detail.getUploadStatus() : "0";
            param[18] = detail.getApproveBillId() != null ? detail.getApproveBillId() : 0L;
            if (AdjustServiceHelper.isNumberMetric(datatype)) {
                if (detail.getStatus() == null) {
                    boolean isLeaf = true;
                    Map<String, String> viewMap = detail.getViewMap();
                    for (Map.Entry<String, String> entry : memberMap.entrySet()) {
                        Long viewId;
                        Member member;
                        String dim = entry.getKey();
                        Dimension dimension = modelCache.getDimension(dim);
                        if (!dimension.isPreset() || SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.InternalCompany.getNumber().equals(dim)) {
                            if (viewMap == null || viewMap.get(dim) == null || (member = modelCache.getMember(dim, viewId = IDUtils.toLong(viewMap.get(dim)), entry.getValue())) == null || member.isLeaf()) continue;
                            isLeaf = false;
                            break;
                        }
                        viewId = IDUtils.toLong(viewMap.get(dim));
                        member = modelCache.getMember(dim, viewId, entry.getValue());
                        if (member == null || member.isLeaf()) continue;
                        Member decomposeAuditTrail = null;
                        if (SysDimensionEnum.AuditTrail.getNumber().equals(dim)) {
                            decomposeAuditTrail = AdjustServiceHelper.getChildDecomposeAuditTrail(modelCache, member.getNumber());
                        }
                        if (decomposeAuditTrail != null) continue;
                        isLeaf = false;
                        break;
                    }
                    param[11] = isLeaf ? DecomposeStatus.NOT_NEED_DECOMPOSE.getValue() : DecomposeStatus.WAIT.getValue();
                } else {
                    param[11] = detail.getStatus();
                }
            } else {
                param[11] = DecomposeStatus.NOT_NEED_DECOMPOSE.getValue();
            }
            if (metric.isNoLeafStorage()) {
                param[11] = DecomposeStatus.NOT_NEED_DECOMPOSE.getValue();
            }
            param[13] = AdjustServiceHelper.toJsonString(detail.getViewMap());
            params.add(param);
            if (detail.getAttachmentIds() == null) continue;
            List delParams = sqlAndParamsMap.computeIfAbsent(deleteAttachmentSQL, v -> new ArrayList(10));
            delParams.add(new Object[]{entryId});
            for (Long attachmentId : detail.getAttachmentIds()) {
                List insertParams = sqlAndParamsMap.computeIfAbsent(insertAttachmentSQL, v -> new ArrayList(10));
                insertParams.add(new Object[]{GlobalIdUtil.genGlobalLongId(), entryId, attachmentId});
            }
        }
        if (params.size() > 0) {
            List paramList = sqlAndParamsMap.computeIfAbsent(addDeltalSql, v -> new ArrayList(10));
            paramList.addAll(params);
        }
    }

    public static void updateAdjustDecomposeDetails(AdjustDecomposeRecord adjustDecomposeRecord, List<AdjustDecomposeDetail> details, Map<String, List<Object[]>> sqlAndParamsMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(adjustDecomposeRecord.getModelId());
        Map<String, String> memberMap = adjustDecomposeRecord.getMemberMap();
        Member metric = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, memberMap.get(SysDimensionEnum.Metric.getNumber()));
        String datatype = metric.getDatatype();
        String upDetailSql = "update t_eb_decomposeadjustsub set fpendingtrial=?, fadjusttrial=? , ffixtrial=? , fmodifytime=? , fmodifyoperator=? , fadjustexplain=? where fentryid=?";
        String deleteAttachmentSQL = "delete from t_eb_adjustsub_attach where fentryid = ? ";
        String insertAttachmentSQL = "insert into t_eb_adjustsub_attach (fpkid,fentryid,fbasedataid) values (?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(details.size());
        for (AdjustDecomposeDetail detail : details) {
            Long entryId = detail.getId();
            Object[] param = new Object[]{AdjustServiceHelper.valueToString(detail.getPendingTrial(), datatype), AdjustServiceHelper.valueToString(detail.getAdjustTrial(), datatype), AdjustServiceHelper.valueToString(detail.getFixTrial(), datatype), TimeServiceHelper.now(), UserUtils.getUserId(), detail.getAdjustExplain(), entryId};
            params.add(param);
            if (detail.getAttachmentIds() == null) continue;
            List delParams = sqlAndParamsMap.computeIfAbsent(deleteAttachmentSQL, v -> new ArrayList(10));
            delParams.add(new Object[]{entryId});
            for (Long attachmentId : detail.getAttachmentIds()) {
                List insertParams = sqlAndParamsMap.computeIfAbsent(insertAttachmentSQL, v -> new ArrayList(10));
                insertParams.add(new Object[]{GlobalIdUtil.genGlobalLongId(), entryId, attachmentId});
            }
        }
        if (params.size() > 0) {
            List paramList = sqlAndParamsMap.computeIfAbsent(upDetailSql, v -> new ArrayList(10));
            paramList.addAll(params);
        }
    }

    public static void deleteAdjustDecomposeDetail(Long pkId) {
        if (IDUtils.isNull(pkId)) {
            return;
        }
        String sql = "delete from t_eb_decomposeadjustsub where fentryid = " + pkId;
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql);
    }

    private static Object valueToString(Object value, String datatype) {
        return value;
    }

    public static boolean isNumberMetric(String datatype) {
        return ALLOW_ADJUST_METRIC_TYPE.contains(datatype);
    }

    public static Object getValueFromDetail(DynamicObject detail, String datatype, String field) {
        boolean isNumberMetric = AdjustServiceHelper.isNumberMetric(datatype);
        if (isNumberMetric) {
            return detail.getBigDecimal(field);
        }
        String value = detail.getString(field);
        if (MetricDataTypeEnum.DATE.getIndex().equals(datatype)) {
            long time = IDUtils.toLong(value);
            if (time == 0L) {
                return null;
            }
            Date date = new Date(time);
            return ConvertUtils.toString(date);
        }
        return value;
    }

    public static String getMetricDataType(Map<String, String> memberMap, Dimension metricDimension) {
        String metricNumber = memberMap.get(SysDimensionEnum.Metric.getNumber());
        Member member = metricDimension.getMember(metricNumber);
        if (member == null) {
            return "";
        }
        return member.getDatatype();
    }

    public static boolean hasDecomposeAdjust(Long modelId, String dimensionNumber, String memberNumber, Map<String, Long> dimViewMap) {
        QFBuilder builder = new QFBuilder();
        builder.add(MODEL, "=", modelId);
        builder.add("eb_decomposeadjustsub.status", "in", Arrays.asList(DecomposeStatus.WAIT.getValue(), DecomposeStatus.START.getValue()));
        builder.and("eb_decomposeadjustsub.type", "in", Arrays.asList(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber(), AdjustDecomposeTypeEnum.ADJUST.getNumber()));
        HashSet<String> fixDims = new HashSet<String>();
        fixDims.add(SysDimensionEnum.Entity.getNumber());
        fixDims.add(SysDimensionEnum.Account.getNumber());
        fixDims.add(SysDimensionEnum.BudgetPeriod.getNumber());
        fixDims.add(SysDimensionEnum.AuditTrail.getNumber());
        fixDims.add(SysDimensionEnum.Version.getNumber());
        fixDims.add(SysDimensionEnum.DataType.getNumber());
        fixDims.add(SysDimensionEnum.Currency.getNumber());
        if (fixDims.contains(dimensionNumber)) {
            Long dimViewId;
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
            Member member = modelCache.getMember(dimensionNumber, dimViewId = dimViewMap.get(dimensionNumber), memberNumber);
            if (member != null) {
                builder.add(dimensionNumber.toLowerCase(), "=", member.getId());
            }
            return QueryServiceHelper.exists((String)"eb_decomposeadjust", (QFilter[])builder.toArrays());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"eb_decomposeadjust", (String)"dimensionjson", (QFilter[])builder.toArrays(), (String)"id");){
            while (dataSet.hasNext()) {
                String dimensionJson = dataSet.next().getString("dimensionjson");
                Map dimensionMaps = (Map)JSON.parse((String)dimensionJson);
                if (!memberNumber.equals(dimensionMaps.get(dimensionNumber))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static String getMemberNumberWithNone(IModelCacheHelper modelCache, Dimension dim, Map<String, String> memberMap, Map<String, Long> viewMap) {
        String dimNumber = dim.getNumber();
        String memberNumber = memberMap.get(dimNumber);
        if (memberNumber == null) {
            Member member;
            if ((!dim.isPreset() || SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) && (member = modelCache.getMember(dimNumber, viewMap.get(dimNumber), dim.getNoneNumber())) != null) {
                memberNumber = member.getNumber();
            }
            if (memberNumber == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f3a\u5931\u7ef4\u5ea6(%1)", (String)"BudgetDataDecomposeService_02", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
        }
        return memberNumber;
    }

    public static void checkDimensSize(IModelCacheHelper modelCacheHelper, Long datasetId, Map<String, String> dimenData) {
        List<Dimension> dimensionList = modelCacheHelper.getDimensionList(datasetId);
        if (dimensionList != null && dimenData.size() != dimensionList.size()) {
            List collect = dimenData.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
            for (Dimension dimenKey : dimensionList) {
                String number = dimenKey.getNumber();
                if (collect.contains(number)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f3a\u5931\u7ef4\u5ea6(%1)", (String)"CommonUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimenKey.getName()}));
            }
        }
    }

    public static void checkDimenIsNotAdjust(Map<String, String> dimenData, IModelCacheHelper modelCacheHelper, Map<String, String> dimViewMap) {
        for (Map.Entry<String, String> entry : dimenData.entrySet()) {
            Long dimViewId;
            Dimension dimension;
            Member member;
            String dimKey = entry.getKey();
            String memberNumber = entry.getValue();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dimKey) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)memberNumber) || (member = (dimension = modelCacheHelper.getDimension(dimKey)).getMember(dimViewId = IDUtils.toLong(dimViewMap.get(dimKey)), memberNumber)) == null) continue;
            if (member.getLevel() <= 1) {
                throw new KDBizException(ResManager.loadResFormat((String)"%s\u7ef4\u5ea6\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_21", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getName()}));
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimKey)) {
                if ("BudgetOccupation".equals(member.getNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5728\u9014\u5360\u7528\u7684\u7ebf\u7d22\u6210\u5458\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String auditTrailUse = member.getAuditTrailUse();
                AuditTrailUseEnum trailUseEnum = AuditTrailUseEnum.loadAuditTrailUseEnumByCode(auditTrailUse);
                if (trailUseEnum != null) {
                    switch (trailUseEnum) {
                        case AUTO_OFFSET: 
                        case DECOMPOSE: {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u9009\u62e9\u7684\u5355\u5143\u683c\u4e2d\u5b58\u5728\u7ebf\u7d22\u4e3a\u201c%s\u201d\u7528\u9014\u7684\u6210\u5458\u6784\u6210\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u5ba1\u6279\u8c03\u6574\u4e0d\u5bf9\u8fd9\u4e9b\u7ef4\u5ea6\u7ec4\u5408\u8fdb\u884c\u8c03\u6574\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u3002", (String)"Fn_0", (String)"epm-eb-formplugin", (Object[])new Object[]{trailUseEnum.getDesc()}));
                        }
                    }
                }
            }
            if (SysDimensionEnum.DataType.getNumber().equals(dimKey) && "Actual".equals(member.getNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7684\u6570\u636e\u7c7b\u578b\u6210\u5458\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!member.getNumber().endsWith("offsetentry") || !SysDimensionEnum.Entity.getNumber().equals(dimKey)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean checkMeticHasAgg(String metric, IModelCacheHelper modelCacheHelper) {
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, metric);
        if (member != null) {
            if (!AdjustServiceHelper.isNumberMetric(member.getDatatype())) {
                return false;
            }
            if (!member.hasAgg()) {
                return false;
            }
        }
        return true;
    }

    public static void checkChangeType(Map<String, String> dimenData) {
        String changeTypeMemberNumber = dimenData.get(SysDimensionEnum.ChangeType.getNumber());
        List<String> noAdjust = Arrays.asList("EBChanges", "Occupation", "Execute");
        if (noAdjust.contains(changeTypeMemberNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u4e2d\u7684\u9884\u7b97\u6263\u51cf\u3001\u5360\u7528\u3001\u6267\u884c\u6210\u5458\u4e0d\u5141\u8bb8\u901a\u8fc7\u5ba1\u6279\u8c03\u6574\u5199\u5165\u6570\u636e\u3002", (String)"Fn_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkDataLock(Long modelId, Long bizModelId, Map<String, String> dimenData) {
        IBgmdDataLockCache dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(modelId, bizModelId);
        boolean dataLock = dataLockCache.isDataLock(dimenData);
        if (dataLock) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkParentRecord(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, Map<String, String> dimenData, Map<String, String> dimViewMap) {
        HashMap<String, String> queryMap = new HashMap<String, String>(16);
        for (String string : NOT_ALLOW_ADJUST_DIM) {
            if (dimenData.get(string) == null) continue;
            queryMap.put(string, dimenData.get(string));
        }
        HashMap<String, Long> dimMemViewMap = new HashMap<String, Long>(16);
        for (Map.Entry<String, String> entry : dimViewMap.entrySet()) {
            dimMemViewMap.put(entry.getKey(), IDUtils.toLong(entry.getValue()));
        }
        Set<Map<String, String>> set = AdjustServiceHelper.getAdjustMemberSet(modelCacheHelper, bizModelId, datasetId, queryMap, dimMemViewMap);
        for (Map<String, String> adjustMemberMap : set) {
            boolean isParent = false;
            String msg = "";
            for (Map.Entry<String, String> entry : adjustMemberMap.entrySet()) {
                String dimNumber = entry.getKey();
                String memberNumber = entry.getValue();
                Long dimViewId = IDUtils.toLong(dimViewMap.get(dimNumber));
                Member adjustMember = modelCacheHelper.getMember(dimNumber, dimViewId, memberNumber);
                if (adjustMember == null) continue;
                String adjustLongNumber = adjustMember.getLongNumber();
                Member member = modelCacheHelper.getMember(dimNumber, dimViewId, dimenData.get(dimNumber));
                if (member == null) continue;
                String longNumber = member.getLongNumber();
                if (!isParent && longNumber.contains(adjustLongNumber + "!")) {
                    isParent = true;
                    msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u4e0a\u7ea7\u6210\u5458\u201c%2\u201d\u5df2\u5b58\u5728\u8c03\u6574\u8bb0\u5f55\uff0c\u4e14\u672a\u5206\u89e3\u4e0b\u8fbe\u5230\u660e\u7ec6\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u3002", (String)"Fn_11", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, memberNumber});
                }
                if (longNumber.contains(adjustLongNumber)) continue;
                isParent = false;
                break;
            }
            if (!isParent) continue;
            throw new KDBizException(msg);
        }
    }

    private static Long getMemberId(Map<String, String> allDimMap, IModelCacheHelper modelCacheHelper, String dimenNumber, Map<String, Long> dimViewMap) {
        if (allDimMap == null || allDimMap.size() == 0) {
            return null;
        }
        String memberNumber = allDimMap.get(dimenNumber);
        if (StringUtils.isEmpty(memberNumber)) {
            return null;
        }
        Long dimViewId = dimViewMap.get(dimenNumber);
        Member member = modelCacheHelper.getMember(dimenNumber, dimViewId, memberNumber);
        if (member == null) {
            return null;
        }
        return member.getId();
    }

    public static QFilter getAdjustQfilter(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, List<Map<String, String>> memberMapList, Map<String, Long> dimViewMap, int[] status, Boolean isShowAll, Long processId) {
        DynamicObject recentReject;
        QFilter qFilter = new QFilter("eb_decomposeadjustsub.type", "in", Arrays.asList(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber(), AdjustDecomposeTypeEnum.ADJUST.getNumber()));
        if (status != null) {
            qFilter.and(new QFilter("eb_decomposeadjustsub.status", "in", (Object)status));
        }
        if (modelCacheHelper != null) {
            qFilter.and(new QFilter(MODEL, "=", (Object)modelCacheHelper.getModelobj().getId()));
        }
        if (IDUtils.isNotNull(bizModelId)) {
            qFilter.and(new QFilter("bizmodel", "=", (Object)bizModelId));
        }
        if (IDUtils.isNotNull(datasetId)) {
            qFilter.and(new QFilter("dataset", "=", (Object)datasetId));
        }
        if (!isShowAll.booleanValue() && processId != 0L && (recentReject = AdjustServiceHelper.recentRejectRecord(processId)) != null) {
            qFilter.and("eb_decomposeadjustsub.modifytime", ">=", (Object)recentReject.getDate("audittime"));
        }
        if (memberMapList != null) {
            QFilter qFilter1 = null;
            for (Map<String, String> memberMap : memberMapList) {
                Long audittrailId;
                Long datatypeId;
                Long currencyId;
                Long versionId;
                Long budgetperiodId;
                Long accountId;
                QFBuilder qfBuilder = new QFBuilder();
                Long entityId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.Entity.getNumber(), dimViewMap);
                if (entityId != null) {
                    qfBuilder.add(new QFilter("entity", "=", (Object)entityId));
                }
                if ((accountId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.Account.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("account", "=", (Object)accountId));
                }
                if ((budgetperiodId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.BudgetPeriod.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("budgetperiod", "=", (Object)budgetperiodId));
                }
                if ((versionId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.Version.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("version", "=", (Object)versionId));
                }
                if ((currencyId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.Currency.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("currency", "=", (Object)currencyId));
                }
                if ((datatypeId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.DataType.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("datatype", "=", (Object)datatypeId));
                }
                if ((audittrailId = AdjustServiceHelper.getMemberId(memberMap, modelCacheHelper, SysDimensionEnum.AuditTrail.getNumber(), dimViewMap)) != null) {
                    qfBuilder.add(new QFilter("audittrail", "=", (Object)audittrailId));
                }
                QFilter memberFilter = qfBuilder.toFilter();
                if (qFilter1 == null) {
                    qFilter1 = memberFilter;
                    continue;
                }
                qFilter1.or(memberFilter);
            }
            qFilter.and(qFilter1);
        }
        return qFilter;
    }

    public static DynamicObjectCollection getAdjustDys(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, List<Map<String, String>> memberMapList, Map<String, Long> dimViewMap, int[] status, Boolean isShowAll, Long processId) {
        QFilter qFilter = AdjustServiceHelper.getAdjustQfilter(modelCacheHelper, bizModelId, datasetId, memberMapList, dimViewMap, status, isShowAll, processId);
        return EpmThreadLocalUtils.getAdjustDys("eb_decomposeadjust", "id,dimensionjson", qFilter);
    }

    public static Set<Map<String, String>> getAdjustMemberSet(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, List<Map<String, String>> memberMapList, Map<String, Long> dimViewMap, int[] status, Boolean isShowAll, Long processId) {
        DynamicObjectCollection dynamicObjects = AdjustServiceHelper.getAdjustDys(modelCacheHelper, bizModelId, datasetId, memberMapList, dimViewMap, status, isShowAll, processId);
        HashSet<Map<String, String>> set = new HashSet<Map<String, String>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String dimensionjson = dynamicObject.getString("dimensionjson");
            if (StringUtils.isEmpty(dimensionjson)) continue;
            Map memberMap = (Map)JSON.parseObject((String)dimensionjson, Map.class);
            AdjustServiceHelper.addCustomDimNoneMember(memberMap, modelCacheHelper, datasetId);
            set.add(memberMap);
        }
        return set;
    }

    public static Set<Map<String, String>> getAdjustMemberSet(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, Map<String, String> memberMap, Map<String, Long> dimViewMap) {
        return AdjustServiceHelper.getAdjustMemberSet(modelCacheHelper, bizModelId, datasetId, Collections.singletonList(memberMap), dimViewMap, new int[]{DecomposeStatus.WAIT.getValue(), DecomposeStatus.START.getValue()}, true, 0L);
    }

    public static Map<Integer, Set<Map<String, String>>> getAdjustMemberMap(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, Map<String, String> allDimMap, Map<String, Long> dimViewMap) {
        Set<Map<String, String>> adjustMemberSet = AdjustServiceHelper.getAdjustMemberSet(modelCacheHelper, bizModelId, datasetId, allDimMap, dimViewMap);
        HashMap<Integer, Set<Map<String, String>>> adjustMemberMap = new HashMap<Integer, Set<Map<String, String>>>(16);
        for (Map<String, String> memberMap : adjustMemberSet) {
            int hashCode = memberMap.hashCode();
            HashSet<Map<String, String>> set = (HashSet<Map<String, String>>)adjustMemberMap.get(hashCode);
            if (set == null) {
                set = new HashSet<Map<String, String>>(16);
            }
            set.add(memberMap);
            adjustMemberMap.put(hashCode, set);
        }
        return adjustMemberMap;
    }

    public static void checkRollBudget(Long modelId, Map<String, String> dimenData) {
        DynamicObject dataType = BasedataUtil.getDynamicObjectByNumber(modelId, dimenData.get(SysDimensionEnum.DataType.getNumber()), SysDimensionEnum.DataType.getMemberTreemodel());
        String bizModelKey = "bizmodel";
        if (dataType == null || dataType.get(bizModelKey) == null) {
            return;
        }
        DynamicObject bizmodel = dataType.getDynamicObject(bizModelKey);
        if (bizmodel == null || bizmodel.get("number") == null) {
            return;
        }
        String bizModelNumber = bizmodel.getString("number");
        if (ApplicationScenarioEnum.ROLLBUDGET.getNumber().equals(bizModelNumber)) {
            Date rollDateStart = dataType.getDate("datestart");
            DynamicObject budgetPeriod = BasedataUtil.getDynamicObjectByNumber(modelId, dimenData.get(SysDimensionEnum.BudgetPeriod.getNumber()), SysDimensionEnum.BudgetPeriod.getMemberTreemodel());
            Date enddate = budgetPeriod.getDate("enddate");
            if (enddate != null && enddate.before(rollDateStart)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97\u88ab\u9501\u5b9a\u7684\u90e8\u5206\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static void checkDimNotLeaf(IModelCacheHelper modelCacheHelper, Long datasetId, Map<String, String> dimViewMap, Map<String, String> dimenData, AdjustParam adjustParam) {
        StringBuilder notLeafDim = new StringBuilder();
        Member metric = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, dimenData.get(SysDimensionEnum.Metric.getNumber()));
        boolean leaf = AdjustServiceHelper.checkDimNotLeaf(modelCacheHelper, datasetId, dimViewMap, dimenData, adjustParam, notLeafDim);
        if (!metric.isNoLeafStorage() && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)notLeafDim.toString())) {
            String dims = notLeafDim.toString();
            throw new KDBizException(ResManager.loadResFormat((String)"\u53c2\u6570\u201c\u5141\u8bb8\u975e\u660e\u7ec6\u6210\u5458\u5ba1\u6279\u8c03\u6574\u7684\u7ef4\u5ea6\u201d \u672a\u5305\u542b\u7ef4\u5ea6%1\uff0c\u4e0d\u5141\u8bb8\u975e\u660e\u7ec6\u6210\u5458\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"CommonUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[]{dims.substring(0, dims.length() - 1)}));
        }
        if (!leaf) {
            if (!AdjustServiceHelper.isNumberMetric(metric.getDatatype())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u3001\u65e5\u671f\u3001\u679a\u4e3e\u5ea6\u91cf\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5728\u975e\u660e\u7ec6\u6210\u5458\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!metric.hasAgg()) {
                if (adjustParam.isApproveeditnoleafcell()) {
                    if (!metric.isNoLeafStorage()) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u5ea6\u91cf\uff1a%s\u4e3a\u4e0d\u805a\u5408\u7684\u6570\u636e\uff0c\u8bf7\u5f00\u542f\u5ea6\u91cf\u6210\u5458\u7684\u201c\u975e\u660e\u7ec6\u5b58\u50a8\u201d\u5c5e\u6027\u540e\u518d\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_29", (String)"epm-eb-formplugin", (Object[])new Object[]{metric.getName()}));
                    }
                } else {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5ea6\u91cf\uff1a%s\u4e3a\u4e0d\u805a\u5408\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5728\u975e\u660e\u7ec6\u6210\u5458\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_28", (String)"epm-eb-formplugin", (Object[])new Object[]{metric.getName()}));
                }
            }
        }
        if (leaf && !adjustParam.isAdjustleaf()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u201c\u5141\u8bb8\u660e\u7ec6\u6570\u636e\u8c03\u6574\u201d \u672a\u6253\u5f00\uff0c\u4e0d\u5141\u8bb8\u660e\u7ec6\u6210\u5458\u8fdb\u884c\u5ba1\u6279\u8c03\u6574\u3002", (String)"Fn_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static Boolean checkDimNotLeaf(IModelCacheHelper modelCacheHelper, Long datasetId, Map<String, String> dimViewMap, Map<String, String> dimenData, AdjustParam adjustParam, StringBuilder notLeafDim) {
        Boolean leaf = Boolean.TRUE;
        for (Map.Entry<String, String> next : dimenData.entrySet()) {
            Member member;
            String dimenNumber = next.getKey();
            Dimension dimension = modelCacheHelper.getDimension(dimenNumber);
            String dimensionName = dimension.getName();
            String memberNumber = next.getValue();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)memberNumber)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u6570\u636e\u4e0d\u5b8c\u6574\u3002", (String)"CommonUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionName}));
            }
            Long viewId = IDUtils.toLong(dimViewMap.get(dimenNumber));
            if (IDUtils.isEmptyLong(viewId).booleanValue()) {
                viewId = modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, dimenNumber);
            }
            if ((member = modelCacheHelper.getMember(dimenNumber, viewId, memberNumber)) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u7ec4\u5408\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25\u3002", (String)"CommonUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionName}));
            }
            if (member.isLeaf()) continue;
            leaf = false;
            List<String> dims = adjustParam.getDims();
            if (dims.contains(dimenNumber)) continue;
            notLeafDim.append(dimensionName).append(",");
        }
        return leaf;
    }

    public static void canAdjust(IModelCacheHelper modelCacheHelper, Long bizModelId, Long datasetId, Map<String, String> dimViewMap, Map<String, String> dimenData, AdjustParam adjustParam, Long reportProcessId) {
        if (dimenData == null || dimenData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u6570\u636e\u533a\u57df", (String)"Fn_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        AdjustServiceHelper.checkDimensSize(modelCacheHelper, datasetId, dimenData);
        Long modelId = modelCacheHelper.getModelobj().getId();
        AdjustServiceHelper.checkPermission(modelId, datasetId, dimenData, dimViewMap);
        AdjustServiceHelper.checkDimNotLeaf(modelCacheHelper, datasetId, dimViewMap, dimenData, adjustParam);
        AdjustServiceHelper.checkDimenIsNotAdjust(dimenData, modelCacheHelper, dimViewMap);
        AdjustServiceHelper.checkChangeType(dimenData);
        AdjustServiceHelper.checkDecomposeStatus(dimenData, modelId, datasetId, dimViewMap);
        AdjustServiceHelper.checkDataLock(modelId, bizModelId, dimenData);
        AdjustServiceHelper.checkRollBudget(modelId, dimenData);
        AdjustServiceHelper.checkParentRecord(modelCacheHelper, bizModelId, datasetId, dimenData, dimViewMap);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"DataDecomposeService", (String)"checkRules", (Object[])new Object[]{modelCacheHelper.getModelobj().getId(), datasetId, dimenData, dimViewMap});
    }

    public static boolean hasRelationShip(Long modelId, List<Map<String, String>> memberMapList, Map<String, Long> dimViewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        for (int i = 0; i < memberMapList.size() - 1; ++i) {
            for (int j = i + 1; j < memberMapList.size(); ++j) {
                for (Map.Entry<String, String> entry : memberMapList.get(i).entrySet()) {
                    String longNumber1;
                    String longNumber;
                    String dim = entry.getKey();
                    Long dimViewId = dimViewMap.get(dim);
                    Member member = modelCache.getMember(dim, dimViewId, entry.getValue());
                    Member member1 = modelCache.getMember(dim, dimViewId, memberMapList.get(j).get(dim));
                    if (member == null || member1 == null || !(longNumber = member.getLongNumber()).contains((longNumber1 = member1.getLongNumber()) + "!") && !longNumber1.contains(longNumber + "!")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Long getMemberId(String dim, Map<String, String> memberMap, IModelCacheHelper modelCacheHelper, Map<String, String> dimViewMap) {
        Long dimViewId = IDUtils.toLong(dimViewMap.get(dim));
        Member member = modelCacheHelper.getMember(dim, dimViewId, memberMap.get(dim));
        if (member == null) {
            return 0L;
        }
        return member.getId();
    }

    public static Member getChildDecomposeAuditTrail(IModelCacheHelper modelCache, String memberNumber) {
        Member member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, memberNumber);
        Member resultMember = null;
        if (!member.isLeaf()) {
            List<Member> childrens = member.getChildren();
            for (Member children : childrens) {
                if (!StringUtils.equals("40", children.getAuditTrailUse())) continue;
                resultMember = children;
                break;
            }
        }
        return resultMember;
    }

    public static Map<String, Long> getDimViewMap(Map<String, String> viewMap) {
        HashMap<String, Long> dimViewMap = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty(viewMap)) {
            for (Map.Entry<String, String> entry : viewMap.entrySet()) {
                dimViewMap.put(entry.getKey(), IDUtils.toLong(entry.getValue()));
            }
        }
        return dimViewMap;
    }

    public static DynamicObject recentRejectRecord(Long processId) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_historyapproverecord", (String)"process,audittime,user,operation", (QFilter[])QFBuilder.newQFilter().add(new QFilter("process", "=", (Object)processId)).add("operation", "=", "unsubmit").toArray(), (String)"audittime desc");
        if (records == null || records.isEmpty()) {
            return null;
        }
        return (DynamicObject)records.get(0);
    }

    static {
        ALLOW_ADJUST_METRIC_TYPE.add(MetricDataTypeEnum.CURRENCY.getIndex());
        ALLOW_ADJUST_METRIC_TYPE.add(MetricDataTypeEnum.NONMONETARY.getIndex());
        ALLOW_ADJUST_METRIC_TYPE.add(MetricDataTypeEnum.RATE.getIndex());
        NOT_ALLOW_ADJUST_DIM = new HashSet<String>(16);
        NOT_ALLOW_ADJUST_DIM.add(SysDimensionEnum.Metric.getNumber());
        NOT_ALLOW_ADJUST_DIM.add(SysDimensionEnum.DataType.getNumber());
        NOT_ALLOW_ADJUST_DIM.add(SysDimensionEnum.ChangeType.getNumber());
        NOT_ALLOW_ADJUST_DIM.add(SysDimensionEnum.Currency.getNumber());
        NOT_ALLOW_ADJUST_DIM.add(SysDimensionEnum.Version.getNumber());
    }
}

