/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import kd.bos.form.IPageCache;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.rule.edit.RuleBatchPlanPojo;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.cache.Cache;
import org.apache.commons.lang3.StringUtils;

public class CacheUtils {
    public static <T> void loadingCachePut(String keyString, T t) {
        LoadingCacheSingleton.instance.put((Object)keyString, t);
    }

    public static <T> T loadingCacheGet(String keyString) {
        try {
            Object object = LoadingCacheSingleton.instance.get((Object)keyString);
            if (object == null || object.equals(NullPojoSingleton.instance)) {
                return null;
            }
            return (T)object;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeIfAbsent(Striped<Lock> striped, String keyString, Supplier<T> supplier) {
        T t = CacheUtils.loadingCacheGet(keyString);
        if (t == null) {
            Lock lock = (Lock)striped.get((Object)keyString);
            lock.lock();
            try {
                t = CacheUtils.loadingCacheGet(keyString);
                if (t == null) {
                    t = supplier.get();
                    CacheUtils.loadingCachePut(keyString, t);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return t;
    }

    public static <T> T loadingCacheComputeIfAbsent(String keyString, Supplier<T> supplier) {
        return CacheUtils.computeIfAbsent(StripedSingleton.instance, keyString, supplier);
    }

    public static void loadingCacheInvalidateAll() {
        LoadingCacheSingleton.instance.invalidateAll();
    }

    public static void loadingCacheInvalidate(String keyString) {
        LoadingCacheSingleton.instance.invalidate((Object)keyString);
    }

    public static <T> T get(IPageCache pageCache, String keyString, Class<T> clazz) {
        String valueString = pageCache.get(keyString);
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return null;
        }
        return JsonUtils.readValue(valueString, clazz);
    }

    public static <T> T get(IPageCache pageCache, String keyString, TypeReference<T> typeReference) {
        String valueString = pageCache.get(keyString);
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return null;
        }
        return JsonUtils.readValue(valueString, typeReference);
    }

    public static <T> T put(IPageCache pageCache, String keyString, T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof String) {
            String contentString = (String)t;
            if (StringUtils.isBlank((CharSequence)contentString)) {
                return null;
            }
            pageCache.put(keyString, contentString);
            CacheUtils.putRuleBatchCellPojoMapCache(keyString, contentString);
        } else if (t instanceof Number) {
            Number number = (Number)t;
            pageCache.put(keyString, number.toString());
            CacheUtils.putRuleBatchCellPojoMapCache(keyString, number.toString());
        } else if (t instanceof RuleBatchPlanPojo) {
            pageCache.put(keyString, ObjectSerialUtil.toByteSerialized(t));
        } else {
            pageCache.put(keyString, JsonUtils.getJsonString(t));
            CacheUtils.putRuleBatchCellPojoMapCache(keyString, JsonUtils.getJsonString(t));
        }
        return t;
    }

    private static void putRuleBatchCellPojoMapCache(String keyString, String jsonString) {
        if ("RULE_BATCH_CELL_POJO_MAP".equals(keyString)) {
            Cache.get().set(keyString, jsonString, 10, TimeUnit.MINUTES);
        }
    }

    public static <T> T put(IPageCache pageCache, T t) {
        if (t == null) {
            return null;
        }
        return CacheUtils.put(pageCache, t.getClass().getName(), t);
    }

    public static String get(IPageCache pageCache, String keyString) {
        return pageCache.get(keyString);
    }

    public static <T> T get(IPageCache pageCache, Class<T> clazz) {
        String valueString = pageCache.get(clazz.getName());
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return null;
        }
        if (RuleBatchPlanPojo.class.equals(clazz)) {
            return ObjectSerialUtil.deSerializedBytes(valueString);
        }
        return JsonUtils.readValue(valueString, clazz);
    }

    public static <T> String getJsonString(IPageCache pageCache, Class<T> clazz) {
        return pageCache.get(clazz.getName());
    }

    public static String getAndRemove(IPageCache pageCache, String keyString) {
        try {
            String string = pageCache.get(keyString);
            return string;
        }
        finally {
            pageCache.remove(keyString);
        }
    }

    public static <T> void remove(IPageCache pageCache, T t) {
        if (t instanceof String) {
            pageCache.remove((String)t);
            return;
        }
        if (t instanceof Class) {
            pageCache.remove(((Class)t).getName());
            return;
        }
        pageCache.remove(t.getClass().getName());
    }

    public static boolean setBoolean(IPageCache pageCache, String keyString, boolean cacheKeyBoolean) {
        if (cacheKeyBoolean) {
            pageCache.put(keyString, keyString);
        } else {
            pageCache.remove(keyString);
        }
        return cacheKeyBoolean;
    }

    public static boolean getBoolean(IPageCache pageCache, String keyString) {
        return StringUtils.isNotEmpty((CharSequence)pageCache.get(keyString));
    }

    public static boolean getAndRemoveBoolean(IPageCache pageCache, String keyString) {
        boolean resultBoolean = CacheUtils.getBoolean(pageCache, keyString);
        pageCache.remove(keyString);
        return resultBoolean;
    }

    public static class StripedSingleton {
        public static final Striped<Lock> instance = Striped.lock((int)16);
    }

    private static class LoadingCacheSingleton {
        public static final LoadingCache<String, Object> instance = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String keyString) {
                return NullPojoSingleton.instance;
            }
        });

        private LoadingCacheSingleton() {
        }
    }

    private static class NullPojoSingleton {
        public static final NullPojo instance = new NullPojo();

        private NullPojoSingleton() {
        }
    }

    private static class NullPojo {
        private NullPojo() {
        }
    }
}

