/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.eb.common.pojo.DbBatchPojo;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmColumnAnnotation;
import kd.epm.eb.common.utils.base.StrUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DbUtils {
    public static final DBRoute EPM_DBROUTE = DBRoute.of((String)"epm");
    public static final String PREFIX_STRING = DbUtils.class.getName();
    public static final String id = "id";

    public static List<Map<String, Object>> getRowMapList(String algoKeyString, DBRoute dbRoute, String sqlString, Object[] paramObjectArray, Integer limitInteger) {
        LinkedList<Map<String, Object>> rowMapList = new LinkedList<Map<String, Object>>();
        List<String> fieldStringList = DbUtils.getFieldStringList(sqlString);
        int columnFieldSizeInt = fieldStringList.size();
        try (DataSet dataSet = DB.queryDataSet((String)algoKeyString, (DBRoute)dbRoute, (String)sqlString, (Object[])paramObjectArray);){
            int i = 1;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                LinkedHashMap rowMap = Maps.newLinkedHashMapWithExpectedSize((int)columnFieldSizeInt);
                for (String fieldString : fieldStringList) {
                    rowMap.put(fieldString, row.get(fieldString));
                }
                rowMapList.add(rowMap);
                if (limitInteger != null && limitInteger > 0 && limitInteger == i) {
                    LinkedList<Map<String, Object>> linkedList = rowMapList;
                    return linkedList;
                }
                ++i;
            }
        }
        return rowMapList;
    }

    public static List<Map<String, Object>> getRowMapList(String algoKeyString, DBRoute dbRoute, String sqlString, Object[] paramObjectArray) {
        return DbUtils.getRowMapList(algoKeyString, dbRoute, sqlString, paramObjectArray, null);
    }

    public static List<String> getFieldStringList(String originalSqlString) {
        String sqlString = originalSqlString.toLowerCase();
        if (!(sqlString = sqlString.trim()).startsWith("select ")) {
            throw new RuntimeException("The sqlString is not start with 'select ', please check.");
        }
        int fromIndexInt = sqlString.indexOf(" from ");
        sqlString = sqlString.substring(7, fromIndexInt);
        return Arrays.stream(sqlString.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static String getInValueString(Collection<Long> longCollection) {
        StringBuilder stringBuilder = new StringBuilder("(");
        boolean firstItemBoolean = true;
        for (Long valueLong : longCollection) {
            if (valueLong == null || 0L == valueLong) continue;
            if (firstItemBoolean) {
                firstItemBoolean = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(valueLong);
        }
        return stringBuilder.append(")").toString();
    }

    public static String getInValueString(Long ... longArray) {
        return DbUtils.getInValueString(Arrays.asList(longArray));
    }

    public static Map<String, Object> getColumnMap(DynamicObject dynamicObject) {
        try {
            if (dynamicObject == null) {
                return null;
            }
            Class<?> clazz = dynamicObject.getClass();
            Field dtField = clazz.getDeclaredField("dt");
            ReflectionUtils.makeAccessible((Field)dtField);
            DynamicObjectType dynamicObjectType = (DynamicObjectType)dtField.get(dynamicObject);
            DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObjectType.getProperties();
            List keyStringList = dataEntityPropertyCollection.stream().map(idataEntityProperty -> {
                String aliasString = idataEntityProperty.getAlias();
                if (StringUtils.isNotBlank((CharSequence)aliasString)) {
                    return aliasString.toLowerCase();
                }
                return idataEntityProperty.getName().toLowerCase();
            }).collect(Collectors.toList());
            Field dataStorageField = clazz.getDeclaredField("dataStorage");
            ReflectionUtils.makeAccessible((Field)dataStorageField);
            IDataStorage iDataStorage = (IDataStorage)dataStorageField.get(dynamicObject);
            Field valuesField = iDataStorage.getClass().getDeclaredField("values");
            ReflectionUtils.makeAccessible((Field)valuesField);
            Object[] valueObjectArray = (Object[])valuesField.get(iDataStorage);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(keyStringList.size());
            int sizeInt = keyStringList.size();
            for (int i = 0; i < sizeInt; ++i) {
                map.put((String)keyStringList.get(i), valueObjectArray[i]);
            }
            return map;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static Map<String, String> getStringDynamicObjectMap(DynamicObject dynamicObject) {
        Map<String, Object> columnMap = DbUtils.getColumnMap(dynamicObject);
        if (columnMap == null || columnMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>(10);
        for (Map.Entry<String, Object> entry : columnMap.entrySet()) {
            String keyString = entry.getKey();
            Object valueObject = entry.getValue();
            if (valueObject == null) {
                stringMap.put(keyString, null);
                continue;
            }
            if (valueObject instanceof String) {
                stringMap.put(keyString, (String)valueObject);
                continue;
            }
            stringMap.put(keyString, valueObject.toString());
        }
        return stringMap;
    }

    public static List<String> getSelectFieldStringList(String selectFieldsString) {
        String[] fieldStringArray = selectFieldsString.split(",");
        return Arrays.stream(fieldStringArray).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> getMapList(DataSet dataSet, String selectFieldArrayString) {
        List<String> selectFieldStringList = DbUtils.getSelectFieldStringList(selectFieldArrayString);
        int selectFieldStringListSizeInt = selectFieldStringList.size();
        LinkedList<Map<String, Object>> mapList = new LinkedList<Map<String, Object>>();
        for (Row row : dataSet) {
            LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)selectFieldStringListSizeInt);
            for (String selectFieldString : selectFieldStringList) {
                map.put(selectFieldString, row.get(selectFieldString));
            }
            mapList.add(map);
        }
        return mapList;
    }

    public static Map<String, Map<String, Object>> getColumnMap(DataSet dataSet, String selectFieldArrayString, String columnString) {
        if (StringUtils.isBlank((CharSequence)columnString)) {
            return null;
        }
        List<Map<String, Object>> mapList = DbUtils.getMapList(dataSet, selectFieldArrayString);
        if (CollectionUtils.isEmpty(mapList)) {
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> columnMap = new LinkedHashMap<String, Map<String, Object>>(16);
        for (Map<String, Object> map : mapList) {
            Object valueObject = map.get(columnString);
            if (valueObject == null) continue;
            String itemColumnString = null;
            itemColumnString = valueObject instanceof String ? (String)valueObject : valueObject.toString();
            if (StringUtils.isBlank((CharSequence)itemColumnString)) continue;
            if (columnMap.containsKey(itemColumnString)) {
                throw new RuntimeException(StrUtils.format("Duplicate key: {}", itemColumnString));
            }
            columnMap.put(itemColumnString, map);
        }
        return columnMap;
    }

    public static List<Map<String, String>> getMapList(Collection<DynamicObject> dynamicObjectCollection) {
        if (CollectionUtils.isEmpty(dynamicObjectCollection)) {
            return null;
        }
        ArrayList<Map<String, String>> stringDynamicObjectMapList = new ArrayList<Map<String, String>>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            stringDynamicObjectMapList.add(DbUtils.getStringDynamicObjectMap(dynamicObject));
        }
        return stringDynamicObjectMapList;
    }

    public static List<Map<String, String>> getMapList(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        return DbUtils.getMapList(new ArrayList<DynamicObject>((Collection<DynamicObject>)dynamicObjectCollection));
    }

    public static Map<String, Map<String, Object>> getColumnRowMap(String algoKeyString, DBRoute dbRoute, String sqlString, Object[] paramObjectArray, String columnNameString) {
        List<Map<String, Object>> rowMapList = DbUtils.getRowMapList(algoKeyString, dbRoute, sqlString, paramObjectArray);
        LinkedHashMap<String, Map<String, Object>> rowMap = new LinkedHashMap<String, Map<String, Object>>(10);
        for (Map<String, Object> map : rowMapList) {
            String string = ObjUtils.getString(map.get(columnNameString));
            if (StringUtils.isBlank((CharSequence)string)) continue;
            rowMap.put(string, map);
        }
        return rowMap;
    }

    public static void executeBatch(DbBatchPojo ... batchPojoArray) {
        if (ArrayUtils.isEmpty((Object[])batchPojoArray)) {
            return;
        }
        for (DbBatchPojo dbBatchPojo : batchPojoArray) {
            DbUtils.executeSingleBatch(dbBatchPojo);
        }
    }

    public static void executeSingleBatch(DbBatchPojo dbBatchPojo) {
        if (dbBatchPojo == null || CollectionUtils.isEmpty(dbBatchPojo.getParamArrayList())) {
            return;
        }
        DB.executeBatch((DBRoute)dbBatchPojo.getDbRoute(), (String)dbBatchPojo.getSqlString(), dbBatchPojo.getParamArrayList());
    }

    public static <T> List<T> getList(List<Map<String, Object>> rowMapList, Class<T> clazz) {
        Map<String, Field> fieldMap = FieldUtils.getFieldsListWithAnnotation(clazz, OrmColumnAnnotation.class).stream().collect(Collectors.toMap(item -> item.getAnnotation(OrmColumnAnnotation.class).value(), item -> item));
        return rowMapList.stream().map(item -> DbUtils.getInstance(clazz, item, fieldMap)).collect(Collectors.toList());
    }

    public static Object getFieldValueObject(Field field, Object valueObject) {
        Class<?> typeClass = field.getType();
        if (typeClass == String.class) {
            return ObjUtils.getString(valueObject);
        }
        if (typeClass == Long.class) {
            if (valueObject instanceof Date) {
                return ((Date)valueObject).getTime();
            }
            if (valueObject instanceof Timestamp) {
                return ((Timestamp)valueObject).getTime();
            }
            return ObjUtils.getLong(valueObject);
        }
        return null;
    }

    public static <T> List<T> getRowMapList(Class<T> clazz, String algoKeyString, DBRoute dbRoute, String sqlString, Object[] paramObjectArray) {
        return DbUtils.getList(DbUtils.getRowMapList(algoKeyString, dbRoute, sqlString, paramObjectArray), clazz);
    }

    public static <T> T getInstance(Class<T> clazz, Map<String, Object> map, Map<String, Field> fieldMap) {
        try {
            T t = clazz.newInstance();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Field field = fieldMap.get(entry.getKey());
                ReflectionUtils.makeAccessible((Field)field);
                field.set(t, DbUtils.getFieldValueObject(field, entry.getValue()));
            }
            return t;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T txHandle(Supplier<T> supplier) {
        return DbUtils.txHandle(null, supplier);
    }

    public static <T> T txHandle(String tagString, Supplier<T> supplier) {
        if (StringUtils.isBlank((CharSequence)tagString)) {
            tagString = StrUtils.getSimpleUuidIdString();
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required((String)(PREFIX_STRING + tagString));){
            T t = supplier.get();
            return t;
        }
        catch (Throwable throwable2) {
            try {
                txHandle.markRollback();
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    public static void txHandle(Runnable runnable) {
        DbUtils.txHandle(null, () -> {
            runnable.run();
            return null;
        });
    }

    public static void txHandle(String tagString, Runnable runnable) {
        DbUtils.txHandle(tagString, () -> {
            runnable.run();
            return null;
        });
    }
}

