/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.DynamicAlertPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class DynamicAlertUtils {
    private static final Log log = LogFactory.getLog(DynamicAlertUtils.class);
    public static final String read_more = "read_more";
    public static final String know = "know";
    public static final String eb_dynamic_alert = "eb_dynamic_alert";

    public static void openDynamicAlert(IFormView currentFormView, DynamicAlertPojo dynamicAlertPojo, CloseCallBack closeCallBack) {
        if (currentFormView == null || dynamicAlertPojo == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(eb_dynamic_alert);
        formShowParameter.setParentPageId(currentFormView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        String showTypeEnumString = dynamicAlertPojo.getShowTypeEnumString();
        ShowType showType = (ShowType)EnumUtils.getEnum(ShowType.class, (String)showTypeEnumString);
        if (showType == null) {
            showType = ShowType.Modal;
            dynamicAlertPojo.setShowTypeEnumString(showType.name());
        }
        formShowParameter.getOpenStyle().setShowType(showType);
        if (ShowType.Modal.equals((Object)showType)) {
            StylePojo stylePojo = dynamicAlertPojo.getStylePojo();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth(LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getWidthString())) {
                    return "460px";
                }
                return stylePojo.getWidthString();
            }));
            styleCss.setHeight(LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getHeightString())) {
                    return "400px";
                }
                return stylePojo.getHeightString();
            }));
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        }
        if (StringUtils.isBlank((CharSequence)dynamicAlertPojo.getTitleString())) {
            dynamicAlertPojo.setTitleString("");
        }
        if (StringUtils.isBlank((CharSequence)dynamicAlertPojo.getDescriptionString())) {
            dynamicAlertPojo.setDescriptionString("");
        }
        if (StringUtils.isBlank((CharSequence)dynamicAlertPojo.getMessageString())) {
            dynamicAlertPojo.setMessageString("");
        }
        if (StringUtils.isBlank((CharSequence)dynamicAlertPojo.getPageTitleString())) {
            dynamicAlertPojo.setPageTitleString(dynamicAlertPojo.getTitleString());
        }
        formShowParameter.setCustomParam(DynamicAlertPojo.class.getName(), (Object)JsonUtils.getJsonString(dynamicAlertPojo));
        if (StringUtils.isNotBlank((CharSequence)dynamicAlertPojo.getPageTitleString())) {
            formShowParameter.setCaption(dynamicAlertPojo.getPageTitleString());
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        currentFormView.showForm(formShowParameter);
    }

    public static void openDynamicAlert(IFormView currentFormView, DynamicAlertPojo dynamicAlertPojo) {
        DynamicAlertUtils.openDynamicAlert(currentFormView, dynamicAlertPojo, null);
    }
}

