/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.DynamicEditPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class DynamicEditUtils {
    private static final Log log = LogFactory.getLog(DynamicAlertUtils.class);
    public static final String eb_dynamic_edit = "eb_dynamic_edit";

    public static void open(IFormView currentFormView, DynamicEditPojo dynamicEditPojo, CloseCallBack closeCallBack) {
        if (currentFormView == null || dynamicEditPojo == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(eb_dynamic_edit);
        formShowParameter.setParentPageId(currentFormView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        String showTypeEnumString = dynamicEditPojo.getShowTypeEnumString();
        ShowType showType = (ShowType)EnumUtils.getEnum(ShowType.class, (String)showTypeEnumString);
        if (showType == null) {
            showType = ShowType.Modal;
            dynamicEditPojo.setShowTypeEnumString(showType.name());
        }
        formShowParameter.getOpenStyle().setShowType(showType);
        if (ShowType.Modal.equals((Object)showType)) {
            StylePojo stylePojo = dynamicEditPojo.getStylePojo();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth(LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getWidthString())) {
                    return "460px";
                }
                return stylePojo.getWidthString();
            }));
            styleCss.setHeight(LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getHeightString())) {
                    return "400px";
                }
                return stylePojo.getHeightString();
            }));
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        }
        if (StringUtils.isBlank((CharSequence)dynamicEditPojo.getTitleString())) {
            dynamicEditPojo.setTitleString("");
        }
        if (StringUtils.isBlank((CharSequence)dynamicEditPojo.getMessageString())) {
            dynamicEditPojo.setMessageString("");
        }
        formShowParameter.setCustomParam(DynamicEditPojo.class.getName(), (Object)JsonUtils.getJsonString(dynamicEditPojo));
        if (StringUtils.isNotBlank((CharSequence)dynamicEditPojo.getPageTitleString())) {
            formShowParameter.setCaption(dynamicEditPojo.getPageTitleString());
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"DynamicEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        currentFormView.showForm(formShowParameter);
    }
}

