/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.common.pojo.ElementPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.utils.base.StyleUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ElementUtils {
    public static final String DIV_STRING = "div";
    public static final String SPAN_STRING = "span";
    public static final String STYLE_STRING = "style";
    public static final String CLASS_STRING = "class";
    public static final String ONE_SPACE_STRING = " ";
    public static final String FOUR_SPACE_STRING = "    ";
    public static final String EMPTY_STRING = "";
    public static final String NEW_LINE_STRING = "\n";
    public static final String GREATER_THAN_SIGN_STRING = ">";
    public static final String LESS_THAN_SIGN_STRING = "<";
    public static final String DIVISION_SIGN_STRING = "/";
    public static final String EQUAL_SIGN_STRING = "=";
    public static final String QUOTATION_MARK_STRING = "\"";
    public static final String HTML_STRING = "HTML";
    public static final String BR_STRING = "</br>";
    public static final String ORIGIN_STRING = "ORIGIN_STRING";
    public static final String ROOT_STRING = "ROOT_STRING";
    public static final String rowspan = "rowspan";
    public static final String colspan = "colspan";
    public static final String tr = "tr";
    public static final String td = "td";
    public static final String input = "input";
    public static final String type = "type";
    public static final String value = "value";
    public static final String table = "table";
    public static final String thead = "thead";
    public static final String tbody = "tbody";
    public static final String th = "th";
    public static final String id = "id";
    public static final String width = "width";
    public static final String height = "height";

    public static ElementPojo create(String nameString) {
        ElementPojo elementPojo = new ElementPojo();
        elementPojo.setNameString(nameString);
        return elementPojo;
    }

    public static ElementPojo createDivElementPojo() {
        return ElementUtils.create(DIV_STRING);
    }

    public static String getString(ElementPojo elementPojo) {
        return ElementUtils.getString(elementPojo, (Boolean)false);
    }

    public static ElementPojo getRootElementPojo(List<ElementPojo> elementPojoList) {
        List rootElementPojoList = elementPojoList.stream().filter(item -> item.getParentElementPojo() == null).collect(Collectors.toList());
        if (rootElementPojoList.size() != 1) {
            return null;
        }
        ElementPojo rootElementPojo = (ElementPojo)rootElementPojoList.get(0);
        ArrayList<ElementPojo> tempElementPojoArrayList = new ArrayList<ElementPojo>(elementPojoList);
        ElementUtils.getRootElementPojo(rootElementPojo, tempElementPojoArrayList);
        return rootElementPojo;
    }

    public static void getRootElementPojo(ElementPojo elementPojo, List<ElementPojo> elementPojoList) {
        if (elementPojo == null || elementPojoList == null || elementPojoList.isEmpty()) {
            return;
        }
        elementPojoList.remove(elementPojo);
        List<ElementPojo> subElementList = elementPojoList.stream().filter(item -> {
            ElementPojo parentElementPojo = item.getParentElementPojo();
            if (parentElementPojo == null) {
                return false;
            }
            return parentElementPojo == elementPojo;
        }).collect(Collectors.toList());
        if (subElementList.isEmpty()) {
            return;
        }
        elementPojo.setElementPojoList(subElementList);
        for (ElementPojo subElementPojo : subElementList) {
            ElementUtils.getRootElementPojo(subElementPojo, elementPojoList);
        }
    }

    public static String getString(List<ElementPojo> elementPojoList, Boolean formatBoolean) {
        ElementPojo rootElementPojo = ElementUtils.getRootElementPojo(elementPojoList);
        if (rootElementPojo == null) {
            return null;
        }
        return ElementUtils.getString(rootElementPojo, formatBoolean);
    }

    public static String getString(ElementPojo elementPojo, Boolean formatBoolean) {
        List<ElementPojo> elementPojoList;
        List<String> classStringList;
        StylePojo stylePojo;
        String styleString;
        if (elementPojo.getTextString() != null) {
            return elementPojo.getTextString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Integer deepInteger = null;
        if (Boolean.TRUE.equals(formatBoolean)) {
            deepInteger = ElementUtils.getDeepInteger(elementPojo, null);
            if (deepInteger != 0) {
                stringBuilder.append(NEW_LINE_STRING);
            }
            stringBuilder.append(ElementUtils.repeat(FOUR_SPACE_STRING, deepInteger));
        }
        stringBuilder.append(LESS_THAN_SIGN_STRING);
        stringBuilder.append(elementPojo.getNameString());
        LinkedHashMap<String, String> finalAttributeMap = new LinkedHashMap<String, String>(16);
        Map<String, String> attributeMap = elementPojo.getAttributeMap();
        if (attributeMap != null && !attributeMap.isEmpty()) {
            finalAttributeMap.putAll(attributeMap);
        }
        if (StringUtils.isNotBlank((CharSequence)(styleString = StyleUtils.getString(stylePojo = elementPojo.getStylePojo())))) {
            String valueStyleString = (String)finalAttributeMap.get(STYLE_STRING);
            if (StringUtils.isBlank((CharSequence)valueStyleString)) {
                valueStyleString = EMPTY_STRING;
            }
            finalAttributeMap.put(STYLE_STRING, styleString + valueStyleString);
        }
        if (CollectionUtils.isNotEmpty(classStringList = elementPojo.getClassStringList())) {
            StringBuilder classStringBuilder = new StringBuilder();
            for (String classString : classStringList) {
                if (StringUtils.isBlank((CharSequence)classString)) continue;
                classStringBuilder.append(classString);
                classStringBuilder.append(ONE_SPACE_STRING);
            }
            String classString = classStringBuilder.toString();
            String valueClassString = (String)finalAttributeMap.get(CLASS_STRING);
            if (StringUtils.isBlank((CharSequence)valueClassString)) {
                valueClassString = EMPTY_STRING;
            }
            if (StringUtils.isNotBlank((CharSequence)classString)) {
                finalAttributeMap.put(CLASS_STRING, (classString + valueClassString).trim());
            }
        }
        finalAttributeMap.forEach((key, value) -> {
            stringBuilder.append(ONE_SPACE_STRING);
            stringBuilder.append((String)key);
            stringBuilder.append(EQUAL_SIGN_STRING);
            stringBuilder.append(QUOTATION_MARK_STRING);
            stringBuilder.append((String)value);
            stringBuilder.append(QUOTATION_MARK_STRING);
        });
        List<String> attributeStringList = elementPojo.getAttributeStringList();
        if (attributeStringList != null && !attributeStringList.isEmpty()) {
            attributeStringList.forEach(attributeString -> {
                stringBuilder.append(ONE_SPACE_STRING);
                stringBuilder.append((String)attributeString);
            });
        }
        if ((elementPojoList = elementPojo.getElementPojoList()) == null || elementPojoList.isEmpty()) {
            if (Boolean.TRUE.equals(elementPojo.getSingleBoolean())) {
                stringBuilder.append(DIVISION_SIGN_STRING);
                stringBuilder.append(GREATER_THAN_SIGN_STRING);
                return stringBuilder.toString();
            }
            stringBuilder.append(GREATER_THAN_SIGN_STRING);
            if (elementPojo.getValueString() != null) {
                stringBuilder.append(elementPojo.getValueString());
            }
            stringBuilder.append(LESS_THAN_SIGN_STRING);
            stringBuilder.append(DIVISION_SIGN_STRING);
            stringBuilder.append(elementPojo.getNameString());
            stringBuilder.append(GREATER_THAN_SIGN_STRING);
        } else {
            stringBuilder.append(GREATER_THAN_SIGN_STRING);
            elementPojoList.forEach(subElementPojo -> {
                subElementPojo.setParentElementPojo(elementPojo);
                stringBuilder.append(ElementUtils.getString(subElementPojo, formatBoolean));
            });
            if (Boolean.TRUE.equals(formatBoolean) && deepInteger != null) {
                stringBuilder.append(NEW_LINE_STRING);
                stringBuilder.append(ElementUtils.repeat(FOUR_SPACE_STRING, deepInteger));
            }
            stringBuilder.append(LESS_THAN_SIGN_STRING);
            stringBuilder.append(DIVISION_SIGN_STRING);
            stringBuilder.append(elementPojo.getNameString());
            stringBuilder.append(GREATER_THAN_SIGN_STRING);
        }
        return stringBuilder.toString();
    }

    public static Integer getDeepInteger(ElementPojo elementPojo, Integer deepInteger) {
        if (deepInteger == null) {
            deepInteger = 0;
        }
        if (elementPojo.getParentElementPojo() == null) {
            return deepInteger;
        }
        deepInteger = deepInteger + 1;
        return ElementUtils.getDeepInteger(elementPojo.getParentElementPojo(), deepInteger);
    }

    public static String repeat(String string, int countInt) {
        if (null == string) {
            return null;
        }
        if (countInt <= 0 || string.length() == 0) {
            return EMPTY_STRING;
        }
        if (countInt == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < countInt; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

