/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import org.apache.commons.lang3.StringUtils;

public class EnumUtils {
    public static <E extends Enum<E>> E getEnum(Class<E> clazz, Integer indexInteger) {
        if (indexInteger == null || indexInteger < 0) {
            return null;
        }
        Enum[] enumObjectArray = (Enum[])clazz.getEnumConstants();
        if (enumObjectArray == null || indexInteger + 1 > enumObjectArray.length) {
            return null;
        }
        return (E)enumObjectArray[indexInteger];
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, Long indexLong) {
        if (indexLong == null) {
            return null;
        }
        return EnumUtils.getEnum(clazz, indexLong.intValue());
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String nameString) {
        if (StringUtils.isBlank((CharSequence)nameString)) {
            return null;
        }
        Enum[] enumObjectArray = (Enum[])clazz.getEnumConstants();
        if (enumObjectArray == null) {
            return null;
        }
        for (Enum e : enumObjectArray) {
            if (!nameString.equals(e.name())) continue;
            return (E)e;
        }
        return null;
    }

    @SafeVarargs
    public static <E extends Enum<E>> boolean equalsAny(Enum<E> itemEnum, Enum<E> ... enumArray) {
        if (itemEnum == null || enumArray == null || enumArray.length == 0) {
            return false;
        }
        for (Enum<E> currentItemEnum : enumArray) {
            if (itemEnum != currentItemEnum) continue;
            return true;
        }
        return false;
    }
}

