/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.base.ThreadUtils;

public class EpmLogUtils {
    protected static final Log LOG = LogFactory.getLog(EpmLogUtils.class);
    protected static final String CLASS_NAME = EpmLogUtils.class.getName();
    protected static final String NULL_SIGN_STRING = "[NULL]";
    protected static final String EMPTY_SIGN_STRING = "[EMPTY]";
    protected static final String ERROR_SIGN_STRING = "[ERROR]";
    protected static final String EPM_LOG_UTILS_SIGN_STRING = "[EpmLogUtils]";

    private static void logSupplier(String classNameString, String excludedStackTraceElementString, Supplier<Object> supplier, Function<Object, Object> parserFunction) {
        try {
            String string;
            if (supplier == null) {
                return;
            }
            Object supplierGetObject = supplier.get();
            if (parserFunction != null) {
                supplierGetObject = parserFunction.apply(supplierGetObject);
            }
            if (supplierGetObject == null) {
                string = NULL_SIGN_STRING;
            } else {
                string = supplierGetObject instanceof String ? (String)supplierGetObject : supplierGetObject.toString();
                if ("".equals(string)) {
                    string = EMPTY_SIGN_STRING;
                }
            }
            int stringLengthInt = string.length();
            int cutLengthInt = 8000;
            int totalPageInt = stringLengthInt / cutLengthInt;
            if (stringLengthInt % cutLengthInt != 0) {
                ++totalPageInt;
            }
            int partInt = 1;
            int beginIndexInt = 0;
            int endIndexInt = cutLengthInt;
            if (endIndexInt > stringLengthInt) {
                endIndexInt = stringLengthInt;
            }
            while (true) {
                String substring = string.substring(beginIndexInt, endIndexInt);
                LOG.error("[EpmLogUtils](" + partInt + "/" + totalPageInt + ")[" + excludedStackTraceElementString + "]: " + substring);
                beginIndexInt = endIndexInt;
                if (beginIndexInt < stringLengthInt) {
                    if ((endIndexInt += cutLengthInt) > stringLengthInt) {
                        endIndexInt = stringLengthInt;
                    }
                    ++partInt;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            LOG.error("[ERROR][EpmLogUtils]" + classNameString, throwable);
        }
    }

    public static void logSupplierCollection(Object object, Collection<Supplier<Object>> supplierCollection, Function<Object, Object> parserFunction) {
        try {
            if (supplierCollection == null || supplierCollection.isEmpty()) {
                return;
            }
            String classNameString = CLASS_NAME;
            if (object != null) {
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                classNameString = clazz.getName();
            }
            if (!LogSignHelper.getLogSignByGropNum(classNameString).contains(classNameString)) {
                return;
            }
            String excludedStackTraceElementString = ThreadUtils.getExcludedStackTraceElementString(CLASS_NAME);
            for (Supplier<Object> supplier : supplierCollection) {
                EpmLogUtils.logSupplier(classNameString, excludedStackTraceElementString, supplier, parserFunction);
            }
        }
        catch (Throwable throwable) {
            LOG.error("[ERROR][EpmLogUtils]", throwable);
        }
    }

    public static void logSupplier(Object object, Supplier<Object> ... supplierArray) {
        if (supplierArray == null || supplierArray.length == 0) {
            return;
        }
        EpmLogUtils.logSupplierCollection(object, Arrays.asList(supplierArray), null);
    }

    public static void logObject(Object object, Object ... needLogObjectArray) {
        if (needLogObjectArray == null || needLogObjectArray.length == 0) {
            return;
        }
        ArrayList<Supplier<Object>> supplierList = new ArrayList<Supplier<Object>>(needLogObjectArray.length);
        for (Object needLogObject : needLogObjectArray) {
            supplierList.add(() -> needLogObject);
        }
        EpmLogUtils.logSupplierCollection(object, supplierList, null);
    }

    public static void logObjectWithParser(Object object, Object ... needLogObjectArray) {
        if (needLogObjectArray == null || needLogObjectArray.length == 0) {
            return;
        }
        ArrayList<Supplier<Object>> supplierList = new ArrayList<Supplier<Object>>(needLogObjectArray.length);
        for (Object needLogObject : needLogObjectArray) {
            supplierList.add(() -> needLogObject);
        }
        EpmLogUtils.logSupplierCollection(object, supplierList, EpmLogUtils.getPreMadeParserFunction());
    }

    public static void logSupplerWithParser(Object object, Supplier<Object> ... supplierArray) {
        if (supplierArray == null || supplierArray.length == 0) {
            return;
        }
        EpmLogUtils.logSupplierCollection(object, Arrays.asList(supplierArray), EpmLogUtils.getPreMadeParserFunction());
    }

    public static Function<Object, Object> getPreMadeParserFunction() {
        return EpmLogUtils::getPreMadeParserObject;
    }

    public static Object getPreMadeParserObject(Object object) {
        if (object instanceof ILocaleString) {
            ILocaleString localeString = (ILocaleString)object;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
            map.put("value", localeString.getLocaleValue());
            map.put("en", localeString.getLocaleValue_en());
            map.put("cn", localeString.getLocaleValue_zh_CN());
            map.put("tw", localeString.getLocaleValue_zh_TW());
            map.put("default", localeString.getDefaultItem());
            return map;
        }
        return object;
    }
}

