/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.pojo.NodePojo;
import kd.epm.eb.common.utils.NumberUtils;
import kd.epm.eb.common.utils.base.helper.GraphHelper;

public class GraphUtils {
    private static final Log log = LogFactory.getLog(GraphUtils.class);

    public static int[][] rebuildGraphArray(GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, int[][] intArray) {
        int currentIndexInt;
        List<List<String>> entityNodeIdListList = entityGraphHelper.getNodeIdListList();
        List<List<String>> periodNodeIdListList = periodGraphHelper.getNodeIdListList();
        List<List<String>> notLeafEntityNodeIdListList = entityGraphHelper.getNotLeafNodeIdListList();
        int notLeafEntityNodeIdListListSizeInt = notLeafEntityNodeIdListList.size();
        List<List<String>> notLeafPeriodNodeIdListList = periodGraphHelper.getNotLeafNodeIdListList();
        int notLeafPeriodNodeIdListListSizeInt = notLeafPeriodNodeIdListList.size();
        for (int i = entityNodeIdListList.size() - 1; i >= 0; --i) {
            for (String currentEntityString : entityNodeIdListList.get(i)) {
                int entityIndexInt = entityGraphHelper.getIndexInteger(currentEntityString);
                for (int j = notLeafPeriodNodeIdListListSizeInt - 1; j >= 0; --j) {
                    for (String periodString : notLeafPeriodNodeIdListList.get(j)) {
                        Set periodSuccessorStringSet = periodGraphHelper.getGraph().successors((Object)periodString);
                        currentIndexInt = 0;
                        for (String periodSuccessorString : periodSuccessorStringSet) {
                            currentIndexInt += intArray[entityIndexInt][periodGraphHelper.getIndexInteger(periodSuccessorString)];
                        }
                        intArray[entityIndexInt][periodGraphHelper.getIndexInteger((String)periodString).intValue()] = currentIndexInt;
                    }
                }
            }
        }
        for (int i = periodNodeIdListList.size() - 1; i >= 0; --i) {
            for (String currentPeriodString : periodNodeIdListList.get(i)) {
                int periodIndexInt = periodGraphHelper.getIndexInteger(currentPeriodString);
                for (int j = notLeafEntityNodeIdListListSizeInt - 1; j >= 0; --j) {
                    for (String entityString : notLeafEntityNodeIdListList.get(j)) {
                        Set entitySuccessorStringSet = entityGraphHelper.getGraph().successors((Object)entityString);
                        currentIndexInt = 0;
                        for (String entitySuccessorString : entitySuccessorStringSet) {
                            currentIndexInt += intArray[entityGraphHelper.getIndexInteger(entitySuccessorString)][periodIndexInt];
                        }
                        intArray[entityGraphHelper.getIndexInteger((String)entityString).intValue()][periodIndexInt] = currentIndexInt;
                    }
                }
            }
        }
        return intArray;
    }

    public static int[][] getResultGraphArray(GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, int[][] intArray) {
        List<String> entityStringList = entityGraphHelper.getNodeIdStringList();
        List<String> periodStringList = periodGraphHelper.getNodeIdStringList();
        int periodStringListSizeInt = periodStringList.size();
        int[][] resultGraphArray = NumberUtils.getDeepCloneIntArray(intArray);
        int entityStringListSizeInt = entityStringList.size();
        for (int i = 0; i < entityStringListSizeInt; ++i) {
            for (int j = 0; j < periodStringListSizeInt; ++j) {
                int cellInt = intArray[i][j];
                if (cellInt == 0) continue;
                Set<String> entityLeafNodeIdSet = entityGraphHelper.getLeafNodeIdStringSet(entityStringList.get(i));
                Set<String> periodLeafNodeIdSet = periodGraphHelper.getLeafNodeIdStringSet(periodStringList.get(j));
                resultGraphArray[i][j] = entityLeafNodeIdSet.size() * periodLeafNodeIdSet.size() != cellInt ? 0 : 1;
            }
        }
        return resultGraphArray;
    }

    public static List<EdgePojo> getByResultEdgePojoList(Set<String> columnStringSet, GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, int[][] resultGraphArray) {
        List<String> entityNodeIdList = entityGraphHelper.getNodeIdStringList();
        List periodNodeIdList = periodGraphHelper.getNodeIdStringList().stream().filter(columnStringSet::contains).collect(Collectors.toList());
        LinkedList<EdgePojo> edgePojoList = new LinkedList<EdgePojo>();
        int[][] deepCloneResultGraphArray = NumberUtils.getDeepCloneIntArray(resultGraphArray);
        for (String entityNodeIdString : entityNodeIdList) {
            for (String periodNodeIdString : periodNodeIdList) {
                int resultInt = deepCloneResultGraphArray[entityGraphHelper.getIndexInteger(entityNodeIdString)][periodGraphHelper.getIndexInteger(periodNodeIdString)];
                if (resultInt == 0) continue;
                EdgePojo edgePojo = new EdgePojo().setFromString(entityNodeIdString).setToString(periodNodeIdString);
                edgePojoList.add(edgePojo);
                GraphUtils.getSwitchEnableGraphArray(entityGraphHelper, periodGraphHelper, deepCloneResultGraphArray, false, edgePojo);
            }
        }
        return edgePojoList;
    }

    public static int[][] getSwitchEnableGraphArray(GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, int[][] intArray, boolean enableBoolean, List<EdgePojo> edgePojoList) {
        if (edgePojoList == null || edgePojoList.isEmpty()) {
            return intArray;
        }
        int valueInt = enableBoolean ? 1 : 0;
        List<String> entityNodeIdStringList = entityGraphHelper.getNodeIdStringList();
        List<String> periodNodeIdStringList = periodGraphHelper.getNodeIdStringList();
        for (EdgePojo edgePojo : edgePojoList) {
            if (!entityNodeIdStringList.contains(edgePojo.getFromString()) || !periodNodeIdStringList.contains(edgePojo.getToString())) continue;
            for (String entityString : Graphs.reachableNodes(entityGraphHelper.getGraph(), (Object)edgePojo.getFromString())) {
                for (String periodString : Graphs.reachableNodes(periodGraphHelper.getGraph(), (Object)edgePojo.getToString())) {
                    intArray[entityGraphHelper.getIndexInteger((String)entityString).intValue()][periodGraphHelper.getIndexInteger((String)periodString).intValue()] = valueInt;
                }
            }
        }
        return intArray;
    }

    public static int[][] getSwitchEnableGraphArray(GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, int[][] intArray, boolean enableBoolean, EdgePojo ... edgePojoArray) {
        return GraphUtils.getSwitchEnableGraphArray(entityGraphHelper, periodGraphHelper, intArray, enableBoolean, Arrays.asList(edgePojoArray));
    }

    public static List<NodePojo> getNodePojoList(List<EdgePojo> edgePojoList, String rootNodeIdString) {
        LinkedHashMap<String, List> relationMap = new LinkedHashMap<String, List>(16);
        for (EdgePojo edgePojo : edgePojoList) {
            List relationSuccessorNodeIdStringList = relationMap.computeIfAbsent(edgePojo.getFromString(), k -> new LinkedList());
            if (relationSuccessorNodeIdStringList.contains(edgePojo.getToString())) continue;
            relationSuccessorNodeIdStringList.add(edgePojo.getToString());
        }
        LinkedList<NodePojo> resultNodePojoList = new LinkedList<NodePojo>();
        LinkedList<NodePojo> nodePojoList = new LinkedList<NodePojo>();
        nodePojoList.add(new NodePojo().setNodeIdString(rootNodeIdString).setLevelInteger(0));
        LinkedList<NodePojo> _nodePojoList = new LinkedList<NodePojo>();
        while (true) {
            for (NodePojo nodePojo : nodePojoList) {
                resultNodePojoList.add(nodePojo);
                List successorNodeIdStringList = (List)relationMap.get(nodePojo.getNodeIdString());
                if (successorNodeIdStringList == null || successorNodeIdStringList.isEmpty()) continue;
                ArrayList<NodePojo> childNodePojoList = new ArrayList<NodePojo>(successorNodeIdStringList.size());
                for (String successorNodeIdString : successorNodeIdStringList) {
                    childNodePojoList.add(new NodePojo().setNodeIdString(successorNodeIdString).setLevelInteger(nodePojo.getLevelInteger() + 1).setParentNodePojo(nodePojo));
                }
                nodePojo.setChildNodePojoList(childNodePojoList);
                _nodePojoList.addAll(childNodePojoList);
            }
            if (_nodePojoList.isEmpty()) break;
            nodePojoList.clear();
            nodePojoList.addAll(_nodePojoList);
            _nodePojoList.clear();
        }
        return resultNodePojoList;
    }

    public static List<NodePojo> getNodePojoList(List<EdgePojo> edgePojoList) {
        return GraphUtils.getNodePojoList(edgePojoList, edgePojoList.get(0).getFromString());
    }

    public static Set<String> getLeafNodeIdStringSet(Graph<String> graph, String nodeIdString) {
        HashSet<String> leafNodeIdSet = new HashSet<String>(16);
        LinkedList<String> successorNodeIdStringList = new LinkedList<String>();
        successorNodeIdStringList.add(nodeIdString);
        LinkedList _successorNodeIdStringList = new LinkedList();
        while (true) {
            for (String successorNodeIdString : successorNodeIdStringList) {
                Set successorNodeIdStringSet = graph.successors((Object)successorNodeIdString);
                if (successorNodeIdStringSet.isEmpty()) {
                    leafNodeIdSet.add(successorNodeIdString);
                    continue;
                }
                _successorNodeIdStringList.addAll(successorNodeIdStringSet);
            }
            if (_successorNodeIdStringList.isEmpty()) break;
            successorNodeIdStringList.clear();
            successorNodeIdStringList.addAll(_successorNodeIdStringList);
            _successorNodeIdStringList.clear();
        }
        return leafNodeIdSet;
    }

    public static MutableGraph<String> getGraph(Collection<EdgePojo> edgePojoCollection) {
        MutableGraph graph = GraphBuilder.directed().build();
        for (EdgePojo edgePojo : edgePojoCollection) {
            graph.putEdge((Object)edgePojo.getFromString(), (Object)edgePojo.getToString());
        }
        return graph;
    }
}

