/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.epm.eb.common.utils.base.StrUtils;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final ObjectMapper withoutNullObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String getJsonString(Object object) {
        return JsonUtils.getJsonString(object, false);
    }

    public static String getJsonString(Object object, boolean prettyBoolean, boolean nonNullBoolean) {
        try {
            if (nonNullBoolean) {
                if (prettyBoolean) {
                    return withoutNullObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                }
                return withoutNullObjectMapper.writeValueAsString(object);
            }
            return JsonUtils.getJsonString(object, prettyBoolean);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static String getJsonString(Object object, boolean prettyBoolean) {
        try {
            if (prettyBoolean) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return objectMapper.writeValueAsString(object);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static <T> T readValue(String jsonString, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonString, clazz);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static <T> T readValue(String jsonString, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(jsonString, typeReference);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static <T> T readValue(JsonNode jsonNode, Class<T> clazz) {
        try {
            if (jsonNode == null || jsonNode.isNull() || jsonNode.size() == 0) {
                return null;
            }
            return (T)objectMapper.readValue(jsonNode.toString(), clazz);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static JsonNode readTree(String jsonString) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T> T deepClone(T t) {
        try {
            String jsonString = objectMapper.writeValueAsString(t);
            return (T)objectMapper.readValue(jsonString, t.getClass());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T> T deepClone(T t, TypeReference<T> typeReference) {
        try {
            String jsonString = objectMapper.writeValueAsString(t);
            return (T)objectMapper.readValue(jsonString, typeReference);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static Map<String, Object> getMap(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0 || objectArray.length % 2 != 0) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; i += 2) {
            Object keyObject = objectArray[i];
            if (!(keyObject instanceof String)) {
                throw new RuntimeException(StrUtils.format("The {}th item of the array is not a string.", i + 1));
            }
            map.put((String)keyObject, objectArray[i + 1]);
        }
        return map;
    }

    public static String getMapString(Object ... objectArray) {
        return JsonUtils.getJsonString(JsonUtils.getMap(objectArray));
    }

    public static String getWithoutNullJsonString(Object object) {
        try {
            return withoutNullObjectMapper.writeValueAsString(object);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }
}

