/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.pojo.ComboItemPojo;
import kd.epm.eb.common.pojo.CustomAttributeRelationTypeEnum;
import kd.epm.eb.common.pojo.DynamicAlertException;
import kd.epm.eb.common.pojo.NotificationException;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import kd.epm.eb.common.utils.base.EnumUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.NotificationUtils;
import org.apache.commons.lang3.StringUtils;

public class KdUtils {
    public static final String CLOSE_CALL_BACK_KEY_STRING = "CLOSE_CALL_BACK_KEY_STRING";
    public static final String btnok = "btnok";
    public static final String btncancel = "btncancel";
    public static final String number = "number";
    public static final String name = "name";
    public static final String toolbarap = "toolbarap";
    public static final String billlistap = "billlistap";
    public static final String tabap = "tabap";
    public static final String id_desc = "id desc";
    public static final String root = "root";
    public static final String model = "model";
    public static final String custom_attribute_relation = "custom_attribute_relation";
    public static final String DATA_INTEGRATION_QUERY_LIST = "DATA_INTEGRATION_QUERY_LIST";
    public static final String id = "id";

    public static <T> T dealCustomException(IFormView formView, Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (DynamicAlertException dynamicAlertException) {
            DynamicAlertUtils.openDynamicAlert(formView, dynamicAlertException.getDynamicAlertPojo());
        }
        catch (NotificationException notificationException) {
            NotificationUtils.showNotification(formView, notificationException);
        }
        return null;
    }

    public static <T> String getNumberString(T number, Boolean formatBoolean) {
        return KdUtils.getNumberString(number, formatBoolean, null);
    }

    public static <T> String getNumberString(T number, Boolean formatBoolean, Integer scaleInteger) {
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : ConvertUtils.toDecimal(number);
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        if (scaleInteger != null) {
            bigDecimal = bigDecimal.setScale((int)scaleInteger, RoundingMode.HALF_UP);
        }
        String numberString = bigDecimal.stripTrailingZeros().toPlainString();
        if (!Boolean.TRUE.equals(formatBoolean)) {
            return numberString;
        }
        String[] splitStringArray = numberString.split("\\.");
        String positiveNumberString = new DecimalFormat("#,###").format(bigDecimal.setScale(0, RoundingMode.DOWN));
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 && !positiveNumberString.startsWith("-")) {
            positiveNumberString = "-" + positiveNumberString;
        }
        if (splitStringArray.length == 1) {
            return positiveNumberString;
        }
        return positiveNumberString + "." + splitStringArray[1];
    }

    public static void setComboItems(List<ComboItemPojo> comboItemPojoList, IFormView formView, String comboEditKeyString) {
        ComboEdit comboEdit = (ComboEdit)formView.getControl(comboEditKeyString);
        comboEdit.setComboItems(comboItemPojoList.stream().map(item -> new ComboItem(new LocaleString(item.getNameString()), item.getValueString())).collect(Collectors.toList()));
    }

    public static <T> T getParameterPojo(FormShowParameter formShowParameter, Class<T> clazz) {
        Object contentString = formShowParameter.getCustomParam(clazz.getName());
        return JsonUtils.readValue((String)contentString, clazz);
    }

    public static CustomAttributeRelationTypeEnum getCustomAttributeRelationTypeEnum(Long modelIdLong) {
        String customAttributeRelationTypeString = ParamQueryServiceHelper.getChildString(modelIdLong, ParamEnum.BG024, custom_attribute_relation);
        if (StringUtils.isBlank((CharSequence)customAttributeRelationTypeString)) {
            return CustomAttributeRelationTypeEnum.union;
        }
        CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum = EnumUtils.getEnum(CustomAttributeRelationTypeEnum.class, customAttributeRelationTypeString);
        if (customAttributeRelationTypeEnum == null) {
            return CustomAttributeRelationTypeEnum.union;
        }
        return customAttributeRelationTypeEnum;
    }

    public static boolean getBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return "1".equals(object);
        }
        return false;
    }

    public static <T> void setCustomParam(FormShowParameter formShowParameter, T t) {
        if (formShowParameter == null || t == null) {
            return;
        }
        formShowParameter.setCustomParam(t.getClass().getName(), (Object)JsonUtils.getJsonString(t));
    }
}

