/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.epm.eb.common.pojo.ParamPojo;
import kd.epm.eb.common.pojo.TargetPojo;
import kd.epm.eb.common.utils.base.interfaces.ListPredicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LambdaUtils {
    public static void run(Runnable runnable) {
        LambdaUtils.run(runnable, null, null);
    }

    public static void run(Runnable runnable, Consumer<Throwable> throwableConsumer) {
        LambdaUtils.run(runnable, throwableConsumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Runnable runnable, Consumer<Throwable> throwableConsumer, Consumer<Throwable> finallyConsumer) {
        Throwable finallyThrowable = null;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            finallyThrowable = throwable;
            if (throwableConsumer == null) {
                throw throwable;
            }
            throwableConsumer.accept(throwable);
        }
        finally {
            if (finallyConsumer != null) {
                finallyConsumer.accept(finallyThrowable);
            }
        }
    }

    public static <T> T get(Supplier<T> supplier) {
        return LambdaUtils.get(supplier, null, null);
    }

    public static <T> T get(Supplier<T> supplier, Function<Throwable, T> throwableFunction) {
        return LambdaUtils.get(supplier, throwableFunction, null);
    }

    public static <T> T get(Supplier<T> supplier, BiConsumer<Throwable, T> finallyBiConsumer) {
        return LambdaUtils.get(supplier, null, finallyBiConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(Supplier<T> supplier, Function<Throwable, T> throwableFunction, BiConsumer<Throwable, T> finallyBiConsumer) {
        Throwable finallyThrowable = null;
        Object t = null;
        try {
            Object u = t = (Object)supplier.get();
            return (T)u;
        }
        catch (Throwable throwable) {
            finallyThrowable = throwable;
            if (throwableFunction == null) {
                throw throwable;
            }
            T t2 = throwableFunction.apply(throwable);
            return t2;
        }
        finally {
            if (finallyBiConsumer != null) {
                finallyBiConsumer.accept(finallyThrowable, (Throwable)t);
            }
        }
    }

    public static <T> T doNothing() {
        return null;
    }

    public static <T> T doNothing(T t) {
        return t;
    }

    public static ParamPojo getParamPojo(Object ... objectArray) {
        return new ParamPojo(objectArray);
    }

    public static <T, R> R apply(T t, Function<T, R> function) {
        return function.apply(t);
    }

    public static <T> void accept(T t, Consumer<T> consumer) {
        consumer.accept(t);
    }

    public static <T> Function<T, T> selfFunction() {
        return item -> item;
    }

    public static boolean runWithError(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            return true;
        }
        return false;
    }

    public static <T> T getTarget(List<T> list, Predicate<T> predicate) {
        if (list == null || list.isEmpty() || predicate == null) {
            return null;
        }
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T getTarget(Collection<T> collection, Predicate<T> predicate) {
        if (collection == null || collection.isEmpty() || predicate == null) {
            return null;
        }
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T getTarget(T[] array, Predicate<T> predicate) {
        if (array == null || array.length == 0 || predicate == null) {
            return null;
        }
        for (T t : array) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> Integer getTargetIndexInteger(List<T> list, Predicate<T> predicate) {
        TargetPojo<T> targetPojo = LambdaUtils.getTargetPojo(list, predicate);
        if (targetPojo == null) {
            return null;
        }
        return targetPojo.getIndexInteger();
    }

    public static <T> TargetPojo<T> getTargetPojo(List<T> list, Predicate<T> predicate) {
        if (list == null || list.isEmpty() || predicate == null) {
            return null;
        }
        int listSizeInt = list.size();
        for (int i = 0; i < listSizeInt; ++i) {
            if (!predicate.test(list.get(i))) continue;
            return new TargetPojo<T>().setTarget(list.get(i)).setIndexInteger(i);
        }
        return null;
    }

    public static <T> List<TargetPojo<T>> getTargetPojoList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<TargetPojo<T>> targetPojoList = new ArrayList<TargetPojo<T>>(list.size());
        int listSizeInt = list.size();
        for (int i = 0; i < listSizeInt; ++i) {
            targetPojoList.add(new TargetPojo<T>().setTarget(list.get(i)).setIndexInteger(i));
        }
        return targetPojoList;
    }

    public static <T> List<T> getTargetList(List<T> list, ListPredicate<T> listPredicate) {
        if (list == null || list.isEmpty() || listPredicate == null) {
            return list;
        }
        ArrayList<T> targetList = new ArrayList<T>(list.size());
        int listSizeInt = list.size();
        for (int i = 0; i < listSizeInt; ++i) {
            T t = list.get(i);
            if (!listPredicate.test(i, t)) continue;
            targetList.add(t);
        }
        return targetList;
    }

    public static <T, R> R ifPresent(T t, Function<T, R> presentFunction, Function<T, R> notPresentFunction) {
        if (t != null) {
            return presentFunction.apply(t);
        }
        if (notPresentFunction == null) {
            return null;
        }
        return notPresentFunction.apply(null);
    }

    public static <T, R> R ifPresent(T t, Function<T, R> presentFunction) {
        return LambdaUtils.ifPresent(t, presentFunction, null);
    }

    public static <T> List<T> getList(Integer sizeInteger, Function<Integer, T> function) {
        if (sizeInteger == null || sizeInteger < 1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(sizeInteger);
        for (int i = 0; i < sizeInteger; ++i) {
            list.add(function.apply(i));
        }
        return list;
    }

    public static <T> Pair<List<T>, List<T>> getMatchedAndNotMatchedListPair(Collection<T> collection, Predicate<T> predicate) {
        if (collection == null || collection.isEmpty() || predicate == null) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        LinkedList<T> matchedList = new LinkedList<T>();
        LinkedList<T> notMatchedList = new LinkedList<T>();
        for (T t : collection) {
            if (predicate.test(t)) {
                matchedList.add(t);
                continue;
            }
            notMatchedList.add(t);
        }
        return Pair.of(matchedList, notMatchedList);
    }

    public static <T, K, V> Collector<T, ?, LinkedHashMap<K, V>> toLinkedHashMap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, LambdaUtils.throwingMerger(), LinkedHashMap::new);
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (k1, k2) -> {
            throw new IllegalStateException("Duplicate key " + k1);
        };
    }

    public static <T> void forEach(Collection<T> collection, BiConsumer<Integer, T> consumer) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        int i = 0;
        for (T t : collection) {
            consumer.accept(i, (Integer)t);
            ++i;
        }
    }

    public static <T> Predicate<T> distinct(Function<? super T, Object> distinctFunction) {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(16);
        return object -> concurrentHashMap.putIfAbsent(distinctFunction.apply(object), Boolean.TRUE) == null;
    }
}

