/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class LanguageUtils {
    private static final Log log = LogFactory.getLog(LanguageUtils.class);

    public static String getLocalString(@NotNull DynamicObject object, @NotNull String propName) {
        Object value = object.get(propName);
        if (value instanceof ILocaleString) {
            return ((ILocaleString)value).getLocaleValue();
        }
        return "";
    }

    public static Lang getLang(Lang defaultLang) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            log.info("Could not get lang from request context, default lang:" + defaultLang);
            return defaultLang;
        }
        Lang lang = requestContext.getLang();
        if (lang == null) {
            log.info("Could not get lang from request context, default lang:" + defaultLang);
            return defaultLang;
        }
        return lang;
    }

    public static String getLocaleValue(Object locale) {
        if (locale instanceof ILocaleString) {
            return LanguageUtils.getLocaleValue((ILocaleString)locale);
        }
        return null;
    }

    public static String getLocaleValue(ILocaleString localeString) {
        if (localeString != null) {
            return localeString.getLocaleValue();
        }
        return null;
    }

    public static LocaleString getLocaleValue(String value, String resourceKey, String systemType) {
        LocaleString ls = new LocaleString();
        ls.put(Lang.zh_CN.name(), (Object)PromptWordCacheNew.getPromptWord((String)value, (String)resourceKey, (Lang)Lang.zh_CN, (String)systemType, (Object[])new Object[0]));
        ls.put(Lang.en_US.name(), (Object)PromptWordCacheNew.getPromptWord((String)value, (String)resourceKey, (Lang)Lang.en_US, (String)systemType, (Object[])new Object[0]));
        ls.put(Lang.zh_TW.name(), (Object)PromptWordCacheNew.getPromptWord((String)value, (String)resourceKey, (Lang)Lang.zh_TW, (String)systemType, (Object[])new Object[0]));
        return ls;
    }
}

