/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.MutexPojo;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.cache.Cache;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LockUtils {
    private static final Log log = LogFactory.getLog(LockUtils.class);
    public static final long MAX_TRY_LOCK_TIME_LONG = 30000L;
    public static final String PREFIX_STRING = LockUtils.class.getName();
    public static final int MAX_MUTEX_TIME_INT = 2;
    public static final TimeUnit MAX_MUTEX_TIME_UNIT = TimeUnit.HOURS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockWithTxHandle(String keyString, Supplier<T> supplier, Consumer<Boolean> finallyConsumer) {
        boolean notRollbackBackBoolean = false;
        try {
            Object t = LockUtils.lock(keyString, () -> DbUtils.txHandle(supplier));
            notRollbackBackBoolean = true;
            Object object = t;
            return (T)object;
        }
        finally {
            if (finallyConsumer != null) {
                finallyConsumer.accept(notRollbackBackBoolean);
            }
        }
    }

    public static <T> T lockWithTxHandle(String keyString, Supplier<T> supplier) {
        return LockUtils.lockWithTxHandle(keyString, supplier, null);
    }

    public static void lockWithTxHandle(String keyString, Runnable runnable) {
        LockUtils.lockWithTxHandle(keyString, () -> {
            runnable.run();
            return null;
        });
    }

    public static void forceUnlock(String keyString) {
        DLock.forceUnlock((String[])new String[]{PREFIX_STRING + keyString});
    }

    public static List<MutexPojo> setMutexList(List<MutexPojo> mutexPojoList) {
        if (CollectionUtils.isEmpty(mutexPojoList)) {
            return null;
        }
        for (MutexPojo mutexPojo : mutexPojoList) {
            Cache.get().set(mutexPojo.getKeyString(), JsonUtils.getJsonString(mutexPojo), 2, MAX_MUTEX_TIME_UNIT);
        }
        return mutexPojoList;
    }

    public static List<MutexPojo> getMutexList(List<String> keyStringList) {
        if (CollectionUtils.isEmpty(keyStringList)) {
            return null;
        }
        return keyStringList.stream().map(item -> {
            String valueString = Cache.get().get((String)item);
            if (StringUtils.isBlank((CharSequence)valueString)) {
                return null;
            }
            return JsonUtils.readValue(valueString, MutexPojo.class);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void removeMutexPojoList(String lockKeyString, List<String> keyStringList) {
        if (CollectionUtils.isEmpty(keyStringList)) {
            return;
        }
        LockUtils.lock(lockKeyString, () -> keyStringList.forEach(item -> Cache.get().remove((String)item)));
    }

    public static <T> List<String> getPrefixKeyStringList(String prefixKeyString, List<T> keyStringList) {
        return keyStringList.stream().map(item -> LockUtils.getPrefixKeyString(prefixKeyString, item)).collect(Collectors.toList());
    }

    public static <T> String getPrefixKeyString(String prefixKeyString, T key) {
        return PREFIX_STRING + "_" + prefixKeyString + "_" + ObjUtils.getString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lock(String keyString, Long maxWaitTimeLong, Supplier<T> supplier) {
        DLock lock = DLock.create((String)(PREFIX_STRING + keyString));
        lock.fastMode();
        boolean isLock = false;
        try {
            if (maxWaitTimeLong == null || maxWaitTimeLong <= 0L) {
                maxWaitTimeLong = 30000L;
            }
            if (!lock.tryLock(maxWaitTimeLong.longValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"MutexUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            isLock = true;
            T t = supplier.get();
            return t;
        }
        finally {
            if (isLock) {
                lock.unlock();
            }
        }
    }

    public static <T> T lock(String keyString, Supplier<T> supplier) {
        return LockUtils.lock(keyString, null, supplier);
    }

    public static void lock(String keyString, Runnable runnable) {
        LockUtils.lock(keyString, null, () -> {
            runnable.run();
            return null;
        });
    }
}

