/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.math.NumberUtils;

public class ObjUtils {
    public static Long getLong(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        String objectString = null;
        if (object instanceof Number) {
            objectString = object.toString();
        } else if (object instanceof String) {
            objectString = (String)object;
        }
        if (!NumberUtils.isCreatable((String)objectString)) {
            return null;
        }
        return Long.valueOf(objectString);
    }

    public static String getString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static <T> T deepClone(T t) {
        Object object;
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(t);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable2) {
                ObjUtils.close(objectInputStream, byteArrayInputStream, objectOutputStream, byteArrayOutputStream);
                throw throwable2;
            }
        }
        ObjUtils.close(objectInputStream, byteArrayInputStream, objectOutputStream, byteArrayOutputStream);
        return (T)object;
    }

    public static void close(AutoCloseable ... autoCloseableArray) {
        if (autoCloseableArray == null || autoCloseableArray.length == 0) {
            return;
        }
        for (AutoCloseable autoCloseable : autoCloseableArray) {
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isString(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (Object object : objectArray) {
            if (object instanceof String) continue;
            return false;
        }
        return true;
    }

    public static Object[] getObjectArray(Object ... objectArray) {
        return objectArray;
    }

    public static boolean notNullOrZero(Long ... longArray) {
        if (longArray == null || longArray.length == 0) {
            return false;
        }
        for (Long numberLong : longArray) {
            if (numberLong != null && numberLong != 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean nullOrZero(Long ... longArray) {
        return !ObjUtils.notNullOrZero(longArray);
    }

    public static boolean notNull(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    public static String[] getStringArray(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ObjUtils.getString(objectArray[i]);
        }
        return stringArray;
    }
}

