/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OlapUtils {
    private static final Log log = LogFactory.getLog(OlapUtils.class);
    public static final String FMONEY = "FMONEY";

    public static Dataset getDatasetByAccountMember(Long modelIdLong, String accountMemberNumberString) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelIdLong);
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemberNumberString);
        return OlapUtils.getDatasetByAccountMember(accountMember.getId());
    }

    public static Dataset getDatasetByAccountMember(Long accountMemberIdLong) {
        DatasetServiceHelper datasetServiceHelper = DatasetServiceHelper.getInstance();
        Long dateSetIdLong = datasetServiceHelper.queryDatasetByAccountId(accountMemberIdLong);
        return datasetServiceHelper.getDataSet(dateSetIdLong);
    }

    public static String getNumberString(Object numberObject) {
        if (numberObject == null) {
            return null;
        }
        String string = ObjUtils.getString(numberObject);
        if (StringUtils.isBlank((CharSequence)string)) {
            return string;
        }
        return new BigDecimal(string).stripTrailingZeros().toPlainString();
    }

    public static Map<String, Long> getViewMap(Long modelIdLong, Map<String, String> dimensionAndMemberNumberMap) {
        return OlapUtils.getViewMap(modelIdLong, dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber()));
    }

    public static Map<String, Long> getViewMap(Long modelIdLong, String accountMemberNumberString) {
        if (StringUtils.isBlank((CharSequence)accountMemberNumberString)) {
            return Collections.emptyMap();
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelIdLong);
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemberNumberString);
        if (accountMember == null) {
            log.info("Could not find account member by: " + accountMemberNumberString);
            return Collections.emptyMap();
        }
        return modelCacheHelper.getViewsByDataSet(accountMember.getDatasetId());
    }

    public static Member getMember(Long modelIdLong, String dimensionNumberString, Map<String, Long> viewMap, String memberNumberString) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelIdLong);
        Long viewIdLong = LambdaUtils.get(() -> {
            if (MapUtils.isEmpty((Map)viewMap)) {
                return null;
            }
            return (Long)viewMap.get(dimensionNumberString);
        });
        return modelCacheHelper.getMember(dimensionNumberString, viewIdLong, memberNumberString);
    }

    public static Member getMember(IModelCacheHelper modelCacheHelper, String dimensionNumberString, Map<String, Long> viewMap, String memberNumberString) {
        if (MapUtils.isEmpty(viewMap)) {
            return modelCacheHelper.getMember(dimensionNumberString, null, memberNumberString);
        }
        return modelCacheHelper.getMember(dimensionNumberString, viewMap.get(dimensionNumberString), memberNumberString);
    }

    public static Member getAccountMember(IModelCacheHelper modelCacheHelper, Map<String, String> dimensionAndMemberNumberMap) {
        return modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber()));
    }
}

