/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmColumnAnnotation;
import kd.epm.eb.common.utils.base.OrmTableAnnotation;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.base.ThreadUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class OrmBuilder<T> {
    public static final String select = "select";
    public static final String update = "update";
    public static final String delete = "delete";
    public static final String from = "from";
    public static final String where = "where";
    public static final String in = "in";
    public static final String and = "and";
    public static final String or = "or";
    public static final String equal = "=";
    private static final String SPACE = " ";
    private static final String not = "not";
    public static final String set = "set";
    public static final String QUESTION_MARK_STRING = "?";
    public static final String COMMA_STRING = ",";
    public static Long ZERO_LONG = 0L;
    public static Long ONE_LONG = 1L;
    private DBRoute dbRoute;
    private Class<T> clazz;
    private String[] fieldNameStringArray;
    private String whereSqlString = "";
    private String setSqlString;
    private final List<Object> paramObjectList = new ArrayList<Object>(16);

    private OrmBuilder() {
    }

    public static <T> OrmBuilder<T> clazz(Class<T> clazz, DBRoute dbRoute) {
        OrmBuilder<T> ormBuilder = new OrmBuilder<T>();
        ormBuilder.clazz = clazz;
        if (dbRoute == null) {
            dbRoute = DbUtils.EPM_DBROUTE;
        }
        ormBuilder.dbRoute = dbRoute;
        return ormBuilder;
    }

    public static <T> OrmBuilder<T> clazz(Class<T> clazz) {
        return OrmBuilder.clazz(clazz, null);
    }

    public OrmBuilder<T> field(String ... fieldNameStringArray) {
        this.fieldNameStringArray = fieldNameStringArray;
        return this;
    }

    public OrmBuilder<T> fieldOne(String fieldNameString) {
        if (this.fieldNameStringArray == null) {
            this.fieldNameStringArray = new String[]{fieldNameString};
        } else {
            this.fieldNameStringArray = Arrays.copyOf(this.fieldNameStringArray, this.fieldNameStringArray.length + 1);
            this.fieldNameStringArray[this.fieldNameStringArray.length - 1] = fieldNameString;
        }
        return this;
    }

    public OrmBuilder<T> fieldAll() {
        this.fieldNameStringArray = (String[])FieldUtils.getFieldsListWithAnnotation(this.clazz, OrmColumnAnnotation.class).stream().map(item -> item.getAnnotation(OrmColumnAnnotation.class).value()).toArray(String[]::new);
        return this;
    }

    public OrmBuilder<T> fieldAllExclude(String ... excludeFieldNameStringArray) {
        List<String> fieldNameStringList = FieldUtils.getFieldsListWithAnnotation(this.clazz, OrmColumnAnnotation.class).stream().map(item -> item.getAnnotation(OrmColumnAnnotation.class).value()).collect(Collectors.toList());
        if (ArrayUtils.isNotEmpty((Object[])excludeFieldNameStringArray)) {
            List<String> excludeFieldNameStringList = Arrays.asList(excludeFieldNameStringArray);
            fieldNameStringList = fieldNameStringList.stream().filter(item -> !excludeFieldNameStringList.contains(item)).collect(Collectors.toList());
        }
        this.fieldNameStringArray = fieldNameStringList.toArray(new String[0]);
        return this;
    }

    public OrmBuilder<T> where(String whereSqlString) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + whereSqlString;
        return this;
    }

    public OrmBuilder<T> where(String templateString, Object ... argObjectArray) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + StrUtils.format(templateString, argObjectArray);
        return this;
    }

    public OrmBuilder<T> whereAppend(String ... appendStringArray) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + SPACE + String.join((CharSequence)SPACE, appendStringArray);
        return this;
    }

    public <I> OrmBuilder<T> whereEqual(String fieldNameString, I input) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + fieldNameString + " = ?";
        this.paramObjectList.add(input);
        return this;
    }

    public <I> OrmBuilder<T> whereNotEqual(String fieldNameString, I input) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + fieldNameString + " != ?";
        this.paramObjectList.add(input);
        return this;
    }

    public <I> OrmBuilder<T> orEqual(String fieldNameString, I input) {
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + " or " + fieldNameString + " = ?";
        this.paramObjectList.add(input);
        return this;
    }

    public <I> OrmBuilder<T> whereIn(String fieldNameString, Collection<I> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return this;
        }
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + fieldNameString + SPACE + in + SPACE + OrmBuilder.inValuePlaceholderString(collection.size());
        this.paramObjectList.addAll(collection);
        return this;
    }

    public <I> OrmBuilder<T> whereNotIn(String fieldNameString, Collection<I> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return this;
        }
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            this.whereSqlString = this.whereSqlString + " and ";
        }
        this.whereSqlString = this.whereSqlString + fieldNameString + SPACE + not + SPACE + in + SPACE + OrmBuilder.inValuePlaceholderString(collection.size());
        this.paramObjectList.addAll(collection);
        return this;
    }

    public static String inValuePlaceholderString(int sizeInt) {
        return "(" + String.join((CharSequence)COMMA_STRING, LambdaUtils.getList(sizeInt, indexInteger -> QUESTION_MARK_STRING)) + ")";
    }

    public OrmBuilder<T> param(Object[] paramObjectArray) {
        this.paramObjectList.addAll(Arrays.stream(paramObjectArray).collect(Collectors.toList()));
        return this;
    }

    public <I> OrmBuilder<T> param(List<I> paramObjectList) {
        this.paramObjectList.addAll(paramObjectList);
        return this;
    }

    public OrmBuilder<T> paramNumber(Number ... numberObjectArray) {
        this.paramObjectList.addAll(Arrays.stream(numberObjectArray).collect(Collectors.toList()));
        return this;
    }

    public OrmBuilder<T> setSqlString(String setSqlString) {
        this.setSqlString = setSqlString;
        return this;
    }

    public OrmBuilder<T> setColumnString(List<String> setColumnStringList) {
        this.setSqlString = setColumnStringList.stream().map(item -> item + " = ?").collect(Collectors.joining(COMMA_STRING));
        return this;
    }

    public OrmBuilder<T> setColumnString(String ... setColumnStringArray) {
        return this.setColumnString(Arrays.asList(setColumnStringArray));
    }

    private String getSelectSqlString() {
        StringBuilder stringBuilder = new StringBuilder(select);
        stringBuilder.append(SPACE);
        stringBuilder.append(String.join((CharSequence)COMMA_STRING, this.fieldNameStringArray));
        stringBuilder.append(SPACE);
        stringBuilder.append(from);
        stringBuilder.append(SPACE);
        stringBuilder.append(this.clazz.getAnnotation(OrmTableAnnotation.class).value());
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            stringBuilder.append(SPACE);
            stringBuilder.append(where);
            stringBuilder.append(SPACE);
            stringBuilder.append(this.whereSqlString);
        }
        return stringBuilder.toString();
    }

    public T getTarget() {
        List<T> list = this.toRowList();
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() != 1) {
            throw new IllegalArgumentException("More than one result.");
        }
        return list.get(0);
    }

    public List<T> toRowList() {
        return DbUtils.getRowMapList(this.clazz, ThreadUtils.getAlgoKeyString(3), this.dbRoute, this.getSelectSqlString(), this.paramObjectList.toArray());
    }

    public Map<String, T> toStringRowMap(String columnNameString) {
        List<Map<String, Object>> rowMapList = DbUtils.getRowMapList(ThreadUtils.getAlgoKeyString(3), this.dbRoute, this.getSelectSqlString(), this.paramObjectList.toArray());
        Map<String, Field> fieldMap = FieldUtils.getFieldsListWithAnnotation(this.clazz, OrmColumnAnnotation.class).stream().collect(Collectors.toMap(item -> item.getAnnotation(OrmColumnAnnotation.class).value(), item -> item));
        return rowMapList.stream().collect(LambdaUtils.toLinkedHashMap(item -> ObjUtils.getString(item.get(columnNameString)), item -> DbUtils.getInstance(this.clazz, item, fieldMap)));
    }

    public Map<Long, T> toLongRowMap(String columnNameString) {
        List<Map<String, Object>> rowMapList = DbUtils.getRowMapList(ThreadUtils.getAlgoKeyString(3), this.dbRoute, this.getSelectSqlString(), this.paramObjectList.toArray());
        Map<String, Field> fieldMap = FieldUtils.getFieldsListWithAnnotation(this.clazz, OrmColumnAnnotation.class).stream().collect(Collectors.toMap(item -> item.getAnnotation(OrmColumnAnnotation.class).value(), item -> item));
        return rowMapList.stream().collect(LambdaUtils.toLinkedHashMap(item -> ObjUtils.getLong(item.get(columnNameString)), item -> DbUtils.getInstance(this.clazz, item, fieldMap)));
    }

    private String getUpdateSqlString() {
        StringBuilder stringBuilder = new StringBuilder(update);
        stringBuilder.append(SPACE);
        stringBuilder.append(this.clazz.getAnnotation(OrmTableAnnotation.class).value());
        stringBuilder.append(SPACE);
        stringBuilder.append(set);
        stringBuilder.append(SPACE);
        if (StringUtils.isNotBlank((CharSequence)this.setSqlString)) {
            stringBuilder.append(this.setSqlString);
        } else {
            stringBuilder.append(Arrays.stream(this.fieldNameStringArray).map(item -> item + " = ?").collect(Collectors.joining(COMMA_STRING)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            stringBuilder.append(SPACE);
            stringBuilder.append(where);
            stringBuilder.append(SPACE);
            stringBuilder.append(this.whereSqlString);
        }
        return stringBuilder.toString();
    }

    public void update() {
        DB.execute((DBRoute)DbUtils.EPM_DBROUTE, (String)this.getUpdateSqlString(), (Object[])this.paramObjectList.toArray());
    }

    private String getDeleteSqlString() {
        StringBuilder stringBuilder = new StringBuilder(delete);
        stringBuilder.append(SPACE);
        stringBuilder.append(from);
        stringBuilder.append(SPACE);
        stringBuilder.append(this.clazz.getAnnotation(OrmTableAnnotation.class).value());
        stringBuilder.append(SPACE);
        if (StringUtils.isNotBlank((CharSequence)this.whereSqlString)) {
            stringBuilder.append(SPACE);
            stringBuilder.append(where);
            stringBuilder.append(SPACE);
            stringBuilder.append(this.whereSqlString);
        }
        return stringBuilder.toString();
    }

    public void delete() {
        DB.execute((DBRoute)DbUtils.EPM_DBROUTE, (String)this.getDeleteSqlString(), (Object[])this.paramObjectList.toArray());
    }
}

