/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.base.AssertException;
import kd.epm.eb.common.utils.base.ObjUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class StrUtils {
    public static char BACKSLASH_CHAR = (char)92;
    public static char DELIM_START_CHAR = (char)123;
    public static final String EMPTY_JSON_STRING = "{}";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";

    public static String getSimpleUuidIdString() {
        return UUID.randomUUID().toString().replaceAll("-", EMPTY_STRING);
    }

    public static String getUuidIdWithDataString() {
        return DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS").format(LocalDateTime.now()) + "_" + StrUtils.getSimpleUuidIdString();
    }

    public static String getDataString() {
        return DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS").format(LocalDateTime.now());
    }

    public static String getGlobalLongIdString() {
        return EMPTY_STRING + GlobalIdUtil.genGlobalLongId();
    }

    public static String format(String patternString, Object ... argObjectArray) {
        if (patternString == null || patternString.isEmpty() || argObjectArray == null || argObjectArray.length == 0) {
            return patternString;
        }
        int patternStringLengthInt = patternString.length();
        StringBuilder stringBuilder = new StringBuilder(patternStringLengthInt + 60);
        int handledPositionInt = 0;
        for (int argIndexInt = 0; argIndexInt < argObjectArray.length; ++argIndexInt) {
            int delimIndexInt = patternString.indexOf(EMPTY_JSON_STRING, handledPositionInt);
            if (delimIndexInt == -1) {
                if (handledPositionInt == 0) {
                    return patternString;
                }
                stringBuilder.append(patternString, handledPositionInt, patternStringLengthInt);
                return stringBuilder.toString();
            }
            if (delimIndexInt > 0 && patternString.charAt(delimIndexInt - 1) == BACKSLASH_CHAR) {
                if (delimIndexInt > 1 && patternString.charAt(delimIndexInt - 2) == BACKSLASH_CHAR) {
                    stringBuilder.append(patternString, handledPositionInt, delimIndexInt - 1);
                    stringBuilder.append(StrUtils.convertToString(argObjectArray[argIndexInt]));
                    handledPositionInt = delimIndexInt + 2;
                    continue;
                }
                --argIndexInt;
                stringBuilder.append(patternString, handledPositionInt, delimIndexInt - 1);
                stringBuilder.append(DELIM_START_CHAR);
                handledPositionInt = delimIndexInt + 1;
                continue;
            }
            stringBuilder.append(patternString, handledPositionInt, delimIndexInt);
            stringBuilder.append(StrUtils.convertToString(argObjectArray[argIndexInt]));
            handledPositionInt = delimIndexInt + 2;
        }
        stringBuilder.append(patternString, handledPositionInt, patternString.length());
        return stringBuilder.toString();
    }

    private static String convertToString(Object object) {
        if (null == object) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static Map<Integer, String> getIndexStringMap(String contentString, Set<String> keyStringSet) {
        TreeMap<Integer, String> indexMap = new TreeMap<Integer, String>();
        for (String keyString : keyStringSet) {
            List<Integer> indexOfIntegerList = StrUtils.indexOfIntegerList(contentString, keyString);
            if (CollectionUtils.isEmpty(indexOfIntegerList)) continue;
            for (Integer indexOfInteger : indexOfIntegerList) {
                indexMap.put(indexOfInteger, keyString);
            }
        }
        return indexMap;
    }

    public static List<Integer> indexOfIntegerList(String contentString, String keyString) {
        ArrayList<Integer> indexOfIntegerList = new ArrayList<Integer>(10);
        int indexInt = 0;
        while (indexInt >= 0) {
            if ((indexInt = contentString.indexOf(keyString, indexInt)) < 0) continue;
            indexOfIntegerList.add(indexInt);
            indexInt += keyString.length();
        }
        return indexOfIntegerList;
    }

    public static String getDbcString(String string) {
        if (string == null) {
            return null;
        }
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '\u3000') {
                charArray[i] = 32;
                continue;
            }
            if (charArray[i] <= '\uff00' || charArray[i] >= '\uff5f') continue;
            charArray[i] = (char)(charArray[i] - 65248);
        }
        return new String(charArray);
    }

    public static String getBase64EncodeString(String unEncodeString) {
        return new String(Base64.getUrlEncoder().encode(unEncodeString.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String getBase64unEncodeString(String base64EncodeString) {
        return new String(Base64.getUrlDecoder().decode(base64EncodeString), StandardCharsets.UTF_8);
    }

    public static String append(Object ... objectArray) {
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return null;
        }
        return Arrays.stream(objectArray).map(item -> StrUtils.convertToString(item)).collect(Collectors.joining());
    }

    public static <T> String join(String delimiterString, Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        return collection.stream().map(ObjUtils::getString).collect(Collectors.joining(delimiterString));
    }

    public static String getTargetLengthString(String string, int targetLengthInt) {
        int lengthInt = string.length();
        if (lengthInt == targetLengthInt) {
            return string;
        }
        if (lengthInt > targetLengthInt) {
            throw new AssertException("The length of '{}' is greater than {}.", string, targetLengthInt);
        }
        return StrUtils.repeatAndJoin(SPACE, targetLengthInt - lengthInt) + string;
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        boolean isAppendDelimiter;
        if (count <= 0) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder(str.length() * count);
        builder.append(str);
        --count;
        boolean bl = isAppendDelimiter = delimiter != null;
        while (count-- > 0) {
            if (isAppendDelimiter) {
                builder.append(delimiter);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static String repeatAndJoin(CharSequence str, int count) {
        return StrUtils.repeatAndJoin(str, count, null);
    }
}

