/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

public class ThreadUtils {
    protected static final String CLASS_NAME = ThreadUtils.class.getName();

    public static String getAlgoKeyString(int indexInt) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[indexInt];
        return ThreadUtils.getStackTraceElementString(stackTraceElement);
    }

    public static String getPluginAlgoKeyString() {
        return ThreadUtils.getAlgoKeyString(3);
    }

    public static StackTraceElement getStackTraceElement(String classNameString) {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(classNameString)) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getExcludedStackTraceElement(String classNameString) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement;
            if (i == 0 || (stackTraceElement = stackTraceElementArray[i]).getClassName().equals(CLASS_NAME) || stackTraceElement.getClassName().equals(classNameString)) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static String getStackTraceElementString(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return "";
        }
        return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getLineNumber() + ")";
    }

    public static String getStackTraceElementString(String classNameString) {
        return ThreadUtils.getStackTraceElementString(ThreadUtils.getStackTraceElement(classNameString));
    }

    public static String getExcludedStackTraceElementString(String classNameString) {
        return ThreadUtils.getStackTraceElementString(ThreadUtils.getExcludedStackTraceElement(classNameString));
    }
}

