/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.pojo.CellRangeAddressPojo;
import kd.epm.eb.common.pojo.CellRangePojo;
import kd.epm.eb.common.pojo.ExcelCellPojo;
import kd.epm.eb.common.pojo.ExcelRowPojo;
import kd.epm.eb.common.pojo.ExcelStylePojo;
import kd.epm.eb.common.pojo.SheetPojo;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.base.CollUtils;
import kd.epm.eb.common.utils.base.EnumUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtils {
    public static final String Sheet1 = "Sheet1";
    public static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String COLUMN_WIDTH = "COLUMN_WIDTH";
    public static final String ROW_HEIGHT = "ROW_HEIGHT";

    public static XSSFWorkbook getXssfWorkbook(Map<String, String> headerMap, List<Map<String, String>> rowMapList) {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        XSSFSheet xssfSheet = xssfWorkbook.createSheet(Sheet1);
        int headerSizeInt = headerMap.size();
        List<Map.Entry<String, String>> headerMapEntryList = CollUtils.getMapEntryList(headerMap);
        LambdaUtils.run(() -> {
            XSSFRow xssfRow = xssfSheet.createRow(0);
            for (int i = 0; i < headerSizeInt; ++i) {
                XSSFCell xssfCell = xssfRow.createCell(i);
                xssfCell.setCellValue(ObjUtils.getString(((Map.Entry)headerMapEntryList.get(i)).getValue()));
            }
        });
        LambdaUtils.run(() -> {
            if (CollectionUtils.isEmpty((Collection)rowMapList)) {
                return;
            }
            for (int i = 0; i < rowMapList.size(); ++i) {
                Map rowMap = (Map)rowMapList.get(i);
                XSSFRow xssfRow = xssfSheet.createRow(i + 1);
                for (int j = 0; j < headerSizeInt; ++j) {
                    XSSFCell xssfCell = xssfRow.createCell(j);
                    String keyString = (String)((Map.Entry)headerMapEntryList.get(j)).getKey();
                    String valueString = (String)rowMap.get(keyString);
                    if (StringUtils.isBlank((CharSequence)valueString)) continue;
                    xssfCell.setCellValue(valueString);
                }
            }
        });
        return xssfWorkbook;
    }

    public static XSSFCellStyle getXssfCellStyle(XSSFWorkbook xssfWorkbook, ExcelStylePojo excelStylePojo) {
        BorderStyle bottomBorderStyle;
        BorderStyle topBorderStyle;
        BorderStyle rightBorderStyle;
        BorderStyle leftBorderStyle;
        VerticalAlignment verticalAlignment;
        HorizontalAlignment horizontalAlignment;
        if (excelStylePojo == null) {
            return null;
        }
        XSSFCellStyle xssfCellStyle = xssfWorkbook.createCellStyle();
        if (Boolean.TRUE.equals(excelStylePojo.getWrapTextBoolean())) {
            xssfCellStyle.setWrapText(true);
        }
        if ((horizontalAlignment = EnumUtils.getEnum(HorizontalAlignment.class, excelStylePojo.getHorizontalAlignment())) != null) {
            xssfCellStyle.setAlignment(horizontalAlignment);
        }
        if ((verticalAlignment = EnumUtils.getEnum(VerticalAlignment.class, excelStylePojo.getVerticalAlignment())) != null) {
            xssfCellStyle.setVerticalAlignment(verticalAlignment);
        }
        if ((leftBorderStyle = EnumUtils.getEnum(BorderStyle.class, excelStylePojo.getBorderLeftString())) != null) {
            xssfCellStyle.setBorderLeft(leftBorderStyle);
        }
        if ((rightBorderStyle = EnumUtils.getEnum(BorderStyle.class, excelStylePojo.getBorderRightString())) != null) {
            xssfCellStyle.setBorderRight(rightBorderStyle);
        }
        if ((topBorderStyle = EnumUtils.getEnum(BorderStyle.class, excelStylePojo.getBorderTopString())) != null) {
            xssfCellStyle.setBorderTop(topBorderStyle);
        }
        if ((bottomBorderStyle = EnumUtils.getEnum(BorderStyle.class, excelStylePojo.getBorderBottomString())) != null) {
            xssfCellStyle.setBorderBottom(bottomBorderStyle);
        }
        return xssfCellStyle;
    }

    public static XSSFWorkbook getXssfWorkbook(SheetPojo sheetPojo) {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        XSSFSheet xssfSheet = xssfWorkbook.createSheet(Sheet1);
        Map<Integer, ExcelRowPojo> excelRowPojoMap = sheetPojo.getExcelRowPojoList().stream().collect(Collectors.toMap(item -> item.getRowInteger(), item -> item));
        for (int i = 0; i < sheetPojo.getMaxRowInteger(); ++i) {
            List<ExcelCellPojo> excelCellPojoList;
            XSSFRow xssfRow = xssfSheet.createRow(i);
            ExcelRowPojo excelRowPojo = excelRowPojoMap.get(i);
            if (excelRowPojo == null || CollectionUtils.isEmpty(excelCellPojoList = excelRowPojo.getExcelCellPojoList())) continue;
            Map<Integer, ExcelCellPojo> excelCellPojoMap = excelCellPojoList.stream().collect(Collectors.toMap(item -> item.getColInteger(), item -> item));
            for (int j = 0; j < sheetPojo.getMaxColInteger(); ++j) {
                XSSFCell xssfCell = xssfRow.createCell(j);
                xssfCell.setCellType(CellType.STRING);
                ExcelCellPojo excelCellPojo = excelCellPojoMap.get(j);
                if (excelCellPojo == null) continue;
                if (excelCellPojo.getExcelStylePojo() != null) {
                    xssfCell.setCellStyle((CellStyle)WorkbookUtils.getXssfCellStyle(xssfWorkbook, excelCellPojo.getExcelStylePojo()));
                }
                if (StringUtils.isBlank((CharSequence)excelCellPojo.getValueString())) continue;
                xssfCell.setCellValue(excelCellPojo.getValueString());
            }
        }
        LambdaUtils.run(() -> {
            List<CellRangeAddressPojo> cellRangeAddressPojoList = sheetPojo.getCellRangeAddressPojoList();
            if (CollectionUtils.isEmpty(cellRangeAddressPojoList)) {
                return;
            }
            for (CellRangeAddressPojo cellRangeAddressPojo : cellRangeAddressPojoList) {
                if (cellRangeAddressPojo.getExcelStylePojo() != null) {
                    for (int i = cellRangeAddressPojo.getFirstRowInteger().intValue(); i <= cellRangeAddressPojo.getLastRowInteger(); ++i) {
                        for (int j = cellRangeAddressPojo.getFirstColInteger().intValue(); j <= cellRangeAddressPojo.getLastColInteger(); ++j) {
                            XSSFCell xssfCell = xssfSheet.getRow(i).getCell(j);
                            if (xssfCell == null) continue;
                            xssfCell.setCellStyle((CellStyle)WorkbookUtils.getXssfCellStyle(xssfWorkbook, cellRangeAddressPojo.getExcelStylePojo()));
                        }
                    }
                }
                xssfSheet.addMergedRegion(new CellRangeAddress(cellRangeAddressPojo.getFirstRowInteger().intValue(), cellRangeAddressPojo.getLastRowInteger().intValue(), cellRangeAddressPojo.getFirstColInteger().intValue(), cellRangeAddressPojo.getLastColInteger().intValue()));
            }
        });
        LambdaUtils.run(() -> {
            List<CellRangePojo> cellRangePojoList = sheetPojo.getCellRangePojoList();
            if (CollectionUtils.isEmpty(cellRangePojoList)) {
                return;
            }
            Map<String, List<CellRangePojo>> cellRangPojoListMap = cellRangePojoList.stream().collect(Collectors.groupingBy(item -> item.getTypeString()));
            LambdaUtils.run(() -> {
                List groupCellRangePojoList = (List)cellRangPojoListMap.get(BACKGROUND_COLOR);
                if (CollectionUtils.isEmpty((Collection)groupCellRangePojoList)) {
                    return;
                }
                for (CellRangePojo cellRangePojo : groupCellRangePojoList) {
                    for (int i = cellRangePojo.getFirstRowInteger().intValue(); i <= cellRangePojo.getLastRowInteger(); ++i) {
                        XSSFRow xssfRow = xssfSheet.getRow(i);
                        for (int j = cellRangePojo.getFirstColInteger().intValue(); j <= cellRangePojo.getLastColInteger(); ++j) {
                            XSSFCellStyle xssfCellStyle = xssfRow.getCell(j).getCellStyle();
                            if (xssfCellStyle == null) {
                                xssfCellStyle = xssfWorkbook.createCellStyle();
                                xssfRow.getCell(j).setCellStyle((CellStyle)xssfCellStyle);
                            }
                            XSSFColor xssfColor = new XSSFColor();
                            xssfColor.setARGBHex(cellRangePojo.getBackgroundColorString());
                            xssfCellStyle.setFillForegroundColor(xssfColor);
                            xssfCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            xssfRow.getCell(j).setCellStyle((CellStyle)xssfCellStyle);
                        }
                    }
                }
            });
            LambdaUtils.run(() -> {
                List groupCellRangePojoList = (List)cellRangPojoListMap.get(COLUMN_WIDTH);
                if (CollectionUtils.isEmpty((Collection)groupCellRangePojoList)) {
                    return;
                }
                for (CellRangePojo cellRangePojo : groupCellRangePojoList) {
                    xssfSheet.setColumnWidth(cellRangePojo.getColumnIndexInteger().intValue(), cellRangePojo.getWidthInteger().intValue());
                }
            });
            LambdaUtils.run(() -> {
                List groupCellRangePojoList = (List)cellRangPojoListMap.get(ROW_HEIGHT);
                if (CollectionUtils.isEmpty((Collection)groupCellRangePojoList)) {
                    return;
                }
                xssfSheet.setDefaultRowHeight(sheetPojo.getDefaultRowHeight().shortValue());
                xssfSheet.setDefaultRowHeightInPoints((float)sheetPojo.getDefaultRowHeight().intValue());
                for (CellRangePojo cellRangePojo : groupCellRangePojoList) {
                    XSSFRow xssfRow = xssfSheet.getRow(cellRangePojo.getRowIndexInteger().intValue());
                    xssfRow.setHeight(cellRangePojo.getHeightInteger().shortValue());
                    xssfRow.setHeightInPoints((float)cellRangePojo.getHeightInteger().intValue());
                }
            });
        });
        return xssfWorkbook;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workbook getWorkbook(String fileUrlString) {
        if (StringUtils.isBlank((CharSequence)fileUrlString)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a", (String)"WorkbookUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        try (InputStream fileInputStream = UploadUtil.getFileInputStream(fileUrlString);){
            Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
            return workbook;
        }
        catch (Throwable throwable) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684Excel\u683c\u5f0f\u7684\u6587\u4ef6", (String)"WorkbookUtils_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public static List<List<ExcelCellPojo>> getExcelCellPojoRowList(Sheet sheet, Integer maxColInteger) {
        int lastRowNumInt = sheet.getLastRowNum();
        ArrayList<List<ExcelCellPojo>> excelCellPojoRowList = new ArrayList<List<ExcelCellPojo>>(lastRowNumInt + 1);
        for (int i = 0; i <= lastRowNumInt; ++i) {
            Row row = sheet.getRow(i);
            ArrayList<ExcelCellPojo> excelCellPojoList = new ArrayList<ExcelCellPojo>(maxColInteger);
            excelCellPojoRowList.add(excelCellPojoList);
            if (row == null) continue;
            for (int j = 0; j < maxColInteger; ++j) {
                Cell cell = row.getCell(j);
                ExcelCellPojo excelCellPojo = new ExcelCellPojo();
                excelCellPojoList.add(excelCellPojo);
                excelCellPojo.setRowInteger(i);
                excelCellPojo.setColInteger(j);
                if (cell == null) continue;
                if (CellType.STRING == cell.getCellType()) {
                    excelCellPojo.setValueString(cell.getStringCellValue());
                    continue;
                }
                cell.setCellType(CellType.STRING);
                excelCellPojo.setValueString(cell.getStringCellValue());
            }
        }
        return excelCellPojoRowList;
    }
}

