/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.base.helper;

import com.google.common.collect.Maps;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.utils.base.GraphUtils;

public class GraphHelper {
    private MutableGraph<String> graph;
    private List<String> nodeIdStringList;
    private String rootString;
    private Map<String, Integer> nodeIdIndexMap;
    private Integer nodeIdStringListSizeInteger;
    private List<List<String>> nodeIdStringListList;
    private List<List<String>> notLeafNodeIdStringListList;
    private Set<String> leafNodeIdStringSet;

    private GraphHelper() {
    }

    public static GraphHelper init(MutableGraph<String> graph) {
        HashSet nodeIdStringSet = new HashSet(graph.nodes());
        for (EndpointPair edgeEndpointPair : graph.edges()) {
            String targetString = (String)edgeEndpointPair.target();
            nodeIdStringSet.remove(targetString);
        }
        if (nodeIdStringSet.size() != 1) {
            throw new KDBizException("The root node must exist and be unique.");
        }
        GraphHelper graphHelper = new GraphHelper();
        graphHelper.rootString = (String)nodeIdStringSet.iterator().next();
        graphHelper.graph = graph;
        return graphHelper;
    }

    public static GraphHelper init(Collection<EdgePojo> edgePojoCollection) {
        return GraphHelper.init(GraphUtils.getGraph(edgePojoCollection));
    }

    public MutableGraph<String> getGraph() {
        return this.graph;
    }

    public String getRootString() {
        return this.rootString;
    }

    public List<List<String>> getNodeIdListList() {
        if (this.nodeIdStringListList == null) {
            this.nodeIdStringListList = new LinkedList<List<String>>();
            LinkedList<String> successorNodeIdStringList = new LinkedList<String>();
            successorNodeIdStringList.add(this.rootString);
            LinkedList _successorNodeIdStringList = new LinkedList();
            while (true) {
                this.nodeIdStringListList.add(new ArrayList(successorNodeIdStringList));
                for (String successorNodeIdString : successorNodeIdStringList) {
                    _successorNodeIdStringList.addAll(this.graph.successors((Object)successorNodeIdString));
                }
                if (_successorNodeIdStringList.isEmpty()) break;
                successorNodeIdStringList.clear();
                successorNodeIdStringList.addAll(_successorNodeIdStringList);
                _successorNodeIdStringList.clear();
            }
        }
        return this.nodeIdStringListList;
    }

    public List<String> getNodeIdStringList() {
        if (this.nodeIdStringList == null) {
            this.nodeIdStringList = this.getNodeIdListList().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return this.nodeIdStringList;
    }

    public Integer getIndexInteger(String nodeIdString) {
        if (this.nodeIdIndexMap == null) {
            this.nodeIdIndexMap = Maps.newHashMapWithExpectedSize((int)this.getSizeInt());
            List<String> nodeIdStringList = this.getNodeIdStringList();
            int nodeIdStringSizeInt = this.getSizeInt();
            for (int i = 0; i < nodeIdStringSizeInt; ++i) {
                this.nodeIdIndexMap.put(nodeIdStringList.get(i), i);
            }
        }
        return this.nodeIdIndexMap.get(nodeIdString);
    }

    public int getSizeInt() {
        if (this.nodeIdStringListSizeInteger == null) {
            this.nodeIdStringListSizeInteger = this.getNodeIdStringList().size();
        }
        return this.nodeIdStringListSizeInteger;
    }

    public Set<String> getLeafNodeIdStringSet(String nodeIdString) {
        return GraphUtils.getLeafNodeIdStringSet(this.graph, nodeIdString);
    }

    public Set<String> getLeafNodeIdStringSet() {
        if (this.leafNodeIdStringSet == null) {
            this.leafNodeIdStringSet = GraphUtils.getLeafNodeIdStringSet(this.graph, this.rootString);
        }
        return this.leafNodeIdStringSet;
    }

    public List<List<String>> getNotLeafNodeIdListList() {
        if (this.notLeafNodeIdStringListList == null) {
            Set<String> leafNodeIdStringSet = this.getLeafNodeIdStringSet();
            this.notLeafNodeIdStringListList = this.getNodeIdListList().stream().map(item -> item.stream().filter(listItem -> !leafNodeIdStringSet.contains(listItem)).collect(Collectors.toList())).filter(item -> !item.isEmpty()).collect(Collectors.toList());
        }
        return this.notLeafNodeIdStringListList;
    }
}

