/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.bgControlRecord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgControlRecordExt;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class ControlRecordUtils {
    private static final Log log = LogFactory.getLog(ControlRecordUtils.class);
    private static Map<String, DynamicObject> allDimension = new HashMap<String, DynamicObject>();

    public static IModelCacheHelper getModelCache(Map<String, Object> valueMap) {
        QFBuilder qfBuilder;
        DynamicObject dynamicObject;
        Object modelNumber = valueMap.get("model");
        if (modelNumber instanceof String && (dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reporttype", (QFilter[])(qfBuilder = new QFBuilder("shownumber", "=", (String)modelNumber)).toArray())) != null) {
            return ModelCacheContext.getOrCreate(dynamicObject.getLong("id"));
        }
        return null;
    }

    public static boolean isModelPer(Long modelId) {
        return ModelServiceHelper.isModelManager(modelId);
    }

    public static Map<String, IModelCacheHelper> getModelCache(List<String> modelNumber) throws Exception {
        HashMap<String, IModelCacheHelper> numberAndModelChacheMap = new HashMap<String, IModelCacheHelper>(16);
        QFBuilder qfBuilder = new QFBuilder("shownumber", "in", modelNumber);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"epm_model", (String)"id,reporttype,shownumber", (QFilter[])qfBuilder.toArray());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(dynamicObject.getLong("id"));
            numberAndModelChacheMap.put(dynamicObject.getString("shownumber"), modelCacheHelper);
        }
        return numberAndModelChacheMap;
    }

    public static SqlBuilder getSqlAppend(Map<String, Object> valueMap, IModelCacheHelper modelCache, Map<String, String> byModel, StringBuilder message, Long bussinessModelId) {
        String crTable;
        Object entity;
        boolean perm = false;
        if (ControlRecordUtils.isModelPer(modelCache.getModelobj().getId())) {
            perm = true;
        }
        if ((entity = valueMap.get(SysDimensionEnum.Entity.getNumber())) == null) {
            ControlRecordUtils.messageByEntity(message);
        }
        List<Long> entityIds = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, entity, "epm_entitymembertree", SysDimensionEnum.Entity.getNumber());
        Object account = valueMap.get(SysDimensionEnum.Account.getNumber());
        if (account == null) {
            ControlRecordUtils.messageByAccount(message);
        }
        List<Long> accountIds = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, account, "epm_accountmembertree", SysDimensionEnum.Account.getNumber());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("fmodelid = ", new Object[0]).append(modelCache.getModelobj().getId().toString(), new Object[0]);
        if (entityIds.size() == 0) {
            ControlRecordUtils.messageByEntity(message);
        } else {
            sqlBuilder.append(" and forgunitid in (", new Object[0]);
            ControlRecordUtils.sqlAppend(entityIds, sqlBuilder);
        }
        if (accountIds.size() == 0) {
            ControlRecordUtils.messageByAccount(message);
        } else {
            sqlBuilder.append(" and faccountid in (", new Object[0]);
            ControlRecordUtils.sqlAppend(accountIds, sqlBuilder);
        }
        if (modelCache.getModelobj().isModelByEB()) {
            ControlRecordUtils.userDefSqlByEb(valueMap, modelCache, byModel, message, sqlBuilder, perm);
            crTable = "t_eb_bgcontrolrecord";
            Object year = valueMap.get(SysDimensionEnum.Year.getNumber());
            Object period = valueMap.get(SysDimensionEnum.Period.getNumber());
            if (year == null) {
                ControlRecordUtils.messageByYear(message);
            }
            if (period == null) {
                ControlRecordUtils.messageByPeriod(message);
            }
            List<Long> list = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, year, "epm_yearmembertree", SysDimensionEnum.Year.getNumber());
            List<Long> periodId = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, period, "epm_periodmembertree", SysDimensionEnum.Period.getNumber());
            if (list.size() == 0) {
                ControlRecordUtils.messageByYear(message);
            } else {
                sqlBuilder.append(" and fyearid in (", new Object[0]);
                ControlRecordUtils.sqlAppend(list, sqlBuilder);
            }
            if (periodId.size() == 0) {
                ControlRecordUtils.messageByPeriod(message);
            } else {
                sqlBuilder.append(" and fperiodid in (", new Object[0]);
                ControlRecordUtils.sqlAppend(periodId, sqlBuilder);
            }
        } else {
            List<Long> bgPeriodId;
            if (bussinessModelId == 0L) {
                Map<Long, Long> bussModlId = ControlRecordUtils.getBussModlId(valueMap, modelCache);
                if (bussModlId.size() > 0) {
                    for (Map.Entry entry : bussModlId.entrySet()) {
                        bussinessModelId = (Long)entry.getValue();
                    }
                } else {
                    ControlRecordUtils.messageByBussId(message);
                }
            }
            allDimension = ControlRecordUtils.getAllDimension(modelCache.getModelobj().getId(), bussinessModelId);
            ControlRecordUtils.userDefSqlByBgmd(valueMap, modelCache, byModel, message, sqlBuilder, perm, bussinessModelId);
            crTable = "t_eb_cr" + bussinessModelId;
            log.info("ControlRecordUtils:bussinessModelId:" + crTable);
            Object bgPeriod = valueMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (bgPeriod == null) {
                ControlRecordUtils.messageByBgPeriod(message);
            }
            if ((bgPeriodId = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, bgPeriod, "epm_bperiodmembertree", SysDimensionEnum.BudgetPeriod.getNumber())).size() == 0) {
                ControlRecordUtils.messageByBgPeriod(message);
            } else {
                sqlBuilder.append(" and fbgperiodid in (", new Object[0]);
                ControlRecordUtils.sqlAppend(bgPeriodId, sqlBuilder);
            }
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 30000 fid,forgunitid,faccountid,fmetricid,famount,fcurrencyid,fversionid,fctid,fcreatorid,fcreatetime,fbiznumber,frefbizid,fbizid,fentitynumber,fserialtextjson", new Object[0]);
        if (modelCache.getModelobj().isModelByEB()) {
            sql.append(",fyearid,fperiodid,fuserdefinedid1,fuserdefinedid2,fuserdefinedid3,fuserdefinedid4,fuserdefinedid5,fuserdefinedid6", new Object[0]);
        } else {
            sql.append(",fbgperiodid", new Object[0]);
            for (Map.Entry<String, String> entry : byModel.entrySet()) {
                String[] split;
                if (allDimension.get(entry.getKey()) == null || (split = entry.getValue().split("\\.")).length <= 1) continue;
                sql.append(",", new Object[0]).append(String.join((CharSequence)"", "fuserdefinedid", split[1]), new Object[0]);
            }
        }
        sql.append(" from ", new Object[0]).append(crTable, new Object[0]);
        sql.append(" where ", new Object[0]).appendSqlBuilder(sqlBuilder);
        log.info("ControlRecordUtils:sql:" + sql);
        return sql;
    }

    private static List<Long> getMemberIds(IModelCacheHelper modelCache, Long bussinessModelId, boolean perm, StringBuilder message, Object member, String form, String dimMember) {
        List<Long> entityList;
        if (perm) {
            entityList = ControlRecordUtils.getDimensionId(modelCache, bussinessModelId, member, form, dimMember);
        } else {
            List<Long> entityId = ControlRecordUtils.getDimensionId(modelCache, bussinessModelId, member, form, dimMember);
            Set<Long> permEntity = DimMembPermHelper.getReadPermMembIds(dimMember, modelCache.getModelobj().getId(), bussinessModelId, null, true);
            if (permEntity == null) {
                entityList = entityId;
            } else {
                entityList = entityId.stream().filter(permEntity::contains).collect(Collectors.toList());
                if (entityList.size() == 0) {
                    message.append(ResManager.loadResFormat((String)"\u65e0\u6709\u6743\u9650%1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_6", (String)"epm-eb-formplugin", (Object[])new Object[]{dimMember}));
                }
            }
        }
        return entityList;
    }

    private static void messageByBgPeriod(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u7f3a\u5c11\u9884\u7b97\u671f\u95f4\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static void userDefSqlByBgmd(Map<String, Object> valueMap, IModelCacheHelper modelCache, Map<String, String> byModel, StringBuilder message, SqlBuilder sqlBuilder, boolean perm, Long bussinessModelId) {
        for (Map.Entry<String, String> userDefineMap : byModel.entrySet()) {
            if (valueMap.get(userDefineMap.getKey()) == null || allDimension.get(userDefineMap.getKey()) == null) continue;
            List<Long> userDefinedId = ControlRecordUtils.getMemberIds(modelCache, bussinessModelId, perm, message, valueMap.get(userDefineMap.getKey()), "epm_userdefinedmembertree", userDefineMap.getKey());
            if (userDefinedId.size() == 0) {
                ControlRecordUtils.messageByUserDef(message, userDefineMap.getKey());
                continue;
            }
            String[] split = userDefineMap.getValue().split("\\.");
            if (split.length <= 1) continue;
            sqlBuilder.append(" and", new Object[0]).append(String.join((CharSequence)"", "fuserdefinedid", split[1]), new Object[0]).append(" in (", new Object[0]);
            ControlRecordUtils.sqlAppend(userDefinedId, sqlBuilder);
        }
    }

    private static void userDefSqlByEb(Map<String, Object> valueMap, IModelCacheHelper modelCache, Map<String, String> byModel, StringBuilder message, SqlBuilder sqlBuilder, boolean perm) {
        for (Map.Entry<String, String> userDefineMap : byModel.entrySet()) {
            if (valueMap.get(userDefineMap.getKey()) == null) continue;
            List<Long> userDefinedId = ControlRecordUtils.getMemberIds(modelCache, 0L, perm, message, valueMap.get(userDefineMap.getKey()), "epm_userdefinedmembertree", userDefineMap.getKey());
            if (userDefinedId.size() == 0) {
                ControlRecordUtils.messageByUserDef(message, userDefineMap.getKey());
                continue;
            }
            String[] split = userDefineMap.getValue().split("\\.");
            if (split.length <= 1) continue;
            sqlBuilder.append(" and ", new Object[0]).append(String.join((CharSequence)"", "fuserdefinedid", split[1]), new Object[0]).append(" in (", new Object[0]);
            ControlRecordUtils.sqlAppend(userDefinedId, sqlBuilder);
        }
    }

    private static void messageByPeriod(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u7f3a\u5c11\u671f\u95f4\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static void messageByYear(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u7f3a\u5c11\u8d22\u5e74\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static void messageByUserDef(StringBuilder message, String key) {
        message.append(ResManager.loadResFormat((String)"\u7f3a\u5c11%1\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_8", (String)"epm-eb-formplugin", (Object[])new Object[]{key}));
    }

    private static void messageByAccount(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u7f3a\u5c11\u79d1\u76ee\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static void messageByEntity(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u7f3a\u5c11\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static void messageByBussId(StringBuilder message) {
        message.append(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BGControlRecordApi_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public static Map<Long, Long> getBussModlId(Map<String, Object> valueMap, IModelCacheHelper modelCache) {
        HashMap<Long, Long> dataSetMap = new HashMap<Long, Long>(1);
        Object acc = valueMap.get("Account");
        if (acc != null) {
            List auts;
            if (acc instanceof String) {
                String aut = (String)acc;
                ControlRecordUtils.getDataSetMap(modelCache, dataSetMap, aut);
            } else if (acc instanceof List && (auts = (List)acc).size() > 0) {
                String aut = (String)auts.get(0);
                ControlRecordUtils.getDataSetMap(modelCache, dataSetMap, aut);
            }
        }
        return dataSetMap;
    }

    private static void getDataSetMap(IModelCacheHelper modelCache, Map<Long, Long> dataSetMap, String aut) {
        if (!SysDimensionEnum.Account.getNumber().equals(aut)) {
            Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, aut);
            if (member != null && member.getDatasetId() != null) {
                Long datasetId = member.getDatasetId();
                dataSetMap.put(datasetId, modelCache.getBusModelByDataSet(datasetId));
            } else {
                Long datasetId = ControlRecordUtils.queryDataSetId(aut, modelCache.getModelobj().getId());
                if (datasetId != null && datasetId != 0L) {
                    Long bussinessModelId = DatasetServiceHelper.getInstance().queryBizmodelByDatasetId(datasetId);
                    dataSetMap.put(datasetId, bussinessModelId);
                }
            }
        }
    }

    public static Long queryDataSetId(String accountNumber, Long modelId) {
        DynamicObject dataset;
        if (accountNumber == null || accountNumber.length() == 0) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)accountNumber);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_accountmembertree", (String)"id,dataset", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && (dataset = (DynamicObject)dynamicObject.get("dataset")) != null) {
            return dataset.getLong("id");
        }
        return 0L;
    }

    public static void sqlAppend(List<Long> accountId, SqlBuilder sqlBuilder) {
        for (int i = 0; i < accountId.size(); ++i) {
            sqlBuilder.append(accountId.get(i).toString(), new Object[0]);
            if (i != accountId.size() - 1) {
                sqlBuilder.append(",", new Object[0]);
                continue;
            }
            sqlBuilder.append(")", new Object[0]);
        }
    }

    public static Map<String, DynamicObject> getAllDimension(Long modelId, Long bussModelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"epm_dimension", (String)"id,name,number", (QFilter[])qFilter.toArray());
        HashSet bgmControlDimIds = new HashSet(10);
        HashMap<String, DynamicObject> doc = new HashMap<String, DynamicObject>(16);
        Collection bgmControlDims = BusinessDataServiceHelper.loadFromCache((String)"eb_bgmcontroldimension", (QFilter[])new QFilter("model", "=", (Object)modelId).and("businessmodel", "=", (Object)bussModelId).toArray()).values();
        List dimIds = bgmControlDims.stream().map(p -> p.getDynamicObjectCollection("entryentity").stream().map(m -> m.getLong("dimensionid")).collect(Collectors.toSet())).collect(Collectors.toList());
        if (dimIds.size() > 0) {
            bgmControlDimIds.addAll((Collection)dimIds.get(0));
        }
        if (bgmControlDimIds.size() > 0) {
            docs.removeIf(p -> !bgmControlDimIds.contains(p.getLong("id")));
        }
        if (bgmControlDimIds.size() == 0) {
            docs.removeIf(next -> !SysDimensionEnum.Account.getNumber().equals(next.getString("number")));
        }
        docs.forEach(p -> doc.put(p.getString("number"), (DynamicObject)p));
        return doc;
    }

    public static List<Long> getDimensionId(IModelCacheHelper modelCache, Long bussModelId, Object account, String from, String dimension) {
        ArrayList<Long> entityId = new ArrayList<Long>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelCache.getModelobj().getId());
        qfBuilder.add("dimension.number", "=", dimension);
        if (account instanceof List) {
            qfBuilder.add(new QFilter("number", "in", account));
            DynamicObjectCollection query = QueryServiceHelper.query((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dynamicObject : query) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, dynamicObject.getLong("id"));
                List<Member> detailChildren = modelCache.getDetailChildren(member);
                entityId.add(member.getId());
                detailChildren.forEach(e -> entityId.add(e.getId()));
            }
        } else if (account instanceof String) {
            qfBuilder.add(new QFilter("number", "=", account));
            DynamicObject query = QueryServiceHelper.queryOne((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            if (query != null) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, query.getLong("id"));
                List<Member> detailChildren = modelCache.getDetailChildren(member);
                entityId.add(member.getId());
                detailChildren.forEach(e -> entityId.add(e.getId()));
            }
        }
        return entityId;
    }

    public static List<String> getDimensionNumber(IModelCacheHelper modelCache, Long bussModelId, Object account, String from, String dimension) {
        ArrayList<String> memberNumber = new ArrayList<String>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelCache.getModelobj().getId());
        if (account instanceof List) {
            qfBuilder.add(new QFilter("number", "in", account));
            DynamicObjectCollection query = QueryServiceHelper.query((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dynamicObject : query) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, dynamicObject.getLong("id"));
                List<Member> detailChildren = modelCache.getDetailChildren(member);
                if (member.isLeaf()) {
                    memberNumber.add(member.getNumber());
                }
                detailChildren.forEach(e -> memberNumber.add(e.getNumber()));
            }
        } else if (account instanceof String) {
            qfBuilder.add(new QFilter("number", "=", account));
            DynamicObject query = QueryServiceHelper.queryOne((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            if (query != null) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, query.getLong("id"));
                List<Member> detailChildren = modelCache.getDetailChildren(member);
                if (member.isLeaf()) {
                    memberNumber.add(member.getNumber());
                }
                detailChildren.forEach(e -> memberNumber.add(e.getNumber()));
            }
        }
        return memberNumber;
    }

    public static Map<Collection<String>, List<String>> getDimensionNumberByPeriod(IModelCacheHelper modelCache, Long bussModelId, Object account, String from, String dimension) {
        DynamicObjectCollection query;
        HashMap<Collection<String>, List<String>> memberNumber = new HashMap<Collection<String>, List<String>>(16);
        Collection<String> type = null;
        ArrayList<String> list = null;
        ArrayList<String> arrList = new ArrayList<String>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelCache.getModelobj().getId());
        if (account instanceof List) {
            qfBuilder.add(new QFilter("number", "in", account));
            query = QueryServiceHelper.query((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dynamicObject : query) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, dynamicObject.getLong("id"));
                if (member.isLeaf()) {
                    arrList.add(member.getNumber());
                    continue;
                }
                List<Member> detailChildren = modelCache.getDetailChildren(member);
                detailChildren.forEach(e -> arrList.add(e.getNumber()));
            }
        } else if (account instanceof String) {
            qfBuilder.add(new QFilter("number", "=", account));
            query = QueryServiceHelper.queryOne((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            if (query != null) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, query.getLong("id"));
                arrList.add(member.getNumber());
            }
        }
        for (String number : arrList) {
            type = ControlRecordUtils.dealSettingType(number);
            if (memberNumber.get(type) != null) {
                List strings = (List)memberNumber.get(type);
                strings.add(number);
                continue;
            }
            list = new ArrayList<String>(16);
            list.add(number);
            memberNumber.put(type, list);
        }
        return memberNumber;
    }

    public static Map<Collection<String>, List<String>> getDimensionNumberByBudgetPeriod(IModelCacheHelper modelCache, Long bussModelId, Object account, String from, String dimension) {
        HashMap<Collection<String>, List<String>> memberNumber = new HashMap<Collection<String>, List<String>>(16);
        Collection<String> type = null;
        ArrayList<String> list = null;
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelCache.getModelobj().getId());
        if (account instanceof List) {
            qfBuilder.add(new QFilter("number", "in", account));
            DynamicObjectCollection query = QueryServiceHelper.query((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dynamicObject : query) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, dynamicObject.getLong("id"));
                type = ControlRecordUtils.isExitMixturePeriod(member.getNumber());
                if (memberNumber.get(type) != null) {
                    List strings = (List)memberNumber.get(type);
                    strings.add(member.getNumber());
                    continue;
                }
                list = new ArrayList(16);
                list.add(member.getNumber());
                memberNumber.put(type, list);
            }
        } else if (account instanceof String) {
            qfBuilder.add(new QFilter("number", "=", account));
            DynamicObject query = QueryServiceHelper.queryOne((String)from, (String)"id", (QFilter[])qfBuilder.toArray());
            if (query != null) {
                Member member = modelCache.getMemberByAnyView(bussModelId, dimension, query.getLong("id"));
                type = ControlRecordUtils.dealSettingType(member.getNumber());
                list = new ArrayList<String>(16);
                list.add(member.getNumber());
                memberNumber.put(type, list);
            }
        }
        return memberNumber;
    }

    public static boolean isCollection(Collection<String> coll, Collection<String> collection) {
        if (coll == null || collection == null) {
            return false;
        }
        if (coll.size() != collection.size()) {
            return false;
        }
        return coll.stream().sorted().collect(Collectors.joining()).equals(collection.stream().sorted().collect(Collectors.joining()));
    }

    public static Collection<String> dealSettingType(String periodNumber) {
        ArrayList<String> type = new ArrayList<String>(2);
        if (periodNumber.startsWith("M_Q")) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
        } else if (periodNumber.startsWith("Q_Q")) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
        } else if (periodNumber.startsWith("M_HF")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
        } else if (periodNumber.startsWith("Q_HF")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_HALFYEAR_ADDUP.getNumber());
        } else if (periodNumber.endsWith("_YearTotal")) {
            type.add(BgControlSettingTypeEnum.YEAR.getNumber());
        } else if (periodNumber.startsWith("HF_")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.HALFYEAR_ADDUP.getNumber());
        } else {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
        }
        return type;
    }

    public static Collection<String> isExitMixturePeriod(String periodNumber) {
        ArrayList<String> type = new ArrayList<String>(1);
        int i = 0;
        int j = 0;
        int z = 0;
        if (periodNumber.indexOf(".Q") >= 0) {
            ++i;
        } else if (periodNumber.indexOf(".H") >= 0) {
            ++j;
        } else if (periodNumber.indexOf(".M") >= 0) {
            ++z;
        }
        if (i != 0 && j == 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        }
        return type;
    }

    public static void decare(int index, List<List<String>> all, List<String> temp, List<List<String>> asd) {
        List<String> list = all.get(index);
        int allSize = all.size();
        int removeCount = allSize - index;
        for (int i = 0; i < list.size(); ++i) {
            String value = list.get(i);
            if (i > 0) {
                for (int j = 0; j < removeCount; ++j) {
                    temp.remove(temp.size() - 1);
                }
            }
            temp.add(value);
            if (index == allSize - 1) {
                List<String> copy = ControlRecordUtils.deepCopy(temp);
                asd.add(copy);
            }
            if (index >= allSize - 1) continue;
            ControlRecordUtils.decare(index + 1, all, temp, asd);
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> deepCopy(List<T> src) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DynamicObject businessmodel(String dataSetNumber, long modelId) {
        QFilter qFilter = new QFilter("number", "=", (Object)dataSetNumber);
        qFilter.and("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id,businessmodel", (QFilter[])qFilter.toArray());
    }

    public static void returnDataDimList(IModelCacheHelper modelCache, Long bussModelId, Map<String, String> byModel, List<Map<String, Object>> recordList, Row dynamicObject, Map<Long, String> userNames) {
        BgControlRecordExt ext;
        String biznumber;
        HashMap<String, Object> dimensionMap = new HashMap<String, Object>(16);
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "forgunitid", SysDimensionEnum.Entity.getNumber());
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "faccountid", SysDimensionEnum.Account.getNumber());
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fcurrencyid", SysDimensionEnum.Currency.getNumber());
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fversionid", SysDimensionEnum.Version.getNumber());
        if (modelCache.getModelobj().isModelByEB()) {
            ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fyearid", SysDimensionEnum.Year.getNumber());
            ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fperiodid", SysDimensionEnum.Period.getNumber());
        } else {
            ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fbgperiodid", SysDimensionEnum.BudgetPeriod.getNumber());
        }
        if (modelCache.getModelobj().isModelByEB()) {
            for (Map.Entry<String, String> userMap : byModel.entrySet()) {
                ControlRecordUtils.getDimMemberByUserDef(modelCache, bussModelId, dynamicObject, dimensionMap, userMap);
            }
        } else {
            for (Map.Entry<String, String> userMap : byModel.entrySet()) {
                if (allDimension.get(userMap.getKey()) == null) continue;
                ControlRecordUtils.getDimMemberByUserDef(modelCache, bussModelId, dynamicObject, dimensionMap, userMap);
            }
        }
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fctid", SysDimensionEnum.ChangeType.getNumber());
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, "fmetricid", SysDimensionEnum.Metric.getNumber());
        long changetype = dynamicObject.getLong("fctid");
        Member chaMember = modelCache.getMember(SysDimensionEnum.ChangeType.getNumber(), (Long)0L, changetype);
        if (chaMember != null) {
            dimensionMap.put(chaMember.getNumber(), dynamicObject.getBigDecimal("famount"));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(biznumber = dynamicObject.getString("fbiznumber")))) {
            dimensionMap.put("biznumber", biznumber);
        }
        dimensionMap.put("bizid", dynamicObject.getString("fbizid"));
        String entitynumber = dynamicObject.getString("fentitynumber");
        dimensionMap.put("entitynumber", entitynumber);
        String frefbizid = dynamicObject.getString("frefbizid");
        dimensionMap.put("refbizid", frefbizid);
        Long creator = dynamicObject.getLong("fcreatorid");
        ControlRecordUtils.setName(userNames, dimensionMap, creator, "creator");
        String serext = dynamicObject.getString("fserialtextjson");
        if (StringUtils.isNotEmpty(serext) && (ext = JSONUtils.parse(serext, BgControlRecordExt.class)) != null) {
            ControlRecordUtils.setName(userNames, dimensionMap, ext.getApplierId(), "applier");
        }
        Date fcreatetime = dynamicObject.getDate("fcreatetime");
        dimensionMap.put("createtime", fcreatetime);
        recordList.add(dimensionMap);
    }

    private static void setName(Map<Long, String> userNames, Map<String, Object> dimensionMap, Long creator, String key) {
        QFilter qFilter1;
        DynamicObject queryOne;
        String username = null;
        if (IDUtils.isNotNull(creator) && (username = userNames.get(creator)) == null && (queryOne = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"name", (QFilter[])(qFilter1 = new QFilter("id", "=", (Object)creator)).toArray())) != null) {
            username = queryOne.getString("name");
            userNames.put(creator, username);
        }
        if (username != null) {
            dimensionMap.put(key, username);
        } else {
            dimensionMap.put(key, "");
        }
    }

    private static void getDimMemberByUserDef(IModelCacheHelper modelCache, Long bussModelId, Row dynamicObject, Map<String, Object> dimensionMap, Map.Entry<String, String> userMap) {
        String index = userMap.getValue().split("\\.")[1];
        String field = "fuserdefinedid" + index;
        ControlRecordUtils.getDimMember(modelCache, bussModelId, dimensionMap, dynamicObject, field, userMap.getKey());
    }

    public static void getDimMember(IModelCacheHelper modelCache, Long bussModelId, Map<String, Object> dimensionMap, Row dynamicObject, String bgperiod2, String number) {
        long bgperiod = dynamicObject.getLong(bgperiod2);
        Member bgMember = modelCache.getMemberByAnyView(bussModelId, number, bgperiod);
        if (bgMember != null) {
            HashMap<String, String> memberMap = new HashMap<String, String>(3);
            memberMap.put("id", bgMember.getId().toString());
            memberMap.put("name", bgMember.getName());
            memberMap.put("number", bgMember.getNumber());
            dimensionMap.put(number, memberMap);
        }
    }

    public static long getBusinessModelId(Map<String, Object> valueMap, IModelCacheHelper modelCache) {
        long businessModelId = 0L;
        if (modelCache.getModelobj().isModelByEB()) {
            return businessModelId;
        }
        Object businessModel = valueMap.get("bussinessModel");
        Object businessModelIdObj = valueMap.get("bussinessModelId");
        if (businessModel != null) {
            DynamicObject businessmodel;
            if (businessModel instanceof String && (businessmodel = ControlRecordUtils.businessmodel((String)businessModel, modelCache.getModelobj().getId())) != null) {
                businessModelId = businessmodel.getLong("businessmodel");
            }
        } else if (businessModelIdObj != null) {
            if (businessModelIdObj instanceof String) {
                businessModelId = Long.parseLong((String)businessModelIdObj);
            } else if (businessModelIdObj instanceof Long) {
                businessModelId = (Long)businessModelIdObj;
            }
        }
        return businessModelId;
    }
}

