/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.cache.ICache;
import org.jetbrains.annotations.NotNull;

public class Cache
implements ICache {
    protected static final Log log = LogFactory.getLog(Cache.class);
    public static final String CACHE_REGION = "budget-cache";
    public static final int defaultTimeOut = CacheKeyUtil.getPageCacheKeyTimeout();
    public static final TimeUnit defaultTimeUnit = TimeUnit.SECONDS;
    private static volatile ICache cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICache get() {
        if (cache != null) return cache;
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            if (cache != null) return cache;
            cache = new Cache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    protected DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(this.getBudgetCacheKey(null));
    }

    protected DistributeSessionlessCache getCache(@NotNull String cacheGroupKey) {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(this.getBudgetCacheKey(cacheGroupKey));
    }

    private String getBudgetCacheKey(String cacheGroupKey) {
        StringBuilder _cacheKey = new StringBuilder();
        _cacheKey.append(CacheKeyUtil.getAcctId()).append(CACHE_REGION);
        if (cacheGroupKey != null) {
            _cacheKey.append(cacheGroupKey.trim());
        }
        return _cacheKey.toString();
    }

    protected String getCacheKey(String cacheKey) {
        return cacheKey;
    }

    @Override
    public boolean contains(String key) {
        return this.getCache().contains(this.getCacheKey(key));
    }

    @Override
    public boolean contains(String type, String key) {
        return this.getCache().contains(this.getCacheKey(type), key);
    }

    @Override
    public String get(String key) {
        return (String)this.getCache().get(this.getCacheKey(key));
    }

    @Override
    public String get(String type, String key) {
        return (String)this.getCache().get(this.getCacheKey(type), key);
    }

    @Override
    public List<String> getAll(String type, String[] keys) {
        return this.getCache().get(this.getCacheKey(type), keys);
    }

    @Override
    public void set(String key, String value) {
        this.set(key, value, defaultTimeOut, defaultTimeUnit);
    }

    @Override
    public void set(String key, String value, int timeout, TimeUnit timeUnit) {
        if (key == null) {
            return;
        }
        if (timeout <= 0 || timeUnit == null) {
            this.getCache().put(this.getCacheKey(key), (Object)value);
        } else {
            this.getCache().put(this.getCacheKey(key), (Object)value, timeout, timeUnit);
        }
    }

    @Override
    public void set(String type, String key, String value) {
        this.set(type, key, value, defaultTimeOut, defaultTimeUnit);
    }

    @Override
    public void set(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        if (type == null || key == null) {
            return;
        }
        this.getCache().put(this.getCacheKey(type), key, value, timeout, timeUnit);
    }

    @Override
    public void hmSet(String type, Map<String, String> keyValues) {
        this.hmSet(type, keyValues, defaultTimeOut, defaultTimeUnit);
    }

    @Override
    public void hmSet(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        if (type == null) {
            return;
        }
        if (timeout <= 0 || timeUnit == null) {
            this.getCache().put(this.getCacheKey(type), keyValues);
        } else {
            this.getCache().put(this.getCacheKey(type), keyValues, timeout, timeUnit);
        }
    }

    @Override
    public Map<String, String> hGet(String type) {
        if (type == null) {
            return null;
        }
        return this.getCache().getAll(this.getCacheKey(type));
    }

    @Override
    public void remove(String key) {
        if (key == null) {
            return;
        }
        this.getCache().remove(this.getCacheKey(key));
    }
}

