/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.compress;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.compress.CompressParams;
import kd.epm.eb.common.utils.compress.object.node.Node2Array;

public abstract class AbstractCompressUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String compressData(Object arrays, LogStats stats) {
        String _compressData;
        if (arrays == null || stats == null) {
            return null;
        }
        stats.addInfo("begin-serialize.");
        try {
            _compressData = SerializationUtils.toJsonString((Object)arrays);
            stats.addInfo("before-compressData-size:" + _compressData.length());
            _compressData = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress(_compressData));
            stats.addInfo("end-compressData-size:" + _compressData.length());
        }
        finally {
            stats.addInfo("end-serialize.");
        }
        return _compressData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String unCompressData(String unCompressData, LogStats stats) {
        String _unCompressData;
        if (unCompressData == null || stats == null) {
            return null;
        }
        stats.addInfo("begin-unSerialize.");
        stats.addInfo("before-unCompressData-size:" + unCompressData.length());
        try {
            _unCompressData = GZIPUtils.uncompressToString((byte[])SerializationUtils.deSerializeFromBase64((String)unCompressData));
            stats.addInfo("end-unCompressData-size:" + _unCompressData.length());
        }
        finally {
            stats.addInfo("end-serialize.");
        }
        return _unCompressData;
    }

    protected List<Object[]> toArrays(Object object, CompressParams params) {
        if (object == null) {
            return null;
        }
        List<Object[]> arrays = null;
        if (object instanceof TreeNode) {
            TreeNode _node = (TreeNode)object;
            Node2Array node2Array = Node2Array.get();
            String[] _properties = params.getProperties() != null ? params.getProperties() : node2Array.detectProperty(_node);
            String[] _compressProperties = params.getCompressProperties() != null ? params.getCompressProperties() : _properties;
            arrays = node2Array.toArray(_node, _properties, _compressProperties);
        }
        return arrays;
    }

    protected <T> T fromArrays(String unCompressData) {
        if (unCompressData == null) {
            return null;
        }
        List nodes = SerializationUtils.fromJsonStringToList((String)unCompressData, Object[].class);
        return (T)Node2Array.get().fromArray(nodes);
    }
}

