/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.compress;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.compress.AbstractCompressUtils;
import kd.epm.eb.common.utils.compress.CompressParams;
import kd.epm.eb.common.utils.compress.ICompress;

public class CompressUtils
extends AbstractCompressUtils
implements ICompress {
    public static final Log log = LogFactory.getLog(AbstractCompressUtils.class);

    public static CompressUtils get() {
        return new CompressUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compress(Object object, CompressParams params) {
        String compressData;
        if (object == null) {
            return null;
        }
        LogStats stats = new LogStats("budget-serialize-log : ");
        stats.addInfo("begin-compress.");
        try {
            List<Object[]> arrays = this.toArrays(object, params);
            compressData = arrays != null ? this.compressData(arrays, stats) : this.compressData(object, stats);
        }
        finally {
            stats.addInfo("end-compress.");
            log.info(stats.toString());
        }
        return compressData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unCompress(String unCompressData, Class<T> classType) {
        if (unCompressData == null || classType == null) {
            return null;
        }
        LogStats stats = new LogStats("budget-serialize-log : ");
        stats.addInfo("begin-unCompress.");
        Object result = null;
        try {
            String _unCompressData = this.unCompressData(unCompressData, stats);
            if (_unCompressData != null) {
                result = TreeNode.class.isAssignableFrom(classType) ? (Object)this.fromArrays(_unCompressData) : SerializationUtils.fromJsonString((String)_unCompressData, classType);
            }
        }
        finally {
            stats.addInfo("end-unCompress.");
            log.info(stats.toString());
        }
        return (T)result;
    }

    public byte[] compressByDeflater(Object inputStr) {
        byte[] inputData = inputStr instanceof String ? inputStr.toString().getBytes() : (byte[])inputStr;
        Deflater deflater = new Deflater();
        deflater.setInput(inputData);
        deflater.finish();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            baos.write(buffer, 0, count);
        }
        deflater.end();
        return baos.toByteArray();
    }

    public String unCompressByInflater(byte[] compressedData) throws DataFormatException, UnsupportedEncodingException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            baos.write(buffer, 0, count);
        }
        return baos.toString("UTF-8");
    }
}

