/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.compress.base.recording;

import java.util.Map;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.compress.base.recording.AbstractRecording;
import kd.epm.eb.common.utils.compress.base.recording.IRecording;

public class StringRecoding
extends AbstractRecording {
    public static IRecording get() {
        return new StringRecoding();
    }

    @Override
    public <T> T encode(T data, Map<T, String> encodeMap) {
        return (T)this.$encode((String)data, encodeMap);
    }

    private String $encode(String text, Map<String, String> encodeMap) {
        if (StringUtils.isEmpty(text) || text.length() <= 10 || encodeMap == null) {
            return text;
        }
        String after = encodeMap.get(text);
        if (StringUtils.isEmpty(after)) {
            String index = "#$~" + (encodeMap.size() + 1);
            encodeMap.put(text, index);
            after = index + "&" + text;
        }
        return after;
    }

    @Override
    public <T> T decode(T data, Map<String, T> decodeMap) {
        return (T)this.$decode((String)data, decodeMap);
    }

    private String $decode(String text, Map<String, String> decodeMap) {
        if (StringUtils.isEmpty(text) || decodeMap == null) {
            return text;
        }
        if (text.startsWith("#$~")) {
            String _text = decodeMap.get(text);
            if (_text == null) {
                String[] strs = text.split("&");
                if (strs.length == 2) {
                    decodeMap.put(strs[0], strs[1]);
                    text = strs[1];
                }
            } else {
                text = _text;
            }
        }
        return text;
    }
}

