/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.compress.object.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.tree.TreeNode;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.compress.base.RecordingUtils;

public abstract class AbstractNode2Array {
    private static final int BASE_PROP_SIZE = 5;
    private static final int BASE_PROP_ID = 0;
    private static final int BASE_PROP_PARENT_ID = 1;
    private static final int BASE_PROP_TEXT = 2;
    private static final int BASE_PROP_EXPEND = 3;
    private static final int BASE_PROP_COLOR = 4;
    private RecordingUtils utils = null;

    protected RecordingUtils getRecordUtils() {
        if (this.utils == null) {
            this.utils = RecordingUtils.get();
        }
        return this.utils;
    }

    protected void toArray(TreeNode parent, List<Object[]> nodes, String ... properties) {
        if (parent == null) {
            return;
        }
        nodes.add(this.toArrayData(parent, properties));
        if (parent.getChildren() != null) {
            for (TreeNode node : parent.getChildren()) {
                this.toArray(node, nodes, properties);
            }
        }
    }

    private Object[] toArrayData(TreeNode node, String[] properties) {
        Object[] arrayData;
        block16: {
            int size = 5 + (properties != null ? properties.length : 0);
            arrayData = new Object[size];
            arrayData[0] = node.getChildren() == null || node.getChildren().isEmpty() ? node.getId() : this.getRecordUtils().encode(node.getId());
            arrayData[1] = this.getRecordUtils().encode(node.getParentid());
            arrayData[2] = node.getText();
            Object object = arrayData[3] = node.isExpend() ? "1" : "";
            if (node.getColor() != null) {
                switch (node.getColor()) {
                    case "red": {
                        arrayData[4] = "r";
                        break;
                    }
                    case "green": {
                        arrayData[4] = "g";
                        break;
                    }
                    case "#999999": {
                        arrayData[4] = "gr";
                        break;
                    }
                    default: {
                        arrayData[4] = "";
                        break;
                    }
                }
            } else {
                arrayData[4] = "";
            }
            if (properties == null || properties.length <= 0) break block16;
            if (node.getData() instanceof Map) {
                Map nodeData = (Map)node.getData();
                Set<String> compressProperties = this.getRecordUtils().getProperties().getCompressPropertiesSet();
                for (int i = 0; i < properties.length; ++i) {
                    int index = 5 + i;
                    String property = properties[i];
                    arrayData[index] = this.getRecordUtils().encode(property, nodeData.get(property), compressProperties);
                    if (arrayData[index] != null) continue;
                    arrayData[index] = "";
                }
            } else {
                for (int i = 0; i < properties.length; ++i) {
                    arrayData[5 + i] = "";
                }
            }
        }
        return arrayData;
    }

    protected TreeNode toTreeNodeData(Object[] array, String[] properties) {
        if (array == null || array.length == 0) {
            return null;
        }
        TreeNode node = new TreeNode();
        node.setId((String)this.getRecordUtils().decode(array[0]));
        node.setParentid((String)this.getRecordUtils().decode(array[1], ""));
        node.setText((String)array[2]);
        node.setExpend(StringUtils.equals("1", (String)array[3]));
        String _color = (String)array[4];
        if (StringUtils.isNotEmpty(_color)) {
            switch (_color) {
                case "r": {
                    node.setColor("red");
                    break;
                }
                case "g": {
                    node.setColor("green");
                    break;
                }
                case "gr": {
                    node.setColor("#999999");
                }
            }
        }
        if (properties != null && properties.length > 0) {
            HashMap<String, Object> nodeData = new HashMap<String, Object>(properties.length);
            Set<String> compressProperties = this.getRecordUtils().getProperties().getCompressPropertiesSet();
            for (int i = 0; i < properties.length; ++i) {
                Object value = array[5 + i];
                if (value == null) continue;
                String property = properties[i];
                value = this.getRecordUtils().decode(property, value, compressProperties);
                if (value == null) continue;
                nodeData.put(property, value);
            }
            if (!nodeData.isEmpty()) {
                node.setData(nodeData);
            }
        }
        return node;
    }
}

