/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.control;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.OrgUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class BgContParamUtils {
    private static final LogUtils log = LogUtils.getInstance(BgContParamUtils.class);
    public static final String IS_CONTROL_STR = "IS_CONTROL";
    public static final String IS_SHOWBALANCE_STR = "IS_SHOWBALANCE";
    public static final String IS_SHOWCHECKMEMPERMISSION_STR = "IS_SHOWCHECKMEMPERMISSION";
    public static final String IS_SHOWBEYONDMESSAGE_STR = "IS_SHOWBEYONDMESSAGE";
    public static final int IS_CONTROL = 0;
    public static final int IS_SHOWBALANCE = 1;
    public static final int IS_SHOWCHECKMEMPERMISSION = 2;
    public static final int IS_SHOWBEYONDMESSAGE = 3;

    public static boolean[] getManagerParam(String entityNumber, Long orgId) {
        String _orgId;
        Boolean value;
        HashMap<String, Boolean> controlMap;
        HashMap<String, Map> paramsCache;
        boolean[] params = BgContParamUtils.getDefaultParam();
        if (StringUtils.isEmpty(entityNumber) || orgId == 0L) {
            return params;
        }
        boolean hasSave = false;
        HashMap entityCache = CacheServiceHelper.get("CONTROL_PARAM_CACHE", Map.class);
        if (entityCache == null) {
            entityCache = new HashMap();
        }
        if ((paramsCache = (HashMap<String, Map>)entityCache.get(entityNumber)) == null) {
            paramsCache = new HashMap<String, Map>();
            entityCache.put(entityNumber, paramsCache);
        }
        if ((controlMap = (HashMap<String, Boolean>)paramsCache.get(IS_CONTROL_STR)) == null) {
            controlMap = new HashMap<String, Boolean>();
            paramsCache.put(IS_CONTROL_STR, controlMap);
        }
        if ((value = (Boolean)controlMap.get(_orgId = String.valueOf(orgId))) == null) {
            hasSave = true;
            params[0] = BgContParamUtils.queryControl(entityNumber, orgId);
            controlMap.put(_orgId, params[0]);
        } else {
            params[0] = value;
        }
        Map showBalanceMap = paramsCache.computeIfAbsent(IS_SHOWBALANCE_STR, k -> new HashMap());
        Map showCheckMemPermissionMap = paramsCache.computeIfAbsent(IS_SHOWCHECKMEMPERMISSION_STR, k -> new HashMap(16));
        Map showBeyondMessageMap = paramsCache.computeIfAbsent(IS_SHOWBEYONDMESSAGE_STR, k -> new HashMap(16));
        Map<Object, Object> controlParamMap = new HashMap(16);
        value = (Boolean)showBalanceMap.get(_orgId);
        if (value == null) {
            boolean showBalance;
            hasSave = true;
            controlParamMap = BgContParamUtils.queryShowControlParam(entityNumber, orgId);
            params[1] = showBalance = controlParamMap.get(IS_SHOWBALANCE_STR) == null ? false : (Boolean)controlParamMap.get(IS_SHOWBALANCE_STR);
            showBalanceMap.put(_orgId, params[1]);
        } else {
            params[1] = value;
        }
        value = (Boolean)showCheckMemPermissionMap.get(_orgId);
        if (value == null) {
            boolean showCheckMemPermission;
            hasSave = true;
            if (controlParamMap.isEmpty()) {
                controlParamMap = BgContParamUtils.queryShowControlParam(entityNumber, orgId);
            }
            params[2] = showCheckMemPermission = controlParamMap.get(IS_SHOWCHECKMEMPERMISSION_STR) == null ? false : (Boolean)controlParamMap.get(IS_SHOWCHECKMEMPERMISSION_STR);
            showCheckMemPermissionMap.put(_orgId, params[2]);
        } else {
            params[2] = value;
        }
        value = (Boolean)showBeyondMessageMap.get(_orgId);
        if (value == null) {
            boolean showBeyondMessage;
            hasSave = true;
            if (controlParamMap.isEmpty()) {
                controlParamMap = BgContParamUtils.queryShowControlParam(entityNumber, orgId);
            }
            params[3] = showBeyondMessage = controlParamMap.get(IS_SHOWBEYONDMESSAGE_STR) == null ? false : (Boolean)controlParamMap.get(IS_SHOWBEYONDMESSAGE_STR);
            showBeyondMessageMap.put(_orgId, params[3]);
        } else {
            params[3] = value;
        }
        if (hasSave) {
            CacheServiceHelper.put("CONTROL_PARAM_CACHE", entityCache);
        }
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean queryControl(String entityNumber, Long orgId) {
        if (StringUtils.isEmpty(entityNumber) || orgId == 0L) {
            return false;
        }
        boolean isControl = false;
        Set<Long> orgUnitIds = OrgUtils.getParentIds("bos_org_structure", orgId, true, OrgViewTypeEnum.IS_ORGUNIT);
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("org", "in", orgUnitIds));
            builder.add(new QFilter("controlprocess.entryentity.bill.fieldtable", "=", (Object)entityNumber));
            builder.add(new QFilter("controlprocess.enable", "=", (Object)Character.valueOf('1')));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryControl", (String)"eb_bgcontrolprocessorg", (String)"id, org.number", (QFilter[])builder.toArrays(), null, (int)1);){
                if (ds == null) return isControl;
                isControl = ds.hasNext();
                return isControl;
            }
        } else {
            log.warn("budget-control-log : ", "budget control error: orgid not exists! " + orgId);
        }
        return isControl;
    }

    public static Map<String, Boolean> queryShowControlParam(String entityNumber, Long orgId) {
        HashMap<String, Boolean> controlParamMap = new HashMap<String, Boolean>(16);
        if (StringUtils.isEmpty(entityNumber) || orgId == null || orgId == 0L) {
            return controlParamMap;
        }
        boolean hasData = false;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("bill.fieldtable", "=", (Object)entityNumber));
        builder.add(new QFilter("org", "=", (Object)orgId));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryShowControlParam", (String)"eb_controlparameter", (String)"showebbalance,showcheckmempermission,showbeyondmessage", (QFilter[])builder.toArrays(), null, (int)1);){
            Row row = null;
            if (ds != null && ds.hasNext()) {
                row = ds.next();
                hasData = true;
                controlParamMap.put(IS_SHOWBALANCE_STR, row.getBoolean("showebbalance"));
                controlParamMap.put(IS_SHOWCHECKMEMPERMISSION_STR, row.getBoolean("showcheckmempermission"));
                controlParamMap.put(IS_SHOWBEYONDMESSAGE_STR, row.getBoolean("showbeyondmessage"));
            }
        }
        if (!hasData) {
            String longNumber;
            DynamicObject orgUnit;
            builder.clear();
            builder.add(new QFilter("org", "=", (Object)orgId));
            builder.add(new QFilter("view", "=", (Object)Integer.valueOf(OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType())));
            Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg_structure", (String)"id, number, longnumber", (QFilter[])builder.toArrays());
            if (orgs != null && !orgs.isEmpty() && (orgUnit = (DynamicObject)orgs.values().iterator().next()) != null && StringUtils.isNotEmpty(longNumber = orgUnit.getString("longnumber"))) {
                String number = null;
                Stack<String> numbers = new Stack<String>();
                HashMap<String, Boolean> showBalanceMap = new HashMap<String, Boolean>(16);
                HashMap<String, Boolean> showCheckMemPermissionMap = new HashMap<String, Boolean>(16);
                HashMap<String, Boolean> showBeyondMessageMap = new HashMap<String, Boolean>(16);
                String[] numberStrs = longNumber.split("!");
                if (numberStrs != null && numberStrs.length > 0) {
                    int in = numberStrs.length - 1;
                    for (int i = 0; i < in; ++i) {
                        numbers.push(numberStrs[i]);
                    }
                    builder.clear();
                    builder.add(new QFilter("bill.fieldtable", "=", (Object)entityNumber));
                    builder.add(new QFilter("org.number", "in", numbers));
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryShowControlParam", (String)"eb_controlparameter", (String)"org.number, showebbalance,showcheckmempermission,showbeyondmessage", (QFilter[])builder.toArrays(), null, (int)1);){
                        if (ds != null) {
                            Row row = null;
                            while (ds.hasNext()) {
                                row = ds.next();
                                showBalanceMap.put(row.getString("org.number"), row.getBoolean("showebbalance"));
                                showCheckMemPermissionMap.put(row.getString("org.number"), row.getBoolean("showcheckmempermission"));
                                showBeyondMessageMap.put(row.getString("org.number"), row.getBoolean("showbeyondmessage"));
                            }
                        }
                    }
                    while (!numbers.empty()) {
                        number = (String)numbers.pop();
                        if (!showBalanceMap.containsKey(number) || !showCheckMemPermissionMap.containsKey(number) || !showBeyondMessageMap.containsKey(number)) continue;
                        controlParamMap.put(IS_SHOWBALANCE_STR, (Boolean)showBalanceMap.get(number));
                        controlParamMap.put(IS_SHOWCHECKMEMPERMISSION_STR, (Boolean)showCheckMemPermissionMap.get(number));
                        controlParamMap.put(IS_SHOWBEYONDMESSAGE_STR, (Boolean)showBeyondMessageMap.get(number));
                        break;
                    }
                }
            }
        }
        return controlParamMap;
    }

    public static boolean[] getDefaultParam() {
        boolean[] params = new boolean[]{false, false, false, false};
        return params;
    }

    public static boolean isControl(boolean[] params) {
        if (params != null && params.length > 0) {
            return params[0];
        }
        return false;
    }

    public static boolean isShowBalance(boolean[] params) {
        if (params != null && params.length > 1) {
            return params[1];
        }
        return false;
    }

    public static boolean isShowCheckMemPermission(boolean[] params) {
        if (params != null && params.length > 2) {
            return params[2];
        }
        return false;
    }

    public static boolean isShowBeyondMessage(boolean[] params) {
        if (params != null && params.length > 3) {
            return params[3];
        }
        return false;
    }
}

