/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.control;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.ConvertUtils;

public class ConditionUtils {
    private static final Log log = LogFactory.getLog(ConditionUtils.class);

    public static ConditionUtils get() {
        return new ConditionUtils();
    }

    private ConditionUtils() {
    }

    public boolean run(QFilter filter, QFilterEvaluator evaluator) {
        if (filter == null || evaluator == null) {
            return true;
        }
        return filter.eval((kd.bos.orm.query.QFilterEvaluator)evaluator);
    }

    public FilterBuilder getFilterBuilder(String entityNumber, FilterCondition filterCondition) {
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, true);
        try {
            filterBuilder.buildFilter(false);
        }
        catch (Exception e) {
            log.info("init-condition-error:%s", (Object)e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9884\u8bbe\u6761\u4ef6\u5305\u542b\u4e0d\u652f\u6301\u7684\u6761\u4ef6\u503c\uff0c\u8bf7\u68c0\u67e5", (String)"ConditionUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return filterBuilder;
    }

    public static class QFilterEvaluator
    implements kd.bos.orm.query.QFilterEvaluator {
        private boolean isNullIsZero = false;
        private Map<String, Object> values;

        public QFilterEvaluator setNullIsZero(boolean isNullIsZero) {
            this.isNullIsZero = isNullIsZero;
            return this;
        }

        public void setValues(Map<String, Object> values) {
            this.values = values;
        }

        protected Map<String, Object> getValues() {
            return this.values;
        }

        public boolean eval(QFilter filter) {
            if (filter == null) {
                return false;
            }
            boolean eval = false;
            switch (filter.getCP()) {
                case "=": {
                    eval = this.equalsValue(filter);
                    break;
                }
                case "!=": 
                case "<>": {
                    eval = !this.equalsValue(filter);
                    break;
                }
                case "is null": {
                    eval = this.isNull(filter);
                    break;
                }
                case "is not null": {
                    eval = this.isNotNull(filter);
                    break;
                }
                case ">=": {
                    eval = this.largeEquals(filter);
                    break;
                }
                case ">": {
                    eval = this.largeThan(filter);
                    break;
                }
                case "<=": {
                    eval = this.lessEquals(filter);
                    break;
                }
                case "<": {
                    eval = this.lessThan(filter);
                    break;
                }
                case "in": 
                case "IN": {
                    eval = this.in(filter);
                    break;
                }
                case "not in": 
                case "Not IN": {
                    eval = this.notIn(filter);
                    break;
                }
                case "LIKE": {
                    eval = this.like(filter);
                    break;
                }
                case "lIKE": {
                    eval = this.like(filter);
                    break;
                }
                case "ftlike": 
                case "like": {
                    eval = this.like(filter);
                    break;
                }
                case "LiKe": {
                    eval = this.taskLike(filter);
                    break;
                }
                case "not like": 
                case "NOT LIKE": {
                    eval = !this.like(filter);
                }
            }
            return eval;
        }

        private boolean equalsValue(QFilter filter) {
            Object value = filter.getValue();
            try {
                return ConvertUtils.equalValue(this.getValues().get(filter.getProperty()), value);
            }
            catch (Throwable ex) {
                log.warn("run-largeEquals-expr-error.", ex);
                return false;
            }
        }

        private boolean isNull(QFilter filter) {
            return ConvertUtils.isNull(this.getValues().get(filter.getProperty()));
        }

        private boolean isNotNull(QFilter filter) {
            return !this.isNull(filter);
        }

        private boolean largeEquals(QFilter filter) {
            Object value = filter.getValue();
            try {
                if (this.isNullIsZero && this.getValues().get(filter.getProperty()) == null && value instanceof Number) {
                    return ConvertUtils.compareValue(BigDecimal.ZERO, value) >= 0;
                }
                return ConvertUtils.compareValue(this.getValues().get(filter.getProperty()), value) >= 0;
            }
            catch (Throwable ex) {
                log.warn("run-largeEquals-expr-error.", ex);
                return false;
            }
        }

        private boolean largeThan(QFilter filter) {
            Object value = filter.getValue();
            try {
                if (this.isNullIsZero && this.getValues().get(filter.getProperty()) == null && value instanceof Number) {
                    return ConvertUtils.compareValue(BigDecimal.ZERO, value) > 0;
                }
                return ConvertUtils.compareValue(this.getValues().get(filter.getProperty()), value) > 0;
            }
            catch (Throwable ex) {
                log.warn("run-largeThan-expr-error.", ex);
                return false;
            }
        }

        private boolean lessEquals(QFilter filter) {
            Object value = filter.getValue();
            try {
                if (this.isNullIsZero && this.getValues().get(filter.getProperty()) == null && value instanceof Number) {
                    return ConvertUtils.compareValue(BigDecimal.ZERO, value) <= 0;
                }
                return ConvertUtils.compareValue(this.getValues().get(filter.getProperty()), value) <= 0;
            }
            catch (Throwable ex) {
                log.warn("run-lessEquals-expr-error.", ex);
                return false;
            }
        }

        private boolean lessThan(QFilter filter) {
            Object value = filter.getValue();
            try {
                if (this.isNullIsZero && this.getValues().get(filter.getProperty()) == null && value instanceof Number) {
                    return ConvertUtils.compareValue(BigDecimal.ZERO, value) < 0;
                }
                return ConvertUtils.compareValue(this.getValues().get(filter.getProperty()), value) < 0;
            }
            catch (Throwable ex) {
                log.warn("run-lessThan-expr-error.", ex);
                return false;
            }
        }

        private boolean in(QFilter filter) {
            Object value = filter.getValue();
            try {
                return ConvertUtils.in(this.getValues().get(filter.getProperty()), value);
            }
            catch (Throwable ex) {
                log.warn("run-in-expr-error.", ex);
                return false;
            }
        }

        private boolean notIn(QFilter filter) {
            Object value = filter.getValue();
            try {
                return ConvertUtils.notIn(this.getValues().get(filter.getProperty()), value);
            }
            catch (Throwable ex) {
                log.warn("run-not-in-expr-error.", ex);
                return false;
            }
        }

        private boolean like(QFilter filter) {
            if (filter.getValue() == null) {
                return true;
            }
            Object value2 = this.getValues().get(filter.getProperty());
            String value1 = String.valueOf(filter.getValue());
            String v2 = String.valueOf(value2);
            String v1 = value1.replaceAll("%", "");
            if (!value1.contains("%") || value1.startsWith("%") && value1.endsWith("%")) {
                return ConvertUtils.getIndex(v2, v1) != -1;
            }
            if (value1.startsWith("%")) {
                return v2.endsWith(v1);
            }
            if (value1.endsWith("%")) {
                return v2.startsWith(v1);
            }
            return false;
        }

        private boolean taskLike(QFilter filter) {
            if (filter.getValue() == null) {
                return true;
            }
            Object value2 = this.getValues().get(filter.getProperty());
            String value1 = String.valueOf(filter.getValue());
            String v2 = String.valueOf(value2);
            if (!value1.contains("%") || value1.startsWith("%") && value1.endsWith("%")) {
                return ConvertUtils.getIndex(v2, value1) != -1;
            }
            if (value1.startsWith("%")) {
                return v2.endsWith(value1);
            }
            if (value1.endsWith("%")) {
                return v2.startsWith(value1);
            }
            return false;
        }
    }
}

