/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.control;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerializer;
import kd.epm.eb.common.utils.UserUtils;

public class StartVersionServiceHelper {
    public static final String FIELDS = "id, effectivetime, invalidtime, model.id, model.name, model.number, model.shownumber, model.reporttype, model.creator.id, model.datasource.id, scenario.id, scenario.name, scenario.number, version.id, version.name, version.number, acversion.id, acversion.name, acversion.number, datatype.id, datatype.name, datatype.number, audittrail.id, audittrail.name, audittrail.number,bussmodel.id,bussmodel.name,bussmodel.number";

    public static Collection<Map<String, Object>> queryStartVersion() {
        List<Map<String, Object>> startVersions = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryControlVersion", (String)"eb_controlversion", (String)FIELDS, null, null);){
            startVersions = CommonServiceHelper.transDataSet(ds);
        }
        if (startVersions != null) {
            HashSet<Long> userIds = new HashSet<Long>(10);
            Long id = null;
            for (Map map : startVersions) {
                id = IDUtils.toLong(map.get("model.creator.id"));
                if (!IDUtils.isNotNull(id)) continue;
                userIds.add(id);
            }
            List<UserInfo> users = UserUtils.getUserInfo(userIds, true);
            if (users != null) {
                HashMap<Long, String> hashMap = new HashMap<Long, String>(16);
                for (UserInfo userInfo : users) {
                    hashMap.put(userInfo.getId(), userInfo.getName());
                }
                for (Map map : startVersions) {
                    id = IDUtils.toLong(map.get("model.creator.id"));
                    if (!IDUtils.isNotNull(id)) continue;
                    map.put("model.creator.name", hashMap.get(id));
                }
            }
        }
        return startVersions;
    }

    public static BizModel getBizModel(Map<String, Object> version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        Long modelId = (Long)version.get("model.id");
        if (modelId == null || modelId == 0L) {
            return null;
        }
        DynamicObject model = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epm_model"));
        model.set("id", (Object)modelId);
        model.set("name", version.get("model.name"));
        model.set("number", version.get("model.number"));
        model.set("shownumber", version.get("model.shownumber"));
        model.set("reporttype", version.get("model.reporttype"));
        DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"));
        user.set("id", version.get("model.creator.id"));
        user.set("name", version.get("model.creator.name"));
        model.set("creator", (Object)user);
        DynamicObject dataSource = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epbs_datasource"));
        dataSource.set("id", version.get("model.datasource.id"));
        model.set("datasource", (Object)dataSource);
        BizModel bizModel = new BizModel(model);
        bizModel.setStartVersion(StartVersionServiceHelper.getStartVersion(version));
        return bizModel;
    }

    public static DynamicObject getStartVersion(Map<String, Object> version) {
        DynamicObject startVersion = ObjectSerializer.decoded(version);
        return startVersion;
    }
}

