/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.controlParamsSetting;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;

public class ControlParamsSettingUtil {
    private ControlParamsSettingUtil() {
    }

    public static boolean isOnOrder(Long modelId, String formType) {
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.EB001 : ParamEnum.EB002;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static String getAuditTrail(Long modelId, String formType, boolean isExpenseBudget) {
        Member member;
        String auditTrail = "EntityInput";
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.BG001 : ParamEnum.BG004;
        Long auditId = ParamQueryServiceHelper.getChildLong(modelId, paramEnum, "adjust_small");
        if (IDUtils.isNotEmptyLong(auditId).booleanValue() && (member = ModelCacheContext.getOrCreate(modelId).getMember("AuditTrail", (Long)0L, auditId)) != null) {
            auditTrail = member.getNumber();
        }
        return auditTrail;
    }

    public static String getAuditTrailShow(Long modelId, String formType, boolean isExpenseBudget) {
        Member member;
        String auditTrail = "ATTotal";
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.BG001 : ParamEnum.BG004;
        Long auditId = ParamQueryServiceHelper.getChildLong(modelId, paramEnum, "adjust_show");
        if (IDUtils.isNotEmptyLong(auditId).booleanValue() && (member = ModelCacheContext.getOrCreate(modelId).getMember("AuditTrail", (Long)0L, auditId)) != null) {
            auditTrail = member.getNumber();
        }
        return auditTrail;
    }

    public static boolean isOpenReduceBill(Long modelId) {
        boolean reduceAdjust = ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC001);
        boolean reduceRedistribute = ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC002);
        return reduceAdjust || reduceRedistribute;
    }

    public static boolean isOpenReduceBill(Long modelId, String formType) {
        if ("1".equals(formType)) {
            return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC001);
        }
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC002);
    }

    public static boolean isLockOrgUnit(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC005);
    }

    public static boolean isBalanceCheckOccupation(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BGC004);
    }

    public static Map<Long, Integer> getBalanceCheckPrecisionByModelSet(Set<Long> modelIdSet) {
        HashMap<Long, Integer> modelPrecisionMap = new HashMap<Long, Integer>(16);
        for (Long modelId : modelIdSet) {
            String paramValue = ParamQueryServiceHelper.getString(modelId, ParamEnum.BGC003);
            int number = paramValue == null ? -1 : Integer.parseInt(paramValue);
            if (number < 0) continue;
            modelPrecisionMap.put(modelId, number);
        }
        return modelPrecisionMap;
    }

    public static boolean isShowBudgetBalance(Long modelId, String formType, boolean isExpenseBudget) {
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.BG002 : ParamEnum.BG005;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static boolean isShowLimitBalance(Long modelId, String formType, boolean isExpenseBudget) {
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.BG060 : ParamEnum.BG061;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static boolean adjustAllowNegative(Long modelId, String formType, boolean isExpenseBudget) {
        ParamEnum paramEnum = "1".equals(formType) ? ParamEnum.BG003 : ParamEnum.BG006;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static boolean getUnWeaveReportConfirm(Long modelId) {
        if (IDUtils.isEmptyLong(modelId).booleanValue()) {
            return false;
        }
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG016);
    }

    public static boolean forbidCommitParent(Long modelId) {
        if (IDUtils.isNull(modelId)) {
            return false;
        }
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG055);
    }
}

