/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.CollectionUtils;

public class Convert {
    public static String toStr(Object value, String defaultValue) {
        return Convert.convert(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static String[] toStrArray(Object value) {
        return Convert.convert(String[].class, value);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convert(Character.class, value, defaultValue);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Character[] toCharArray(Object value) {
        return Convert.convert(Character[].class, value);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        return Convert.convert(Number.class, value, defaultValue);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Number[] toNumberArray(Object value) {
        return Convert.convert(Number[].class, value);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convert(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(Object value) {
        return Convert.convert(Integer[].class, value);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convert(Long.class, value, defaultValue);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(Object value) {
        return Convert.convert(Long[].class, value);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convert(Double.class, value, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(Object value) {
        return Convert.convert(Double[].class, value);
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        return Convert.convert(Boolean.class, value, defaultValue);
    }

    public static Boolean toBool(Object value) {
        return Convert.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(Object value) {
        return Convert.convert(Boolean[].class, value);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convert(BigInteger.class, value, defaultValue);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convert(BigDecimal.class, value, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static Date toDate(Object value) {
        return Convert.convert(Date.class, value);
    }

    public static Date toDate(Object value, Date defaultValue) {
        return Convert.convert(Date.class, value, defaultValue);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) {
        T convert;
        if (null == type && null == defaultValue) {
            throw new NullPointerException("epm convert error");
        }
        if (value == null) {
            return defaultValue;
        }
        try {
            convert = Convert.convert(type, value);
        }
        catch (Exception e) {
            if (defaultValue == null) {
                throw e;
            }
            return defaultValue;
        }
        return convert;
    }

    public static <T> T convert(Class<T> type, Object value) {
        return (T)ConvertUtils.convert((Object)value, type);
    }

    public static <K, V> Map<K, V> listToMap(List<V> list, Function<V, K> keyMapper) {
        return Convert.listToMap(list, keyMapper, null);
    }

    public static <K, V> Map<K, V> listToMap(List<V> list, Function<V, K> keyMapper, Function<V, V> valueMapper) {
        return Convert.listToMap(list, keyMapper, valueMapper, null);
    }

    public static <K, V> Map<K, V> listToMap(List<V> list, Function<V, K> keyMapper, Function<V, V> valueMapper, Predicate<V> predicate) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        Stream stream = list.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        if (valueMapper == null) {
            valueMapper = v -> v;
        }
        return stream.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T, R> List<R> resultToList(List<T> originList, Function<T, R> mapper) {
        return Convert.resultToList(originList, mapper, null);
    }

    public static <T, R> List<R> resultToList(List<T> originList, Function<T, R> mapper, Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(originList)) {
            return Collections.emptyList();
        }
        Stream stream = originList.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        return stream.map(mapper).collect(Collectors.toList());
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000' || c[i] == '\u00a0' || c[i] == '\u2007' || c[i] == '\u202f') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return (short)(bytes[1] & 0xFF | (bytes[0] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short shortValue) {
        byte[] b = new byte[2];
        b[1] = (byte)(shortValue & 0xFF);
        b[0] = (byte)(shortValue >> 8 & 0xFF);
        return b;
    }

    public static int bytesToInt(byte[] bytes) {
        return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int intValue) {
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] longToBytes(long longValue) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(longValue & 0xFFL);
            longValue >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes) {
        long values = 0L;
        for (int i = 0; i < 8; ++i) {
            values <<= 8;
            values |= (long)(bytes[i] & 0xFF);
        }
        return values;
    }
}

