/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class BgExcelReader {
    private Workbook wb;
    private Sheet sheet;
    private static BgExcelReader reader;

    private BgExcelReader() {
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public static BgExcelReader getInstance() {
        reader = new BgExcelReader();
        return reader;
    }

    public BgExcelReader readByInputstream(InputStream in) {
        try {
            this.wb = WorkbookFactory.create((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return reader;
    }

    public BgExcelReader readByWorkbook(Workbook wb) {
        this.wb = wb;
        return this;
    }

    public List<List<String>> read(int startRowIndex, int startColIndex, int endColIndex) {
        ArrayList<List<String>> datas = new ArrayList<List<String>>(10);
        this.sheet = this.wb.getSheetAt(0);
        int lastRowNum = this.sheet.getLastRowNum();
        for (int i = startRowIndex; i <= lastRowNum; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            ArrayList<String> rowData = new ArrayList<String>(10);
            for (int j = startColIndex; j <= endColIndex; ++j) {
                Cell cell = row.getCell(j);
                rowData.add(BgExcelReader.cellValueToString(cell));
            }
            datas.add(rowData);
        }
        return datas;
    }

    public List<List<String>> readString(int startRowIndex, int startColIndex, int endColIndex) {
        ArrayList<List<String>> datas = new ArrayList<List<String>>(10);
        this.sheet = this.wb.getSheetAt(0);
        int lastRowNum = this.sheet.getLastRowNum();
        for (int i = startRowIndex; i <= lastRowNum; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            ArrayList<String> rowData = new ArrayList<String>(10);
            boolean needAdd = false;
            for (int j = startColIndex; j <= endColIndex; ++j) {
                Cell cell = row.getCell(j);
                String stringValue = POIUtils.getStringValue(cell);
                if (StringUtils.isNotEmpty(stringValue)) {
                    needAdd = true;
                }
                rowData.add(stringValue);
            }
            if (!needAdd) continue;
            datas.add(rowData);
        }
        return datas;
    }

    private static String cellValueToString(Cell cell) {
        if (cell == null) {
            return null;
        }
        String content = null;
        switch (cell.getCellType()) {
            case NUMERIC: {
                Double doubleValue = cell.getNumericCellValue();
                content = doubleValue.toString();
                break;
            }
            case STRING: {
                content = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                Boolean booleanValue = cell.getBooleanCellValue();
                content = booleanValue.toString();
                break;
            }
            case BLANK: {
                break;
            }
            case FORMULA: {
                content = cell.getCellFormula();
                break;
            }
            case ERROR: {
                break;
            }
        }
        return content;
    }
}

