/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.ebcommon.common.Pair;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class BgExcelWriter {
    private static final Log log = LogFactory.getLog(BgExcelWriter.class);
    private static final String DATA_LINE = "datas";
    private static final String DEFAULT_STYLE = "defaultStyles";
    private static final String STYLE = "styles";
    private static final String SER_NUM = "sernums";
    private static BgExcelWriter writer;
    private Workbook wb;
    private Sheet sheet;
    private int initColIndex;
    private int initRowIndex;
    private int curColIndex;
    private int curRowIndex;
    private Row curRow;
    private CellStyle defaultStyle;
    private float rowHeight = 13.5f;
    private Map<Integer, CellStyle> styles;
    private int serColIndex;

    private BgExcelWriter() {
    }

    public static BgExcelWriter getInstance() {
        writer = new BgExcelWriter();
        return writer;
    }

    public BgExcelWriter readTemplate(Workbook workbook) {
        if (workbook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u9519\u8bef", (String)"BgExcelWriter_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        try {
            this.wb = workbook;
            this.sheet = workbook.getSheetAt(0);
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u9519\u8bef", (String)"BgExcelWriter_2", (String)"epm-eb-common", (Object[])new Object[0]), e);
        }
        this.initTemplate();
        return this;
    }

    public BgExcelWriter readTemplateByClasspath(String path) {
        InputStream inputStream = null;
        try {
            inputStream = BgExcelWriter.class.getClassLoader().getResourceAsStream(path);
            this.wb = WorkbookFactory.create((InputStream)inputStream);
            this.sheet = this.wb.getSheetAt(0);
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgExcelWriter_0", (String)"epm-eb-common", (Object[])new Object[0]), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        this.initTemplate();
        return this;
    }

    public String getDownloadUrl(String fileName) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.wb.write((OutputStream)os);
            return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, os.toByteArray(), 10000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.wb.write((OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Cell createCell(Object value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c, null);
        this.setCellValue(c, value);
        ++this.curColIndex;
        return c;
    }

    public void createRow(List<Pair<CellStyle, Object>> rows) {
        this.createRow();
        for (Pair<CellStyle, Object> row : rows) {
            Cell c = this.curRow.createCell(this.curColIndex);
            if (row.p1 != null) {
                this.setCellStyle(c, (CellStyle)row.p1);
            }
            this.setCellValue(c, row.p2);
            ++this.curColIndex;
        }
    }

    public CellStyle createCellStyle() {
        return this.wb.createCellStyle();
    }

    private void setCellStyle(Cell c, CellStyle style) {
        this.setCellStyle(c, style, this.curColIndex);
    }

    private void setCellStyle(Cell c, CellStyle style, int colIndex) {
        if (style != null) {
            c.setCellStyle(style);
        } else if (this.styles != null && this.styles.containsKey(colIndex)) {
            c.setCellStyle(this.styles.get(colIndex));
        } else {
            c.setCellStyle(this.defaultStyle);
        }
    }

    public int getSheetIndex(String sheetName) {
        return this.wb.getSheetIndex(sheetName);
    }

    public void createRow() {
        this.curRow = this.sheet.createRow(this.curRowIndex);
        this.curRow.setHeightInPoints(this.rowHeight);
        ++this.curRowIndex;
        this.curColIndex = this.initColIndex;
    }

    public void createRow(Object ... cellValues) {
        this.createRow(null, Arrays.asList(cellValues));
    }

    public void createRow(Iterable<?> cellValues) {
        this.createRow(null, cellValues);
    }

    public void createRow(CellStyle style, Object ... cellValues) {
        this.createRow(style, Arrays.asList(cellValues));
    }

    public void createRow(CellStyle style, Iterable<? extends Object> cellValues) {
        this.createRow();
        for (Object object : cellValues) {
            Cell c = this.curRow.createCell(this.curColIndex);
            this.setCellStyle(c, style);
            this.setCellValue(c, object);
            ++this.curColIndex;
        }
    }

    private void setCellValue(Cell c, Object value) {
        if (value == null) {
            c.setCellValue("");
        } else if (value instanceof String) {
            c.setCellValue(value.toString());
        } else if (value instanceof Calendar) {
            c.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            c.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            c.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            c.setCellValue(((Number)value).doubleValue());
        } else {
            c.setCellValue(value.toString());
        }
    }

    public void setStarPosition(int rowIndex, int colIndex) {
        this.initColIndex = colIndex;
        this.initRowIndex = rowIndex;
        this.curColIndex = this.initColIndex;
        this.curRowIndex = this.initRowIndex;
    }

    public void setDropDownBox(String[] values, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return;
        }
        Object dvHelper = this.sheet instanceof XSSFSheet ? new XSSFDataValidationHelper((XSSFSheet)this.sheet) : new HSSFDataValidationHelper((HSSFSheet)this.sheet);
        DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(values);
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
        DataValidation validation = dvHelper.createValidation(dvConstraint, addressList);
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        this.sheet.addValidationData(validation);
    }

    public void insertSer() {
        int index = 1;
        Row row = null;
        Cell c = null;
        for (int i = this.initRowIndex; i < this.curRowIndex; ++i) {
            row = this.sheet.getRow(i);
            c = row.createCell(this.serColIndex);
            this.setCellStyle(c, null, this.serColIndex);
            c.setCellValue((double)index++);
        }
    }

    private void initTemplate() {
        this.initConfigData();
    }

    public void replaceFinalData(Map<String, String> datas) {
        if (datas == null) {
            return;
        }
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellType() != CellType.STRING || !(str = c.getStringCellValue().trim()).startsWith("#") || !datas.containsKey(str.substring(1))) continue;
                c.setCellValue(datas.get(str.substring(1)));
            }
        }
    }

    private void initConfigData() {
        boolean findData = false;
        boolean findSer = false;
        block0: for (Row row : this.sheet) {
            if (findData) break;
            for (Cell c : row) {
                if (c.getCellType() != CellType.STRING) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(SER_NUM)) {
                    this.serColIndex = c.getColumnIndex();
                    findSer = true;
                }
                if (!str.equals(DATA_LINE)) continue;
                this.initColIndex = c.getColumnIndex();
                this.initRowIndex = row.getRowNum();
                this.curColIndex = this.initColIndex;
                this.curRowIndex = this.initRowIndex;
                findData = true;
                this.defaultStyle = c.getCellStyle();
                this.rowHeight = row.getHeightInPoints();
                this.initStyles();
                continue block0;
            }
        }
        if (!findData) {
            this.initStyles();
        }
        if (!findSer) {
            this.initSer();
        }
    }

    private void initSer() {
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellType() != CellType.STRING || !(str = c.getStringCellValue().trim()).equals(SER_NUM)) continue;
                this.serColIndex = c.getColumnIndex();
            }
        }
    }

    private void initStyles() {
        this.styles = new HashMap<Integer, CellStyle>(16);
        for (Row row : this.sheet) {
            for (Cell c : row) {
                if (c.getCellType() != CellType.STRING) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(DEFAULT_STYLE)) {
                    this.defaultStyle = c.getCellStyle();
                }
                if (str.equals(STYLE)) {
                    this.styles.put(c.getColumnIndex(), c.getCellStyle());
                }
                if (!str.equals(SER_NUM)) continue;
                this.styles.put(c.getColumnIndex(), c.getCellStyle());
            }
        }
    }

    public void createSheet(String sheetName) {
        this.sheet = this.wb.createSheet(sheetName);
        this.initColIndex = 0;
        this.initRowIndex = 0;
        this.curColIndex = 0;
        this.curRowIndex = 0;
    }

    public void cloneSheetByTemplate(String sheetName) {
        this.sheet = this.wb.cloneSheet(0);
        this.wb.setSheetName(this.wb.getSheetIndex(this.sheet), sheetName);
        this.initTemplate();
    }

    public void deleteTemplateSheet() {
        this.wb.removeSheetAt(0);
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public void autoSetColumnWidth(int columnSize) {
        for (int i = columnSize; i > 0; --i) {
            this.sheet.autoSizeColumn(i);
        }
    }

    public Map<Integer, CellStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<Integer, CellStyle> styles) {
        this.styles = styles;
    }

    public void setComment(int rowIndex, int colIndex, String commentString) {
        Row row = this.sheet.getRow(rowIndex);
        if (row != null) {
            Cell cell = row.getCell(colIndex);
            if (cell == null) {
                return;
            }
            Drawing drawing = this.sheet.createDrawingPatriarch();
            CreationHelper factory = this.wb.getCreationHelper();
            ClientAnchor anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(row.getRowNum());
            anchor.setCol2(cell.getColumnIndex() + 1);
            anchor.setRow2(row.getRowNum() + 3);
            Comment comment = drawing.createCellComment(anchor);
            RichTextString str = factory.createRichTextString(commentString);
            comment.setString(str);
            cell.setCellComment(comment);
        }
    }
}

