/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.excel;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.AbstractExcelUtils;
import kd.epm.eb.common.utils.excel.CellDropdown;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelImExportUtils
extends AbstractExcelUtils {
    private static final Log log = LogFactory.getLog(ExcelImExportUtils.class);
    private static final ExcelImExportUtils instance = new ExcelImExportUtils();
    private Sheet initSheet = new Sheet(0, 3, 0, 0);

    private ExcelImExportUtils() {
    }

    public static ExcelImExportUtils getInstance() {
        return instance;
    }

    public List<String[]> read(String fileUrl, Sheet sheet) {
        if (StringUtils.isEmpty(fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"CustomPropertyImport_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (sheet == null || sheet.getLastCel() == 0 || sheet.getFirstCel() >= sheet.getLastCel()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u7684\u5c3e\u5217\u4e0d\u80fd\u4e3a0", (String)"ExcelImExportUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        List<InputStream> inputStreams = null;
        ArrayList<String[]> reads = new ArrayList<String[]>(16);
        try {
            inputStreams = this.getInportStreams(fileUrl);
            this.readInputStream(sheet, inputStreams, reads);
        }
        catch (MalformedURLException e) {
            log.error("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a%1", (String)"ExcelImExportUtils_2", (String)"epm-eb-common", (Object[])new Object[]{fileUrl}));
        }
        finally {
            if (inputStreams != null) {
                for (InputStream inputStream : inputStreams) {
                    this.close(inputStream);
                }
            }
        }
        return reads;
    }

    public void readInputStream(Sheet sheet, List<InputStream> inputStreams, List<String[]> reads) {
        int objectSize = sheet.getLastCel() - sheet.getFirstCel();
        List<Workbook> uploadBooks = this.getXSSFWorkbooks(inputStreams);
        for (Workbook uploadBook : uploadBooks) {
            int sheetNum = uploadBook.getNumberOfSheets();
            for (int i = 0; i < sheetNum && uploadBook.getSheetAt(i) != null; ++i) {
                for (int j = sheet.getFirstRow(); j <= uploadBook.getSheetAt(i).getLastRowNum(); ++j) {
                    Row row = uploadBook.getSheetAt(i).getRow(j);
                    if (row == null) continue;
                    boolean isnullrow = true;
                    String[] object = new String[objectSize];
                    int k = sheet.getFirstCel();
                    int m = 0;
                    while (k < sheet.getLastCel()) {
                        String value;
                        Cell cell = row.getCell(k);
                        object[m] = value = this.getStringValue(cell);
                        if (isnullrow && StringUtils.isNotEmpty(value)) {
                            isnullrow = false;
                        }
                        ++k;
                        ++m;
                    }
                    if (isnullrow) continue;
                    reads.add(object);
                }
            }
        }
    }

    private String getStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (CellType.STRING.equals((Object)cell.getCellType())) {
            return cell.getStringCellValue().trim();
        }
        if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        if (CellType.BOOLEAN.equals((Object)cell.getCellType())) {
            return Boolean.toString(cell.getBooleanCellValue());
        }
        return "";
    }

    private List<Workbook> getXSSFWorkbooks(List<InputStream> inputStreams) {
        ArrayList<Workbook> xssFWorkbooks = new ArrayList<Workbook>();
        try {
            for (InputStream inportStream : inputStreams) {
                xssFWorkbooks.add(WorkbookFactory.create((InputStream)inportStream));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863", (String)"ExcelImExportUtils_3", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return xssFWorkbooks;
    }

    private List<InputStream> getInportStreams(String fileURL) throws MalformedURLException {
        if (fileURL == null) {
            return Collections.emptyList();
        }
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        List urls = (List)SerializationUtils.fromJsonString((String)fileURL, List.class);
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(urls.size());
        for (String url : urls) {
            String[] reqParams = new URL(url).getQuery().split("&");
            HashMap map = Maps.newHashMapWithExpectedSize((int)reqParams.length);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
            InputStream inputStream = content.getInputStream();
            inputStreams.add(inputStream);
        }
        return inputStreams;
    }

    public String writeWithTemplate(String tempPath, String fileName, List<String[]> exportData, Sheet sheet) {
        return this.writeWithTemplate(tempPath, fileName, null, exportData, sheet);
    }

    public String writeWithTemplate(String tempPath, String fileName, List<String[]> exportHeadData, List<String[]> exportData, Sheet sheet) {
        return this.writeWithTemplate(tempPath, fileName, exportHeadData, exportData, sheet, null, null);
    }

    public String writeWithTemplateWithError(String tempPath, String fileName, List<String[]> exportHeadData, List<String[]> exportData, Sheet sheet, List<ErrorMark> errorMarkList, List<CellDropdown> cellDropdownList) {
        return this.writeWithTemplate(tempPath, fileName, exportHeadData, exportData, sheet, errorMarkList, cellDropdownList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeWithTemplate(String tempPath, String fileName, List<String[]> exportHeadData, List<String[]> exportData, Sheet sheet, List<ErrorMark> errorMarkList, List<CellDropdown> cellDropdownList) {
        String string;
        if (StringUtils.isEmpty(tempPath)) return null;
        if (StringUtils.isEmpty(fileName)) {
            return null;
        }
        ByteArrayOutputStream outStream = null;
        InputStream tempInStream = null;
        ByteArrayInputStream inStream = null;
        XSSFWorkbook workbook = null;
        try {
            XSSFCell cell1;
            tempInStream = ExcelImExportUtils.class.getClassLoader().getResourceAsStream(tempPath);
            if (tempInStream == null) {
                String string2 = null;
                return string2;
            }
            workbook = new XSSFWorkbook(tempInStream);
            XSSFSheet xssfSheet = workbook.getSheetAt(sheet.getSheetNum());
            if (xssfSheet == null) {
                xssfSheet = workbook.createSheet();
            }
            if (StringUtils.isNotEmpty(sheet.getTitle())) {
                XSSFRow row1 = xssfSheet.getRow(sheet.getTitleRow());
                cell1 = row1.getCell(sheet.getTitleCel());
                cell1.setCellValue(sheet.getTitle());
            }
            if (!StringUtils.isEmpty(sheet.getTip())) {
                XSSFRow row2 = xssfSheet.getRow(sheet.getTipRow());
                cell1 = row2.getCell(sheet.getTipCel());
                cell1.setCellValue(sheet.getTip());
            }
            boolean hasError = CollectionUtils.isNotEmpty(errorMarkList);
            if (CollectionUtils.isNotEmpty(exportHeadData) || CollectionUtils.isNotEmpty(exportData)) {
                int headRow = 0;
                if (exportHeadData != null) {
                    headRow = exportHeadData.size();
                }
                if (hasError) {
                    this.setErrorDataToBook(sheet, errorMarkList, workbook, xssfSheet, headRow);
                }
                if (CollectionUtils.isNotEmpty(exportHeadData)) {
                    this.setHeadDataToBook(xssfSheet, exportHeadData, sheet.getFirstRow(), sheet.getFirstCel(), workbook, sheet);
                }
                if (CollectionUtils.isNotEmpty(cellDropdownList)) {
                    this.setDropdownToBook(sheet, cellDropdownList, xssfSheet, hasError);
                }
                if (CollectionUtils.isNotEmpty(exportData)) {
                    this.setDataToBook(xssfSheet, exportData, sheet.getFirstRow() + headRow, sheet.getFirstCel());
                }
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            this.close(tempInStream);
        }
        catch (Exception e) {
            log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        this.close(outStream);
        this.close(inStream);
        try {
            if (workbook == null) return string;
            workbook.close();
            return string;
        }
        catch (IOException e) {
            log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
        }
        return string;
        finally {
            this.close(tempInStream);
            this.close(outStream);
            this.close(inStream);
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            }
        }
    }

    private void setErrorDataToBook(Sheet sheet, List<ErrorMark> errorMarkList, XSSFWorkbook workbook, XSSFSheet xssfSheet, int headRow) {
        HashMap<Integer, String> errorMarkMap = new HashMap<Integer, String>(16);
        for (ErrorMark errorMark : errorMarkList) {
            errorMarkMap.put(errorMark.getIndex(), errorMark.getErrormsg());
        }
        int firstRow = sheet.getFirstRow();
        XSSFCell cell = xssfSheet.getRow(firstRow).createCell(sheet.getFirstCel());
        cell.setCellType(CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"FileImportUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
        CellStyle style = this.createErrorStype(workbook);
        cell.setCellStyle(style);
        for (Map.Entry entry : errorMarkMap.entrySet()) {
            XSSFRow row = xssfSheet.createRow(firstRow + headRow + (Integer)entry.getKey());
            XSSFCell errorCell = row.createCell(sheet.getFirstCel());
            errorCell.setCellType(CellType.STRING);
            errorCell.setCellValue((String)entry.getValue());
            errorCell.setCellStyle(style);
        }
        sheet.setFirstCel(sheet.getFirstCel() + 1);
    }

    private void setDropdownToBook(Sheet sheet, List<CellDropdown> cellDropdownList, XSSFSheet xssfSheet, boolean hasError) {
        DataValidationHelper dvHelper = xssfSheet.getDataValidationHelper();
        for (CellDropdown cellDropdown : cellDropdownList) {
            CellRangeAddressList addressList;
            int colIndex = hasError ? cellDropdown.getColIndex() + 1 : cellDropdown.getColIndex();
            DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(cellDropdown.getValues());
            DataValidation validation = dvHelper.createValidation(dvConstraint, addressList = new CellRangeAddressList(sheet.getFirstRow() + 1, 99999, colIndex, colIndex));
            if (validation instanceof XSSFDataValidation) {
                validation.setSuppressDropDownArrow(true);
                validation.setShowErrorBox(true);
            } else {
                validation.setSuppressDropDownArrow(false);
            }
            xssfSheet.addValidationData(validation);
        }
    }

    public String writeWithError(String tempPath, String filename, List<String[]> returnDatas, Sheet sheet, List<ErrorMark> errorMarkList) {
        String string;
        XSSFWorkbook workbook;
        ByteArrayInputStream inStream;
        InputStream tempInStream;
        ByteArrayOutputStream outStream;
        block7: {
            if (StringUtils.isEmpty(tempPath) || StringUtils.isEmpty(filename) || returnDatas == null || returnDatas.isEmpty() || errorMarkList == null || errorMarkList.isEmpty()) {
                return null;
            }
            outStream = null;
            tempInStream = null;
            inStream = null;
            workbook = null;
            tempInStream = ExcelImExportUtils.class.getClassLoader().getResourceAsStream(tempPath);
            if (tempInStream != null) break block7;
            String string2 = null;
            this.close(tempInStream);
            this.close((Closeable)workbook);
            this.close(outStream);
            this.close(inStream);
            return string2;
        }
        try {
            workbook = new XSSFWorkbook(tempInStream);
            CellStyle errorStype = this.createErrorStype(workbook);
            XSSFSheet xssfSheet = workbook.getSheetAt(sheet.getSheetNum());
            if (xssfSheet == null) {
                xssfSheet = workbook.createSheet();
            }
            this.setDataToBook(xssfSheet, returnDatas, sheet.getFirstRow(), sheet.getFirstCel(), errorMarkList, errorStype);
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(filename + ".xlsx", (InputStream)inStream, 10000);
        }
        catch (Exception e) {
            try {
                log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(tempInStream);
                this.close((Closeable)workbook);
                this.close(outStream);
                this.close(inStream);
                throw throwable;
            }
        }
        this.close(tempInStream);
        this.close((Closeable)workbook);
        this.close(outStream);
        this.close(inStream);
        return string;
    }

    private void setDataToBook(XSSFSheet xssfSheet, List<String[]> returnDatas, int rowindex, int firstCel, List<ErrorMark> errorMarkList, CellStyle errorStype) {
        int index = 0;
        int firstIndex = rowindex;
        ErrorMark errorMark = errorMarkList.get(index++);
        for (String[] exportDatum : returnDatas) {
            XSSFRow row = xssfSheet.createRow(rowindex);
            if (errorMark != null && errorMark.getIndex() + firstIndex == rowindex) {
                XSSFCell cell = row.createCell(0);
                cell.setCellStyle(errorStype);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(errorMark.getErrormsg());
                errorMark = errorMarkList.size() <= index ? null : errorMarkList.get(index++);
            }
            for (int j = 0; j < exportDatum.length; ++j) {
                XSSFCell cell = row.createCell(j + firstCel);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(exportDatum[j]);
            }
            ++rowindex;
        }
    }

    private CellStyle createErrorStype(XSSFWorkbook errorBook) {
        XSSFCellStyle style = errorBook.createCellStyle();
        XSSFFont font = errorBook.createFont();
        font.setColor((short)10);
        style.setFont((Font)font);
        return style;
    }

    private void setDataToBook(XSSFSheet firstSheet, List<String[]> exportData, int rowindex, int firstCel) {
        for (String[] exportDatum : exportData) {
            XSSFRow row = firstSheet.getRow(rowindex);
            if (row == null) {
                row = firstSheet.createRow(rowindex);
            }
            for (int j = 0; j < exportDatum.length; ++j) {
                XSSFCell cell = row.createCell(j + firstCel);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(exportDatum[j]);
            }
            ++rowindex;
        }
    }

    private void setHeadDataToBook(XSSFSheet firstSheet, List<String[]> exportHeadData, int rowindex, int firstCel, XSSFWorkbook workbook, Sheet sheet) {
        int firstRow = firstSheet.getFirstRowNum();
        int lastRow = firstSheet.getLastRowNum();
        short firstCell = 0;
        short lastCell = 0;
        for (String[] exportDatum : exportHeadData) {
            XSSFRow row = null;
            if (firstRow <= rowindex && rowindex <= lastRow) {
                row = firstSheet.getRow(rowindex);
            }
            if (row == null) {
                row = firstSheet.createRow(rowindex);
            }
            firstCell = row.getFirstCellNum();
            lastCell = row.getLastCellNum();
            for (int j = 0; j < exportDatum.length; ++j) {
                XSSFCell cell = null;
                if (firstCell <= j && j <= lastCell) {
                    cell = row.getCell(j + firstCel);
                }
                if (cell == null) {
                    cell = row.createCell(j + firstCel);
                }
                cell.setCellType(CellType.STRING);
                cell.setCellValue(exportDatum[j]);
                this.setFontColor(workbook, sheet, cell);
            }
            ++rowindex;
        }
    }

    public void download(IFormView view, String url) {
        if (view == null || url == null) {
            return;
        }
        if (StringUtils.isNotEmpty(url)) {
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private void setFontColor(XSSFWorkbook workbook, Sheet sheet, XSSFCell cell) {
        XSSFCellStyle style = workbook.createCellStyle();
        if (null != sheet.getFontCoror() && cell.getStringCellValue().contains("*")) {
            XSSFFont font = workbook.createFont();
            font.setColor(sheet.getFontCoror().shortValue());
            style.setFont((Font)font);
            cell.setCellStyle((CellStyle)style);
        } else if (null != sheet.getFontCoror()) {
            XSSFFont font = workbook.createFont();
            font.setColor(XSSFFont.DEFAULT_FONT_COLOR);
            style.setFont((Font)font);
            cell.setCellStyle((CellStyle)style);
        }
    }

    public static class ErrorMark {
        private int index;
        private String errormsg;

        public ErrorMark(int index, String errormsg) {
            this.index = index;
            this.errormsg = errormsg;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getErrormsg() {
            return this.errormsg;
        }

        public void setErrormsg(String errormsg) {
            this.errormsg = errormsg;
        }
    }

    public static class Sheet {
        private int sheetNum;
        private int firstRow;
        private int firstCel;
        private int lastCel;
        private Short fontCoror;
        private String title;
        private String tip;
        private int titleRow = 0;
        private int titleCel = 0;
        private int tipRow = 1;
        private int tipCel = 0;

        public Sheet(int sheetNum, int firstRow, int firstCel) {
            this.sheetNum = sheetNum;
            this.firstRow = firstRow;
            this.firstCel = firstCel;
        }

        public Sheet(int sheetNum, int firstRow, int firstCel, int lastCel) {
            this.sheetNum = sheetNum;
            this.firstRow = firstRow;
            this.firstCel = firstCel;
            this.lastCel = lastCel;
        }

        public Sheet(int sheetNum, int firstRow, int firstCel, int lastCel, Short fontCoror) {
            this.sheetNum = sheetNum;
            this.firstRow = firstRow;
            this.firstCel = firstCel;
            this.lastCel = lastCel;
            this.fontCoror = fontCoror;
        }

        public void setTitlePosition(int titleRow, int titleCel) {
            this.titleRow = titleRow;
            this.titleCel = titleCel;
        }

        public void setTipPosition(int tipRow, int tipCel) {
            this.tipRow = tipRow;
            this.tipCel = tipCel;
        }

        public int getSheetNum() {
            return this.sheetNum;
        }

        public void setSheetNum(int sheetNum) {
            this.sheetNum = sheetNum;
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        public void setFirstRow(int firstRow) {
            this.firstRow = firstRow;
        }

        public int getFirstCel() {
            return this.firstCel;
        }

        public void setFirstCel(int firstCel) {
            this.firstCel = firstCel;
        }

        public int getLastCel() {
            return this.lastCel;
        }

        public void setLastCel(int lastCel) {
            this.lastCel = lastCel;
        }

        public Short getFontCoror() {
            return this.fontCoror;
        }

        public void setFontCoror(Short fontCoror) {
            this.fontCoror = fontCoror;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public int getTitleRow() {
            return this.titleRow;
        }

        public void setTitleRow(int titleRow) {
            this.titleRow = titleRow;
        }

        public int getTitleCel() {
            return this.titleCel;
        }

        public void setTitleCel(int titleCel) {
            this.titleCel = titleCel;
        }

        public int getTipRow() {
            return this.tipRow;
        }

        public void setTipRow(int tipRow) {
            this.tipRow = tipRow;
        }

        public int getTipCel() {
            return this.tipCel;
        }

        public void setTipCel(int tipCel) {
            this.tipCel = tipCel;
        }
    }
}

