/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.excel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WriteExcelUtil {
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void writeExcel(IFormView view, List<List<String>> dataList, String name) {
        try {
            HSSFWorkbook workBook = null;
            if (StringUtils.substringAfterLast((String)name, (String)".").equals(EXCEL_XLS)) {
                workBook = new HSSFWorkbook();
            }
            if (StringUtils.substringAfterLast((String)name, (String)".").equals(EXCEL_XLSX)) {
                workBook = new XSSFWorkbook();
            }
            if (workBook == null) {
                return;
            }
            workBook.createSheet();
            workBook.setSheetName(0, "Sheet1");
            Sheet sheet = workBook.getSheetAt(0);
            for (int j = 0; j < dataList.size(); ++j) {
                Row row = sheet.createRow(j);
                List<String> data = dataList.get(j);
                for (int k = 0; k < data.size(); ++k) {
                    Cell first = row.createCell(k);
                    if (data.get(k) == null) continue;
                    first.setCellValue(data.get(k));
                }
            }
            String url = WriteExcelUtil.writeFile((Workbook)workBook, name);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void downFile(IFormView formView, Workbook wb, String fileName) {
        if (fileName != null) {
            if (wb instanceof XSSFWorkbook && fileName.endsWith(EXCEL_XLS)) {
                fileName = fileName.replace(EXCEL_XLS, EXCEL_XLSX);
            } else if (wb instanceof HSSFWorkbook && fileName.endsWith(EXCEL_XLSX)) {
                fileName = fileName.replace(EXCEL_XLSX, EXCEL_XLS);
            }
        }
        String fileUrl = WriteExcelUtil.writeFile(wb, fileName);
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)fileUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeFile(Workbook wb, String fileName) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            wb.write((OutputStream)os);
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, os.toByteArray(), 10000);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void moveColumns(Sheet sheet, int beginColIndex, int size) {
        if (sheet != null && beginColIndex >= 0) {
            List mergedRegions = sheet.getMergedRegions();
            if (mergedRegions.size() > 0) {
                ArrayList<Integer> regionsIndexs = new ArrayList<Integer>(mergedRegions.size());
                for (int i = 0; i < mergedRegions.size(); ++i) {
                    regionsIndexs.add(i);
                }
                sheet.removeMergedRegions(regionsIndexs);
            }
            int maxCol = 0;
            for (Row row : sheet) {
                Iterator iter = row.cellIterator();
                while (iter.hasNext()) {
                    Cell cell = (Cell)iter.next();
                    if (cell.getCellType() != CellType.FORMULA) continue;
                    cell.removeFormula();
                }
                short colCount = row.getLastCellNum();
                if (maxCol >= colCount) continue;
                maxCol = colCount;
            }
            sheet.shiftColumns(beginColIndex, maxCol, size);
            for (int colIndex = maxCol; colIndex >= beginColIndex; --colIndex) {
                int columnWidth = sheet.getColumnWidth(colIndex);
                sheet.setColumnWidth(colIndex + size, columnWidth);
            }
        }
    }

    public static Row getOrCreateRow(int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static CellStyle createCellStyle(Workbook workbook, short backColor, short fontColor) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(backColor);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font font = workbook.createFont();
        font.setColor(fontColor);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle createCellStyle(Workbook workbook, short backColor, short fontColor, int borderSign, BorderStyle borderStyle) {
        CellStyle cellStyle = WriteExcelUtil.createCellStyle(workbook, backColor, fontColor);
        if (borderSign != 0) {
            if (borderSign % 2 == 0) {
                cellStyle.setBorderTop(borderStyle);
            }
            if (borderSign % 3 == 0) {
                cellStyle.setBorderBottom(borderStyle);
            }
            if (borderSign % 5 == 0) {
                cellStyle.setBorderLeft(borderStyle);
            }
            if (borderSign % 7 == 0) {
                cellStyle.setBorderRight(borderStyle);
            }
        }
        return cellStyle;
    }
}

