/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.excelImport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.IUploadAfter;
import kd.epm.eb.common.utils.excelImport.IUploadBefore;
import kd.epm.eb.common.utils.excelImport.IUploadHandle;
import org.apache.commons.collections4.CollectionUtils;

public class FileImportUtils {
    private static final Log log = LogFactory.getLog(FileImportUtils.class);
    public static final String FILE_UPLOAD_URLS = "file_upload_urls";
    public static final String FILE_UPLOAD_COVERAGE = "file_upload_coverage";
    public static final String FILE_UID = "uid";
    public static final String FILE_SIZE = "size";
    public static final String FILE_URL = "url";

    public static void registerUploadListener(AbstractFormPlugin plugin, UploadListener listener, String uploadAp) {
        if (plugin == null || listener == null || uploadAp == null) {
            return;
        }
        AttachmentPanel attach = (AttachmentPanel)plugin.getControl(uploadAp);
        attach.addUploadListener(listener);
    }

    public static void uploadFileUrls(AbstractFormPlugin view, Object[] urls) {
        if (view == null || urls == null) {
            return;
        }
        String cacheKey = view.getPageCache().get(FILE_UPLOAD_URLS);
        List fileUrls = cacheKey == null ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheKey);
        fileUrls.add(urls);
        view.getPageCache().put(FILE_UPLOAD_URLS, SerializationUtils.serializeToBase64((Object)fileUrls));
    }

    public static void removeFileUrls(AbstractFormPlugin view, Object[] urls) {
        if (view == null || urls == null) {
            return;
        }
        String cacheKey = view.getPageCache().get(FILE_UPLOAD_URLS);
        List fileUrls = cacheKey == null ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheKey);
        Map urlMap = null;
        String fileId = null;
        String fileUrl = null;
        Integer fileSize = null;
        if (urls[0] instanceof Map) {
            urlMap = (Map)urls[0];
            fileId = (String)urlMap.get(FILE_UID);
            fileUrl = (String)urlMap.get(FILE_URL);
            fileSize = (Integer)urlMap.get(FILE_SIZE);
        }
        if (urlMap != null) {
            ArrayList removes = Lists.newArrayList();
            for (Object[] file : fileUrls) {
                if (!(file[0] instanceof Map)) continue;
                Map fileMap = (Map)file[0];
                String _fileId = (String)fileMap.get(FILE_UID);
                String _fileUrl = (String)fileMap.get(FILE_URL);
                Integer _fileSize = (Integer)fileMap.get(FILE_SIZE);
                if (fileId == null || !fileId.equals(_fileId) || fileUrl == null || !fileUrl.equals(_fileUrl) || fileSize == null || _fileSize == null || fileSize.compareTo(_fileSize) != 0) continue;
                removes.add(file);
            }
            if (!removes.isEmpty()) {
                fileUrls.removeAll(removes);
                view.getPageCache().put(FILE_UPLOAD_URLS, SerializationUtils.serializeToBase64(fileUrls));
            }
        }
    }

    public static void handleUpload(IPageCache pageCache, IUploadBefore before, IUploadHandle handle, IUploadAfter after) {
        if (pageCache == null || handle == null) {
            return;
        }
        String uploadCache = pageCache.get(FILE_UPLOAD_URLS);
        List fileUrls = new ArrayList(16);
        if (StringUtils.isNotEmpty(uploadCache)) {
            fileUrls = (List)SerializationUtils.deSerializeFromBase64((String)uploadCache);
        }
        if (CollectionUtils.isEmpty(fileUrls)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"DimMappingImportPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FileImportUtils.handleUpload(uploadCache, before, handle, after);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleUpload(String uploadCache, IUploadBefore before, IUploadHandle handle, IUploadAfter after) {
        if (uploadCache == null || handle == null) {
            return;
        }
        LinkedHashMap configMap = Maps.newLinkedHashMap();
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        List file_urls = (List)SerializationUtils.deSerializeFromBase64((String)uploadCache);
        if (file_urls == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMappingImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (before != null) {
            before.before();
        }
        Iterator iterator = file_urls.iterator();
        while (iterator.hasNext()) {
            Object[] file;
            for (Object actFile : file = (Object[])iterator.next()) {
                Map fileMap = (Map)actFile;
                if (fileMap == null) continue;
                String _url = (String)fileMap.get(FILE_URL);
                try {
                    String[] reqParams = new URL(_url).getQuery().split("&");
                    configMap.clear();
                    for (String reqParam : reqParams) {
                        String[] _param = reqParam.split("=");
                        configMap.put(_param[0], _param[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)configMap.get("configKey"), (String)configMap.get("id"));
                    if (content == null) continue;
                    InputStream inputStream = null;
                    try {
                        inputStream = content.getInputStream();
                        handle.handle(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (MalformedURLException e) {
                    log.error(e.getMessage());
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        if (after != null) {
            after.after();
        }
    }
}

