/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.lock.LockConsumer;
import kd.epm.eb.common.utils.lock.LockHandler;
import org.jetbrains.annotations.NotNull;

public class Lock {
    private static final Log log = LogFactory.getLog(Lock.class);
    public static final String LOCK_TYPE_CONTROL = "budget/control";
    public static final String LOCK_TYPE_AUDIT = "audit/control";
    public static final String LOCK_TYPE_ADJUSTEXTERNAL = "AdjustExternalInvokeServiceImpl/control";
    public static final long DEFAULT_LOCK_KEY = 0L;
    public static final long CONTROL_LOCK_KEY = 9009L;
    public static final long AUDIT_DEFAULT_LOCK_KEY = 8888L;
    public static final long AUDIT_LOCK_KEY = 9999L;
    public static final long MAX_LOCK_TIME = 30000L;
    public static final long AUDIT_MAX_LOCK_TIME = 5000L;

    public static String getLockKey(String lockType) {
        String lockKey = String.valueOf(0L);
        if (LOCK_TYPE_CONTROL.equals(lockType)) {
            lockKey = String.valueOf(9009L);
        }
        return lockKey;
    }

    public static void getLockErrorMessage(String lockType) throws KDBizException {
        if (LOCK_TYPE_CONTROL.equals(lockType)) {
            ControlException.errorControlLock();
        } else {
            ControlException.errorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DLock> doLock(LockHandler handler) {
        String _lockType;
        if (handler == null) {
            throw new KDBizException("error lock parameter. LockHandler is null.");
        }
        Object obj = handler.beforeLock();
        if (handler.getStats() != null) {
            handler.getStats().addInfo("begin-try-Dlock.");
        }
        if (StringUtils.isEmpty(_lockType = handler.getLockType())) {
            throw new KDBizException("error lock key.");
        }
        Map<Long, Set<Long>> allLockKeys = handler.getLockKeys();
        HashSet<String> lockKeySet = new HashSet<String>(10);
        boolean isLocked = false;
        if (allLockKeys != null && !allLockKeys.isEmpty()) {
            for (Map.Entry<Long, Set<Long>> arrayList : allLockKeys.entrySet()) {
                String string = "eb/" + _lockType + "/" + arrayList.getKey();
                Set<Long> _lockKeys = arrayList.getValue();
                if (_lockKeys != null && !_lockKeys.isEmpty()) {
                    Long lastTimestamp;
                    DLock lock = null;
                    try {
                        lock = DLock.create((String)string);
                        isLocked = lock.tryLock(120000L);
                        if (!isLocked) {
                            Lock.getLockErrorMessage(string);
                        }
                    }
                    finally {
                        if (lock != null && isLocked) {
                            lock.unlock();
                            lock.close();
                        }
                    }
                    Long thisTimeStamp = handler.getLockTimestamps().get(arrayList.getKey());
                    if (thisTimeStamp == null) {
                        thisTimeStamp = 0L;
                    }
                    if (!thisTimeStamp.equals(lastTimestamp = CacheServiceHelper.get(string, Long.class))) {
                        Lock.waitAllUnLock(handler, string);
                    }
                    CacheServiceHelper.put(string, thisTimeStamp);
                    for (Long key : _lockKeys) {
                        lockKeySet.add(string + "/" + key);
                    }
                    continue;
                }
                Long lastTimestamp = CacheServiceHelper.get(string, Long.class);
                if (lastTimestamp != null) {
                    Lock.waitAllUnLock(handler, string);
                }
                CacheServiceHelper.remove(string);
                lockKeySet.add(string);
            }
        }
        log.info("budget-control-lock-log : Lock-doLock-lockKeySet=" + JSONUtils.toString(lockKeySet));
        ArrayList<DLock> dlockList = new ArrayList<DLock>(lockKeySet.size());
        try {
            for (String string : lockKeySet) {
                DLock lock = DLock.create((String)string);
                if (!lock.tryLock(30000L)) {
                    log.info("lock-tryLock-error:" + string);
                    Lock.getLockErrorMessage(_lockType);
                    continue;
                }
                dlockList.add(lock);
            }
            log.info("budget-control-lock-log : Lock-doLock-end-tryLock-timestamp=" + JSONUtils.toString(handler.getLockTimestamps()));
            if (handler.getStats() != null) {
                handler.getStats().add("end-try-Dlock.");
            }
            try {
                Throwable throwable = null;
                try (TXHandle tXHandle = TX.requiresNew((String)("eb/" + _lockType + "/txhandle"));){
                    try {
                        if (handler.getStats() != null) {
                            handler.getStats().addInfo("begin-try-Dblock.");
                        }
                        Lock.dbLock(allLockKeys);
                        if (handler.getStats() != null) {
                            handler.getStats().add("end-try-Dblock.");
                        }
                        long st = System.currentTimeMillis();
                        handler.lockDo(obj);
                        log.info("budget-control-lock-log : Lock-lockDo-useTime:" + (System.currentTimeMillis() - st) + ".ms");
                    }
                    catch (Throwable ex) {
                        tXHandle.markRollback();
                        throw ex;
                    }
                }
                catch (Throwable ex) {
                    Throwable throwable2 = ex;
                    throw ex;
                }
            }
            finally {
                for (DLock dLock : dlockList) {
                    dLock.unlock();
                }
            }
            ArrayList<DLock> arrayList = dlockList;
            return arrayList;
        }
        finally {
            for (DLock dlock : dlockList) {
                try {
                    dlock.close();
                }
                catch (Throwable e) {
                    log.info("lock-close-error:", (Object)e);
                }
            }
        }
    }

    private static void waitAllUnLock(LockHandler handler, String _lockMainKey) {
        DLock lock = DLock.create((String)_lockMainKey);
        try {
            if (!lock.tryLock(120000L)) {
                Lock.getLockErrorMessage(_lockMainKey);
            }
            Lock.waitAllUnLockInner(handler, _lockMainKey);
        }
        finally {
            if (lock != null) {
                lock.unlock();
                lock.close();
            }
        }
    }

    private static void waitAllUnLockInner(LockHandler handler, String _lockMainKey) {
        Map allLocks = DLock.getAllLockInfo();
        if (allLocks != null && !allLocks.isEmpty()) {
            if (handler.getStats() != null) {
                handler.getStats().add("begin-wait-all-unlock");
            }
            log.info("budget-control-lock-log : begin-wait-all-unlock");
            ArrayList locklist = new ArrayList(allLocks.values());
            locklist.sort((o1, o2) -> o1.getCreateTime().compareTo(o2.getCreateTime()));
            boolean hasWaiting = false;
            for (DLockInfo lockInfo : locklist) {
                if (!lockInfo.getKey().startsWith(_lockMainKey + "/")) continue;
                if (lockInfo.getWaitingLocks() > 0) {
                    hasWaiting = true;
                }
                log.info("budget-control-lock-log : wait-unlock=" + lockInfo.getKey() + " waiting=" + lockInfo.getWaitingLocks());
                DLock lock1 = DLock.create((String)lockInfo.getKey());
                Throwable throwable = null;
                try {
                    if (!lock1.tryLock(120000L)) {
                        Lock.getLockErrorMessage(_lockMainKey);
                        continue;
                    }
                    lock1.unlock();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lock1 == null) continue;
                    if (throwable != null) {
                        try {
                            lock1.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lock1.close();
                }
            }
            if (handler.getStats() != null) {
                handler.getStats().add("end-wait-all-unlock");
            }
            log.info("budget-control-lock-log : end-wait-all-unlock");
            if (hasWaiting) {
                Lock.waitAllUnLockInner(handler, _lockMainKey);
            }
        }
    }

    public static boolean lock(@NotNull LockConsumer handler, @NotNull String lockKey, long outTime) {
        boolean getLock;
        block21: {
            boolean consumerError = false;
            getLock = true;
            try (DLock lock = DLock.create((String)("eb/" + lockKey));){
                if (lock.tryLock(outTime)) {
                    try {
                        handler.handler();
                        break block21;
                    }
                    catch (Throwable e) {
                        consumerError = true;
                        throw e;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                getLock = false;
            }
            catch (Throwable e) {
                if (consumerError) {
                    throw e;
                }
                getLock = false;
            }
        }
        return getLock;
    }

    public static void dbLock(@NotNull Long lockMainKey, Set<Long> lockKeys) {
    }

    public static void dbLock(Map<Long, Set<Long>> lockKeys) {
        if (lockKeys == null || lockKeys.isEmpty()) {
            return;
        }
        HashSet<Long> keys = new HashSet<Long>(10);
        for (Map.Entry<Long, Set<Long>> entry : lockKeys.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                keys.add(entry.getKey());
                continue;
            }
            keys.addAll((Collection)entry.getValue());
        }
        ArrayList<Object> keyList = new ArrayList<Object>(keys);
        List<Map<String, Object>> ids = SqlBatchUtils.batchQuery("select fid from t_eb_transaction where fid in(" + SqlBatchUtils.getBatchParamsSql(1000) + ")", keyList);
        for (Map<String, Object> map : ids) {
            keys.remove(IDUtils.toLong(map.get("fid")));
        }
        ArrayList params = new ArrayList(keys.size());
        if (!keys.isEmpty()) {
            keys.forEach(f -> params.add(new Object[]{f}));
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_transaction (fid, fcount)  select a.fid, a.fcount FROM  (select fid, fcount from t_eb_transaction UNION select ?, count(fid) from t_eb_transaction) as a  where a.fid not in (select fid from t_eb_transaction)", params);
        }
        params.clear();
        keyList.forEach(f -> params.add(new Object[]{f}));
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_transaction set fcount = fcount + 1 where fid = ?", params);
    }
}

