/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.lock;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dlock.DLock;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.lock.Lock;

public abstract class LockHandler {
    private List<DLock> locks = null;
    private boolean isNeedLock = false;

    public void setNeedLock(boolean isNeedLock) {
        this.isNeedLock = isNeedLock;
    }

    public abstract String getLockType();

    public abstract Map<Long, Set<Long>> getLockKeys();

    public abstract Map<Long, Long> getLockTimestamps();

    public void tryLock() {
        if (this.isNeedLock) {
            this.locks = Lock.doLock(this);
        }
    }

    public void unLock() {
        if (this.locks != null) {
            for (DLock lock : this.locks) {
                lock.unlock();
            }
            this.locks = null;
        }
    }

    public LogStats getStats() {
        return null;
    }

    public abstract void handler();

    public abstract Object beforeLock();

    public abstract void lockDo(Object var1);
}

