/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.member;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import org.jetbrains.annotations.NotNull;

public class EntityServiceHelper {
    public static Set<Long> getOffsetEntityId(@NotNull IModelCacheHelper modelCacheHelper, @NotNull Long busModelId) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        Long dimensionId = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getId();
        Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(busModelId, SysDimensionEnum.Entity.getNumber());
        Set<Long> permissions = DimMembPermHelper.getPermMemberIds(SysDimensionEnum.Entity.getNumber(), modelId, busModelId, viewId, DimMembPermType.READ, true);
        if (permissions != null && permissions.size() > 1000) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t.fmemberid from t_eb_viewmember t ", new Object[0]);
            sql.append(" where exists (select c.fid from t_eb_viewmember c where t.fid = c.fparentid and c.fmodelid = ? and c.fviewid = ? and c.fdimensionid = ? and c.fisoffsetentry = '1')", new Object[]{modelId, viewId, dimensionId});
            sql.append(" and t.fmodelid = ? and t.fviewid = ? and t.fdimensionid = ?", new Object[]{modelId, viewId, dimensionId});
            LinkedHashSet cslOrgIds = Sets.newLinkedHashSet();
            try (DataSet ds = DB.queryDataSet((String)"queryMemberId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        cslOrgIds.add(row.getLong("fmemberid"));
                    }
                }
            }
            permissions.retainAll(cslOrgIds);
        }
        return permissions;
    }
}

