/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.obj;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.StringUtils;

public class ObjectFilter {
    private Set<String> propertys = new LinkedHashSet<String>();

    public DynamicObject filterObject(DynamicObject model, QFilter[] filters, boolean createNew) {
        DynamicObject _model = model;
        if (createNew) {
            try {
                _model = ObjectFilter.copyFrom(model);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.filterObject(_model, filters);
        return _model;
    }

    protected void filterObject(DynamicObject model, QFilter[] filters) {
        this.initPorps(filters);
        this.filterObject(model, new HashMap<String, Object>(), filters, null);
    }

    private void initPorps(QFilter[] filters) {
        this.propertys.clear();
        for (QFilter filter : filters) {
            String[] subProps = filter.getProperty().trim().split("[.]");
            StringBuilder p = new StringBuilder(subProps[0]);
            this.addSubProps(p.toString());
            for (int j = 1; j < subProps.length; ++j) {
                p.append(".").append(subProps[j].trim());
                this.addSubProps(p.toString());
            }
        }
    }

    private void addSubProps(String property) {
        this.propertys.add(property);
    }

    protected boolean filterObject(DynamicObject model, Map<String, Object> values, QFilter[] filters, String preProp) {
        String property;
        if (model == null || model.getDataEntityType() == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u4e1a\u52a1\u52a8\u6001\u5bf9\u8c61\u6216\u8005\u4e1a\u52a1\u5bf9\u8c61\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ObjectFilter_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (values == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u503c\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"ObjectFilter_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        this.clearObjectValueMap(values, preProp);
        String propName = null;
        IDataEntityType dt = model.getDataEntityType();
        for (IDataEntityProperty prop : dt.getProperties()) {
            if (prop == null || !StringUtils.isNotEmpty(prop.getName()) || this.isFilterProp(property = (StringUtils.isEmpty(preProp) ? "" : preProp + ".") + prop.getName())) continue;
            Object obj = model.get(prop.getName());
            if (obj instanceof DynamicObject) {
                values.put(property, obj);
                this.filterObject((DynamicObject)obj, values, filters, property);
                continue;
            }
            if (obj instanceof DynamicObjectCollection) {
                if (propName == null) {
                    propName = prop.getName();
                    continue;
                }
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u9884\u7b97\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u4f7f\u7528\u4e86\u4e24\u4e2a\u6216\u8005\u4ee5\u4e0a\u7684\u6570\u636e\u96c6\u5408\u5173\u7cfb\u3002", (String)"ObjectFilter_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            if (obj == null) continue;
            values.put(property, obj);
        }
        if (propName != null) {
            property = (StringUtils.isEmpty(preProp) ? "" : preProp + ".") + propName;
            boolean filter = this.filterByRule(values, filters, preProp);
            if (!filter) {
                return false;
            }
            DynamicObjectCollection removes = new DynamicObjectCollection();
            DynamicObjectCollection colls = (DynamicObjectCollection)model.get(propName);
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                DynamicObject object = (DynamicObject)colls.get(i);
                values.put(property, object);
                filter = this.filterObject(object, values, filters, property);
                if (filter) continue;
                removes.add((Object)object);
            }
            if (!removes.isEmpty()) {
                colls.removeAll((Collection)removes);
            }
        } else {
            return this.filterByRule(values, filters, null);
        }
        return true;
    }

    private void clearObjectValueMap(Map<String, Object> values, String preProp) {
        if (values == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u503c\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"ObjectFilter_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty(preProp)) {
            values.clear();
        } else {
            String _preProp = preProp + ".";
            for (String key : values.keySet()) {
                if (key == null || !key.startsWith(_preProp)) continue;
                values.put(key, null);
            }
        }
    }

    private boolean isFilterProp(String property) {
        return !this.propertys.contains(property);
    }

    protected boolean filterByRule(Map<String, Object> values, QFilter[] filters, String preProp) {
        return true;
    }

    public static DynamicObject copyFrom(DynamicObject object) {
        if (object == null) {
            throw new NullPointerException("model is null.");
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)object, (boolean)true, (boolean)false);
    }
}

