/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.obj;

import java.math.BigDecimal;
import java.text.Collator;
import kd.bos.exception.KDBizException;

public class ObjectMatcher {
    public static boolean equalObj(Object src, Object dist) {
        if (src == dist) {
            return true;
        }
        if (src == null || dist == null) {
            return false;
        }
        boolean check = false;
        if (src instanceof BigDecimal && dist instanceof BigDecimal) {
            BigDecimal _srcNumber = (BigDecimal)src;
            BigDecimal _distNumber = (BigDecimal)dist;
            check = _srcNumber.compareTo(_distNumber) == 0;
        } else if (src instanceof Integer && dist instanceof Integer) {
            Integer _srcInteger = (Integer)src;
            Integer _distInteger = (Integer)dist;
            check = _srcInteger.compareTo(_distInteger) == 0;
        } else if (src instanceof String && dist instanceof String) {
            String _srcString = (String)src;
            String _distString = (String)dist;
            check = _srcString.equals(_distString);
        } else if (src instanceof Boolean && dist instanceof Boolean) {
            Boolean _srcBoolean = (Boolean)src;
            Boolean _distBoolean = (Boolean)dist;
            check = _srcBoolean != false && _distBoolean != false;
        } else if (src instanceof Comparable && src.getClass().isAssignableFrom(dist.getClass())) {
            check = ((Comparable)src).compareTo(dist) == 0;
        } else if (dist instanceof Comparable && dist.getClass().isAssignableFrom(src.getClass())) {
            check = ((Comparable)dist).compareTo(src) == 0;
        }
        return check;
    }

    public static boolean like(Object value, Object ruleValue) {
        if (value == null || ruleValue == null) {
            return false;
        }
        boolean check = false;
        if (value instanceof String && ruleValue instanceof String) {
            String _value = (String)value;
            String _ruleValue = (String)ruleValue;
            if (_ruleValue.indexOf("%") < 0 || _ruleValue.startsWith("%") && _ruleValue.endsWith("%")) {
                check = _value.indexOf(_ruleValue) > -1;
            } else if (_ruleValue.startsWith("%") && !_ruleValue.endsWith("%")) {
                check = _value.endsWith(ObjectMatcher.getValOfLike(_ruleValue));
            } else if (!_ruleValue.startsWith("%") && _ruleValue.endsWith("%")) {
                check = _value.startsWith(ObjectMatcher.getValOfLike(_ruleValue));
            }
        }
        return check;
    }

    public static String getValOfLike(String val) {
        if (val.startsWith("%")) {
            val = val.substring(1);
        }
        if (val.endsWith("%")) {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    public static boolean greaterThan(Object value, Object ruleValue) throws KDBizException {
        if (value == null) {
            throw new KDBizException("value is null");
        }
        if (ruleValue == null) {
            throw new KDBizException("ruleValue is null");
        }
        boolean check = false;
        if (value instanceof Number && ruleValue instanceof Number) {
            Number _value = (Number)value;
            Number _ruleValue = (Number)ruleValue;
            check = _value.doubleValue() > _ruleValue.doubleValue();
        } else if (value instanceof String && ruleValue instanceof String) {
            String _valueStr = (String)value;
            String _ruleValueStr = (String)ruleValue;
            check = Collator.getInstance().compare(_valueStr, _ruleValueStr) > 0;
        } else if (value instanceof Comparable && value.getClass().isAssignableFrom(ruleValue.getClass())) {
            check = ((Comparable)value).compareTo(ruleValue) > 0;
        } else if (ruleValue instanceof Comparable && ruleValue.getClass().isAssignableFrom(value.getClass())) {
            check = ((Comparable)ruleValue).compareTo(value) < 0;
        } else {
            throw new KDBizException("greaterThan, left class is : '" + value.getClass().getName() + ", right class is : '" + ruleValue.getClass().getName() + "'");
        }
        return check;
    }

    public static boolean greaterEqual(Object value, Object ruleValue) throws KDBizException {
        return ObjectMatcher.greaterThan(value, ruleValue) || ObjectMatcher.equalObj(value, ruleValue);
    }

    public static boolean lessThan(Object value, Object ruleValue) throws KDBizException {
        if (value == null) {
            throw new KDBizException("value is null");
        }
        if (ruleValue == null) {
            throw new KDBizException("ruleValue is null");
        }
        boolean check = false;
        if (value instanceof Number && ruleValue instanceof Number) {
            Number _value = (Number)value;
            Number _ruleValue = (Number)ruleValue;
            check = _value.doubleValue() < _ruleValue.doubleValue();
        } else if (value instanceof String && ruleValue instanceof String) {
            String _valueStr = (String)value;
            String _ruleValueStr = (String)ruleValue;
            check = Collator.getInstance().compare(_valueStr, _ruleValueStr) < 0;
        } else if (value instanceof Comparable && value.getClass().isAssignableFrom(ruleValue.getClass())) {
            check = ((Comparable)value).compareTo(ruleValue) < 0;
        } else if (ruleValue instanceof Comparable && ruleValue.getClass().isAssignableFrom(value.getClass())) {
            check = ((Comparable)ruleValue).compareTo(value) > 0;
        } else {
            throw new KDBizException("lessThan, left class is : '" + value.getClass().getName() + ", right class is : '" + ruleValue.getClass().getName() + "'");
        }
        return check;
    }

    public static boolean lessEqual(Object value, Object ruleValue) throws KDBizException {
        return ObjectMatcher.lessThan(value, ruleValue) || ObjectMatcher.equalObj(value, ruleValue);
    }

    public static boolean isNull(Object value) {
        return value == null;
    }
}

