/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.obj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.obj.ObjectVoucherUtils;

public class ObjectValueToMap {
    private List<String> properties = new LinkedList<String>();
    private Set<String> propKeys = Sets.newLinkedHashSet();
    private boolean isVoucher = false;
    private Map<Long, DynamicObject> assist = null;
    private Set<String> flexProps = null;
    private Map<String, DynamicObject> flexPropMap = null;
    private List<String> errorMessages = new LinkedList<String>();
    public String emptyEntryErrMessage = null;

    private List<String> getProperties() {
        return this.properties;
    }

    private Set<String> getPropKeys() {
        return this.propKeys;
    }

    private boolean isVoucher() {
        return this.isVoucher;
    }

    protected Map<Long, DynamicObject> getAssist() {
        if (this.assist == null) {
            this.assist = Maps.newLinkedHashMap();
        }
        return this.assist;
    }

    protected Set<String> getFlexProps() {
        if (this.flexProps == null) {
            this.flexProps = Sets.newLinkedHashSet();
        }
        return this.flexProps;
    }

    protected Map<String, DynamicObject> getFlexPropMap() {
        if (this.flexPropMap == null) {
            this.flexPropMap = Maps.newLinkedHashMap();
        }
        return this.flexPropMap;
    }

    public List<String> getErrorMessage() {
        return this.errorMessages;
    }

    public List<Map<String, Object>> execute(DynamicObject model, String[] props) {
        ArrayList<Map<String, Object>> propValues = new ArrayList<Map<String, Object>>();
        if (model == null || props == null || props.length == 0) {
            return propValues;
        }
        this.hasVoucher(model, props);
        this.initProps(props);
        this.flatten(model, propValues, new LinkedHashMap<String, Object>(), null, false);
        if (this.isVoucher()) {
            ObjectVoucherUtils.get().getAssistData(propValues, this.getFlexProps(), this.getFlexPropMap(), this.getAssist(), this.getExtFlexProps(props, this.getFlexProps()));
        }
        return propValues;
    }

    private void initProps(String[] props) {
        this.getProperties().clear();
        for (String property : props) {
            if (property == null || property.trim().length() == 0) continue;
            String[] subProps = property.trim().split("[.]");
            StringBuilder p = new StringBuilder(subProps[0]);
            this.addSubProps(p.toString());
            for (int j = 1; j < subProps.length; ++j) {
                p.append(".").append(subProps[j].trim());
                this.addSubProps(p.toString());
            }
        }
    }

    private void addSubProps(String property) {
        if (this.getPropKeys().add(property)) {
            this.getProperties().add(property);
        }
    }

    private void flatten(DynamicObject model, List<Map<String, Object>> propValues, Map<String, Object> values, String preProp, boolean isIgnoreCollection) {
        String property;
        if (model == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a", (String)"ObjectValueToMap_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (values == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u503c\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"ObjectFilter_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        this.clearObjectValueMap(values, preProp);
        String propName = null;
        String collProName = "";
        IDataEntityType dt = model.getDataEntityType();
        for (IDataEntityProperty prop : dt.getProperties()) {
            if (prop == null || !StringUtils.isNotEmpty(prop.getName()) || this.isFilterProp(property = (StringUtils.isEmpty(preProp) ? "" : preProp + ".") + prop.getName())) continue;
            try {
                Object obj = this.getObject(model, prop.getName(), property);
                if (obj instanceof DynamicObject) {
                    this.putValue(values, property, obj);
                    this.flatten((DynamicObject)obj, propValues, values, property, true);
                    continue;
                }
                if (obj instanceof DynamicObjectCollection) {
                    if (propName == null) {
                        propName = prop.getName();
                        if (model.getDynamicObjectType().getProperty(propName) != null) {
                            collProName = model.getDynamicObjectType().getProperty(propName).getDisplayName().getLocaleValue();
                        }
                        if (!((DynamicObjectCollection)obj).isEmpty()) continue;
                        this.emptyEntryErrMessage = ResManager.loadResFormat((String)"\u9884\u7b97\u63a7\u5236\u5f15\u7528\u4e1a\u52a1\u5355\u636e\u5206\u5f55\u201c%1\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"ObjectFilter_4", (String)"epm-eb-common", (Object[])new Object[]{collProName});
                        continue;
                    }
                    String thisCollProName = "";
                    if (model.getDynamicObjectType().getProperty(prop.getName()) != null) {
                        thisCollProName = model.getDynamicObjectType().getProperty(prop.getName()).getDisplayName().getLocaleValue();
                    }
                    this.errorMessages.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u7684\u4e1a\u52a1\u5b57\u6bb5\u548c\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u7684\u53d6\u503c\u5b57\u6bb5\u4e2d\uff0c\u5305\u542b\u4e1a\u52a1\u5355\u636e\u201c%1\u201d\u4e0e\u201c%2\u201d\u4e24\u4e2a\u6216\u4ee5\u4e0a\u96c6\u5408\u7c7b\u578b\u7684\u5c5e\u6027\uff0c\u8bf7\u4fee\u6539\u81f3\u540c\u4e00\u96c6\u5408\u7c7b\u578b\u7684\u5c5e\u6027\u3002", (String)"ObjectFilter_3", (String)"epm-eb-common", (Object[])new Object[]{collProName, thisCollProName}));
                    continue;
                }
                if (obj instanceof OrmLocaleValue) {
                    this.putValue(values, property, ((OrmLocaleValue)obj).toString());
                    continue;
                }
                if (obj == null) continue;
                this.putValue(values, property, obj);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
        if (!isIgnoreCollection) {
            if (propName != null) {
                DynamicObject object = null;
                property = (StringUtils.isEmpty(preProp) ? "" : preProp + ".") + propName;
                DynamicObjectCollection colls = (DynamicObjectCollection)model.get(propName);
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    object = (DynamicObject)colls.get(i);
                    this.putValue(values, property, object);
                    this.flatten(object, propValues, values, property, false);
                }
            } else {
                LinkedHashMap<String, Object> newValues = new LinkedHashMap<String, Object>(this.getProperties().size());
                for (int i = 0; i < this.getProperties().size(); ++i) {
                    property = this.getProperties().get(i).trim();
                    newValues.put(property, values.get(property));
                }
                propValues.add(newValues);
            }
        }
    }

    private void putValue(Map<String, Object> values, String key, Object value) {
        if (this.getPropKeys().contains(key)) {
            values.put(key, value);
        }
    }

    private void clearObjectValueMap(Map<String, Object> values, String preProp) {
        if (values == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u503c\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"ObjectFilter_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty(preProp)) {
            values.clear();
        } else {
            String _preProp = preProp + ".";
            for (String key : values.keySet()) {
                if (key == null || !key.startsWith(_preProp)) continue;
                values.put(key, null);
            }
        }
    }

    private boolean isFilterProp(String property) {
        return !this.getPropKeys().contains(property);
    }

    private void hasVoucher(DynamicObject model, String[] props) {
        boolean bl = this.isVoucher = model.getDataEntityType() != null && model.getDataEntityType().getName().equals("gl_voucher");
        if (this.isVoucher()) {
            for (String prop : props) {
                String flexNumber = ObjectVoucherUtils.getFlexKey(prop);
                if (flexNumber == null) continue;
                this.getFlexProps().add(flexNumber);
            }
            if (!this.getFlexProps().isEmpty()) {
                this.getFlexPropMap().putAll(ObjectVoucherUtils.getFlexProp(this.getFlexProps()));
            }
        }
    }

    private Object getObject(DynamicObject model, String property, String allProperty) {
        if (model == null || property == null || allProperty == null) {
            return null;
        }
        if (this.isVoucher() && allProperty.equals("entries.assgrp")) {
            Object object = model.get(property);
            if (object instanceof DynamicObject) {
                DynamicObject flexData = (DynamicObject)object;
                this.getAssist().put(flexData.getLong("id"), flexData);
            }
            return object;
        }
        return model.get(property);
    }

    private Map<String, Map<String, String>> getExtFlexProps(String[] props, Set<String> flexProps) {
        if (props == null || props.length == 0 || flexProps == null) {
            return null;
        }
        LinkedHashMap extFlexProps = Maps.newLinkedHashMap();
        int index = "entries.assgrp".length() + 1;
        for (String prop : props) {
            String _prop;
            int tmpIndex;
            if (!prop.startsWith("entries.assgrp") || (tmpIndex = (_prop = prop.substring(index)).indexOf(46)) <= 0) continue;
            String flexNumber = _prop.substring(0, tmpIndex);
            String flexProp = _prop.substring(tmpIndex + 1);
            if (!flexProps.contains(flexNumber)) continue;
            Map extProps = extFlexProps.computeIfAbsent(flexNumber, f -> Maps.newLinkedHashMap());
            extProps.put(flexProp, prop);
        }
        return extFlexProps;
    }
}

