/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.obj;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class ObjectVoucherUtils {
    private static final Log log = LogFactory.getLog(ObjectVoucherUtils.class);
    public static final String flexKey = "entries.assgrp.";
    public static final JavaType javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, Long.class);
    private static final String defaultProps = "id, name, number";

    public static ObjectVoucherUtils get() {
        return new ObjectVoucherUtils();
    }

    public void getAssistData(List<Map<String, Object>> propValues, Set<String> flexProps, Map<String, DynamicObject> flexPropMap, Map<Long, DynamicObject> assist, Map<String, Map<String, String>> extBizProps) {
        Map bizDataMap;
        DynamicObject flexProp;
        long begin = System.nanoTime();
        log.info("budget-control-log : begin-assist-data.");
        if (propValues == null || propValues.isEmpty() || flexProps == null || flexProps.isEmpty() || flexPropMap == null || flexPropMap.isEmpty() || assist == null || assist.isEmpty()) {
            log.info("budget-control-log : begin-assist-data(return).");
            return;
        }
        HashMap flexFieldMap = Maps.newHashMapWithExpectedSize((int)flexPropMap.size());
        for (DynamicObject flexProp2 : flexPropMap.values()) {
            flexFieldMap.put(flexProp2.getString("flexfield"), flexProp2);
        }
        Map<Long, Map<String, Long>> glAssistDataMap = this.getGlAssistData(assist, flexFieldMap.keySet());
        LinkedHashMap assistDataMap = Maps.newLinkedHashMap();
        for (Map<String, Long> dataMap : glAssistDataMap.values()) {
            for (Map.Entry<String, Long> data : dataMap.entrySet()) {
                Set dataIds = assistDataMap.computeIfAbsent(data.getKey(), f -> Sets.newLinkedHashSet());
                dataIds.add(data.getValue());
            }
        }
        HashMap flexDataMap = Maps.newHashMapWithExpectedSize((int)flexPropMap.size());
        for (Map.Entry assistData : assistDataMap.entrySet()) {
            DynamicObject flexSource;
            flexProp = (DynamicObject)flexFieldMap.get(assistData.getKey());
            if (flexProp == null || (flexSource = flexProp.getDynamicObject("valuesource")) == null) continue;
            bizDataMap = this.loadBizData(flexSource.getString("number"), this.getBizProps(extBizProps, flexProp.getString("number")), (Set)assistData.getValue());
            Map _bizDataMap = flexDataMap.computeIfAbsent(flexProp.getString("flexfield"), f -> Maps.newLinkedHashMap());
            _bizDataMap.putAll(bizDataMap);
        }
        LinkedHashMap assistPropValue = Maps.newLinkedHashMap();
        for (Map<String, Object> propValue : propValues) {
            DynamicObject flexData = (DynamicObject)propValue.get("entries.assgrp");
            if (flexData == null) continue;
            assistPropValue.clear();
            Map<String, Long> assistData = this.parseFlexData(flexData.getString("value"), flexFieldMap.keySet());
            if (assistData == null) continue;
            for (Map.Entry<String, Object> prop : propValue.entrySet()) {
                Map<String, String> extBizProp;
                DynamicObject bizObj;
                String flexField;
                String flexNumber = ObjectVoucherUtils.getFlexKey(prop.getKey());
                if (flexNumber == null || (flexProp = flexPropMap.get(flexNumber)) == null || (bizDataMap = (Map)flexDataMap.get(flexField = flexProp.getString("flexfield"))) == null || (bizObj = (DynamicObject)bizDataMap.get(assistData.get(flexField))) == null) continue;
                assistPropValue.put(flexKey + flexNumber, bizObj);
                assistPropValue.put(flexKey + flexNumber + ".number", bizObj.getString("number"));
                assistPropValue.put(flexKey + flexNumber + ".name", bizObj.getString("name"));
                if (extBizProps == null || (extBizProp = extBizProps.get(flexProp.getString("number"))) == null) continue;
                for (Map.Entry<String, String> entry : extBizProp.entrySet()) {
                    assistPropValue.put(entry.getValue(), this.getValue(bizObj.get(entry.getKey())));
                }
            }
            propValue.putAll(assistPropValue);
        }
        log.info("budget-control-log : end-assist-data. use=" + LogUtils.use(begin));
    }

    private Object getValue(Object value) {
        if (value instanceof OrmLocaleValue) {
            return value.toString();
        }
        return value;
    }

    private String getBizProps(Map<String, Map<String, String>> extBizProps, String flexNumber) {
        if (extBizProps == null || flexNumber == null) {
            return defaultProps;
        }
        Map<String, String> bizProps = extBizProps.get(flexNumber);
        if (bizProps != null && !bizProps.isEmpty()) {
            LinkedHashSet props = Sets.newLinkedHashSet();
            props.add("id");
            props.add("number");
            props.add("name");
            props.addAll(bizProps.keySet());
            return StringUtils.join((Collection)props, ',');
        }
        return defaultProps;
    }

    private Map<Object, DynamicObject> loadBizData(String entityNumber, String fields, Set<Long> bizIds) {
        if (entityNumber == null || bizIds == null || bizIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", bizIds)});
    }

    public static Map<String, DynamicObject> getFlexProp(Set<String> flexNumbers) {
        if (flexNumbers == null || flexNumbers.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("number", "in", flexNumbers));
        builder.add(new QFilter("flexid.formid", "=", (Object)"gl_assist"));
        LinkedHashMap flexPropMap = Maps.newLinkedHashMap();
        Map flexMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (QFilter[])builder.toArrays());
        if (flexMap != null) {
            for (DynamicObject flexProp : flexMap.values()) {
                flexPropMap.put(flexProp.getString("number"), flexProp);
            }
        }
        return flexPropMap;
    }

    public static String getFlexKey(String flexProp) {
        int index;
        String flexNumber = null;
        if (flexProp != null && flexProp.startsWith(flexKey) && (index = (flexNumber = flexProp.replaceFirst(flexKey, "")).indexOf(".")) > 0) {
            flexNumber = flexNumber.substring(0, index);
        }
        return flexNumber;
    }

    private Map<Long, Map<String, Long>> getGlAssistData(Map<Long, DynamicObject> assist, Set<String> flexFields) {
        if (assist == null || assist.isEmpty() || flexFields == null || flexFields.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap glAssistMap = Maps.newHashMapWithExpectedSize((int)assist.size());
        for (DynamicObject assistData : assist.values()) {
            Map<String, Long> flexData = this.parseFlexData(assistData.getString("value"), flexFields);
            if (flexData == null || flexData.isEmpty()) continue;
            glAssistMap.put(assistData.getLong("id"), flexData);
        }
        return glAssistMap;
    }

    private Map<String, Long> parseFlexData(String flexValue, Set<String> flexFields) {
        if (flexValue == null || flexFields == null) {
            return null;
        }
        Map _flexData = (Map)JSONUtils.parse(flexValue, javaType);
        if (_flexData != null) {
            // empty if block
        }
        return _flexData;
    }
}

