/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.param;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;

public class BgParamUtils {
    private static final Log log = LogFactory.getLog(BgParamUtils.class);
    public static final String PARAM_CACHE_LEVEL = "PARAM_CACH_LEVEL";
    public static final String PARAM_CACHE_LEVEL_VALUE = "2";
    public static final String MAX_DATAFACT_SIZE = "MAX_DATAFACT_SIZE";
    public static final int MAX_DATAFACT_VALUE = 32;
    private static final String EPM_BUDGET_REMOVE_DATA = "EPM_BUDGET_REMOVE_DATA";
    private static final boolean removeBudgetData = Boolean.parseBoolean(System.getProperty("EPM_BUDGET_REMOVE_DATA", "true"));
    private static final String EPM_BUDGET_DATA_LOG = "EPM_BUDGET_DATA_LOG";
    private static final boolean writeDataOperationLog = Boolean.parseBoolean(System.getProperty("EPM_BUDGET_DATA_LOG", "true"));

    public static String getParamValue(String paramKey) {
        if (paramKey == null) {
            return null;
        }
        String value = null;
        switch (paramKey) {
            case "PARAM_CACH_LEVEL": {
                value = PARAM_CACHE_LEVEL_VALUE;
                break;
            }
        }
        return value;
    }

    public static int getCacheOrgLevel() {
        int level = 1;
        String levelStr = BgParamUtils.getParamValue(PARAM_CACHE_LEVEL);
        if (StringUtils.isEmpty(levelStr)) {
            levelStr = PARAM_CACHE_LEVEL_VALUE;
        }
        try {
            level = Integer.parseInt(levelStr);
        }
        catch (Throwable ex) {
            log.warn("trans cache org level error:", ex);
        }
        return level;
    }

    public static int getPartitionSize() {
        return 32;
    }

    public static boolean isRemoveBudgetData() {
        return removeBudgetData;
    }

    public static boolean isWriteDataOperationLog() {
        return writeDataOperationLog;
    }
}

