/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.period;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodUtils;
import org.apache.commons.lang3.time.DateUtils;

public class BgPeriodHelper {
    public static PeriodType parse(String periodNumber) {
        if (StringUtils.isEmpty(periodNumber)) {
            return null;
        }
        String[] split = periodNumber.split("\\.");
        if (split != null && split.length > 0) {
            String periodStr;
            String yearStr = split[0];
            int year = 1900;
            if (yearStr != null && yearStr.indexOf("FY") == 0) {
                year = Integer.parseInt(yearStr.substring(2));
            }
            if (split.length == 1) {
                return new PeriodType(1, year, 0);
            }
            if (split.length == 2 && (periodStr = split[1]) != null) {
                if (periodStr.indexOf("HF") == 0) {
                    int halfYear = Integer.parseInt(periodStr.substring(2));
                    return new PeriodType(2, year, halfYear);
                }
                if (periodStr.indexOf("Q") == 0) {
                    int quarter = Integer.parseInt(periodStr.substring(1));
                    return new PeriodType(3, year, quarter);
                }
                if (periodStr.indexOf("M") == 0) {
                    int month = Integer.parseInt(periodStr.substring(1));
                    return new PeriodType(4, year, month);
                }
            }
        }
        return null;
    }

    public static PeriodType parseEb(String periodNumber) {
        if (StringUtils.isEmpty(periodNumber)) {
            return null;
        }
        String[] split = periodNumber.split("_");
        if (split != null && split.length > 0) {
            String periodStr;
            String yearStr = split[0];
            int year = 1900;
            if (yearStr != null && yearStr.indexOf("FY") == 0) {
                year = Integer.parseInt(yearStr.substring(2));
            }
            if (split.length == 1) {
                return new PeriodType(1, year, 0);
            }
            if (split.length == 3 && (periodStr = split[2]) != null) {
                if (periodStr.indexOf("HF") == 0) {
                    int halfYear = Integer.parseInt(periodStr.substring(2));
                    return new PeriodType(2, year, halfYear);
                }
                if (periodStr.indexOf("Q") == 0) {
                    int quarter = Integer.parseInt(periodStr.substring(1));
                    return new PeriodType(3, year, quarter);
                }
                if (periodStr.indexOf("M") == 0) {
                    int month = Integer.parseInt(periodStr.substring(1));
                    return new PeriodType(4, year, month);
                }
            }
        }
        return null;
    }

    public static String toPeriodNumber(PeriodType periodType) {
        if (periodType == null) {
            return null;
        }
        String periodNumber = null;
        switch (periodType.getType()) {
            case 1: {
                periodNumber = BgPeriodUtils.getPeriodYear(periodType.getYear());
                break;
            }
            case 2: {
                periodNumber = BgPeriodUtils.getBgPeriodHalfYear(periodType.getYear(), periodType.getPeriod());
                break;
            }
            case 3: {
                periodNumber = BgPeriodUtils.getBgPeriodQuarter(periodType.getYear(), periodType.getPeriod());
                break;
            }
            case 4: {
                periodNumber = BgPeriodUtils.getBgPeriodMonth(periodType.getYear(), periodType.getPeriod());
            }
        }
        return periodNumber;
    }

    public static int comparePeriod(String periodNumber1, String periodNumber2) {
        if (StringUtils.equals(periodNumber1, periodNumber2)) {
            return 0;
        }
        if (StringUtils.isEmpty(periodNumber1)) {
            return -1;
        }
        if (StringUtils.isEmpty(periodNumber2)) {
            return 1;
        }
        try {
            Date date1 = BgPeriodHelper.periodNumberToDate(periodNumber1);
            Date date2 = BgPeriodHelper.periodNumberToDate(periodNumber2);
            return date1.compareTo(date2);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\u7f16\u7801\u4e0d\u6b63\u786e", (String)"DimensionRelationUtils1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public static int compareTo(String bgPeriodNumber1, String bgPeriodNumber2) {
        if (bgPeriodNumber1 == null || bgPeriodNumber2 == null) {
            throw new KDBizException("bgPeriodNumber is not null.");
        }
        int compare = bgPeriodNumber1.equals(bgPeriodNumber2) ? 0 : bgPeriodNumber1.compareTo(bgPeriodNumber2);
        return compare;
    }

    public static boolean compareType(String bgPeriodNumber1, String bgPeriodNumber2) {
        boolean re;
        block6: {
            String[] tmpStr2;
            String[] tmpStr1;
            block5: {
                if (StringUtils.isEmpty(bgPeriodNumber1) || StringUtils.isEmpty(bgPeriodNumber2)) {
                    return false;
                }
                tmpStr1 = bgPeriodNumber1.split("\\.");
                if (tmpStr1.length != (tmpStr2 = bgPeriodNumber2.split("\\.")).length) {
                    return false;
                }
                re = true;
                if (tmpStr1.length <= 1) break block5;
                char[] bytes1 = tmpStr1[1].toCharArray();
                char[] bytes2 = tmpStr2[1].toCharArray();
                for (int i = 0; i < 2 && re; ++i) {
                    boolean isChar1 = Character.isLetter(bytes1[i]);
                    boolean isChar2 = Character.isLetter(bytes2[i]);
                    if (isChar1 && isChar2) {
                        re = bytes1[i] == bytes2[i];
                        continue;
                    }
                    if (isChar1 == isChar2) continue;
                    re = false;
                }
                break block6;
            }
            if (tmpStr1.length <= 0) break block6;
            char[] bytes1 = tmpStr1[0].toCharArray();
            char[] bytes2 = tmpStr2[0].toCharArray();
            for (int i = 0; i < 2 && re; ++i) {
                re = bytes1[i] == bytes2[i];
            }
        }
        return re;
    }

    public static Date periodNumberToDate(String number) {
        return BgPeriodHelper.periodNumberToDate(number, false);
    }

    public static Date periodNumberToDate(String number, boolean isEb) {
        Date date = null;
        String format = "yyyy-MM-dd";
        try {
            PeriodType periodType;
            PeriodType periodType2 = periodType = isEb ? BgPeriodHelper.parseEb(number) : BgPeriodHelper.parse(number);
            if (periodType == null) {
                return null;
            }
            int year = periodType.getYear();
            if (periodType.getType() == 1) {
                String dateStr = year + "-12-31";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 2 && periodType.getPeriod() == 1) {
                String dateStr = year + "-06-30";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 2 && periodType.getPeriod() == 2) {
                String dateStr = year + "-12-30";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 1) {
                String dateStr = year + "-03-15";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 2) {
                String dateStr = year + "-06-15";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 3) {
                String dateStr = year + "-09-15";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 4) {
                String dateStr = year + "-12-15";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 4) {
                String dateStr = year + "-" + periodType.getPeriod() + "-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static class PeriodType {
        private int type;
        private int year;
        private int period;

        PeriodType(int type, int year, int period) {
            this.type = type;
            this.year = year;
            this.period = period;
        }

        public int getType() {
            return this.type;
        }

        public int getYear() {
            return this.year;
        }

        public int getPeriod() {
            return this.period;
        }

        public static PeriodType of(int type, int year, int period) {
            return new PeriodType(type, year, period);
        }
    }
}

